/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.editor;

import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.cnd.api.makefile.MakefileElement;
import org.netbeans.modules.cnd.api.makefile.MakefileMacro;
import org.netbeans.modules.cnd.api.makefile.MakefileRule;
import org.netbeans.modules.cnd.api.makefile.MakefileSupport;
import org.netbeans.modules.cnd.api.script.MakefileTokenId;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class MakefileHyperlinkProvider
implements HyperlinkProvider {
    public boolean isHyperlinkPoint(Document doc, int offset) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        return tokenHierarchy != null && MakefileHyperlinkProvider.findHyperlinkToken(tokenHierarchy, offset) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset) {
        HyperlinkToken token;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        if (tokenHierarchy != null && (token = MakefileHyperlinkProvider.findHyperlinkToken(tokenHierarchy, offset)) != null) {
            return new int[]{token.offset, token.offset + token.text.length()};
        }
        return null;
    }

    public void performClickAction(Document doc, int offset) {
        HyperlinkToken token;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        if (tokenHierarchy != null && (token = MakefileHyperlinkProvider.findHyperlinkToken(tokenHierarchy, offset)) != null) {
            switch (token.kind) {
                case RULE: 
                case MACRO: {
                    MakefileHyperlinkProvider.findAndOpenElement(doc, token);
                    break;
                }
                case INCLUDE: {
                    FileObject fileObject = NbEditorUtilities.getFileObject((Document)doc);
                    if (fileObject == null) break;
                    MakefileHyperlinkProvider.findAndOpenFile(fileObject.getParent(), token.text);
                }
            }
        }
    }

    private static HyperlinkToken findHyperlinkToken(TokenHierarchy<?> tokenHierarchy, int offset) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(MakefileTokenId.language());
        if (tokenSequence != null) {
            Token token;
            tokenSequence.move(offset);
            if (tokenSequence.moveNext() && (token = tokenSequence.token()) != null) {
                switch ((MakefileTokenId)token.id()) {
                    case BARE: {
                        return MakefileHyperlinkProvider.analyzeBareToken((TokenSequence<MakefileTokenId>)tokenSequence, (Token<MakefileTokenId>)token, offset);
                    }
                    case MACRO: {
                        return MakefileHyperlinkProvider.analyzeMacroToken((TokenSequence<MakefileTokenId>)tokenSequence, (Token<MakefileTokenId>)token, offset);
                    }
                }
            }
        }
        return null;
    }

    private static HyperlinkToken analyzeBareToken(TokenSequence<MakefileTokenId> tokenSequence, Token<MakefileTokenId> token, int offset) {
        String text = token.text().toString();
        int tokenOffset = tokenSequence.offset();
        MakefileElement.Kind kind = MakefileElement.Kind.RULE;
        block8: while (tokenSequence.movePrevious()) {
            Token prevToken = tokenSequence.token();
            switch ((MakefileTokenId)prevToken.id()) {
                case BARE: 
                case MACRO: 
                case WHITESPACE: {
                    continue block8;
                }
                case INCLUDE: {
                    kind = MakefileElement.Kind.INCLUDE;
                    break;
                }
            }
            break;
        }
        tokenSequence.move(offset);
        block9: while (tokenSequence.moveNext()) {
            Token nextToken = tokenSequence.token();
            switch ((MakefileTokenId)nextToken.id()) {
                case BARE: 
                case MACRO: 
                case WHITESPACE: {
                    continue block9;
                }
                case EQUALS: 
                case COLON_EQUALS: 
                case PLUS_EQUALS: {
                    kind = MakefileElement.Kind.MACRO;
                    break;
                }
            }
            break;
        }
        return new HyperlinkToken(text, tokenOffset, kind);
    }

    private static HyperlinkToken analyzeMacroToken(TokenSequence<MakefileTokenId> tokenSequence, Token<MakefileTokenId> token, int offset) {
        String text = token.text().toString();
        int tokenOffset = tokenSequence.offset();
        if ((text.startsWith("$(") && text.endsWith(")") || text.startsWith("${") && text.endsWith("}")) && tokenOffset + 2 <= offset && offset < tokenOffset + text.length() - 1) {
            text = text.substring(2, text.length() - 1);
            return new HyperlinkToken(text, tokenOffset + 2, MakefileElement.Kind.MACRO);
        }
        return null;
    }

    private static void findAndOpenFile(FileObject baseDir, String targetPath) {
        while (baseDir != null) {
            FileObject fileObject = baseDir.getFileObject(targetPath);
            if (fileObject != null) {
                MakefileHyperlinkProvider.asyncOpenInEditor(fileObject, 0);
                break;
            }
            baseDir = baseDir.getParent();
        }
    }

    private static void findAndOpenElement(Document doc, HyperlinkToken token) {
        try {
            List<MakefileElement> elements = MakefileSupport.parseDocument(doc);
            for (MakefileElement element : elements) {
                if (element.getKind() == MakefileElement.Kind.RULE && token.kind == MakefileElement.Kind.RULE) {
                    MakefileRule rule = (MakefileRule)element;
                    if (!rule.getTargets().contains(token.text)) continue;
                    MakefileHyperlinkProvider.asyncOpenInEditor(doc, rule.getStartOffset());
                } else {
                    MakefileMacro macro;
                    if (element.getKind() != MakefileElement.Kind.MACRO || token.kind != MakefileElement.Kind.MACRO || !(macro = (MakefileMacro)element).getName().equals(token.text)) continue;
                    MakefileHyperlinkProvider.asyncOpenInEditor(doc, macro.getStartOffset());
                }
                break;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private static void asyncOpenInEditor(Document doc, int offset) {
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)doc);
        if (dataObject != null) {
            MakefileHyperlinkProvider.asyncOpenIdEditor(dataObject, doc, offset);
        }
    }

    private static void asyncOpenInEditor(FileObject fileObject, int offset) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            MakefileHyperlinkProvider.asyncOpenInEditor(dataObject, offset);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void asyncOpenInEditor(DataObject dataObject, int offset) {
        EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
        if (editorCookie != null) {
            try {
                StyledDocument doc = editorCookie.openDocument();
                MakefileHyperlinkProvider.asyncOpenIdEditor(dataObject, doc, offset);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static void asyncOpenIdEditor(final DataObject dataObject, final Document doc, final int offset) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
                if (lineCookie != null) {
                    try {
                        int lineIdx = Utilities.getLineOffset((BaseDocument)((BaseDocument)doc), (int)offset);
                        Line line = lineCookie.getLineSet().getCurrent(lineIdx);
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private static final class HyperlinkToken {
        private final String text;
        private final int offset;
        private final MakefileElement.Kind kind;

        private HyperlinkToken(String text, int offset, MakefileElement.Kind kind) {
            this.text = text;
            this.offset = offset;
            this.kind = kind;
        }
    }
}

