/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.util.ZipUtils;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.PackageItem;
import com.sun.javacard.validator.Validator;
import java.io.File;
import java.util.Hashtable;

public abstract class FolderOrJar
extends PackageItem {
    public static Hashtable<String, String> folderMappingsForJarFiles = new Hashtable();
    protected File folder;

    public FolderOrJar(String string) {
        this.folder = new File(string);
    }

    @Override
    public void initialize() {
        if (!this.isOk()) {
            return;
        }
        if (this.folder.exists() && this.folder.isFile()) {
            File file = this.folder;
            this.folder = new File(Validator.getWorkDir(), file.getName().replace('.', '_'));
            this.folder.mkdirs();
            if (!this.folder.exists()) {
                this.addError(ErrorKey.UnableToCreateTempFolder, this.folder);
                return;
            }
            this.folder.mkdirs();
            this.folder.deleteOnExit();
            try {
                ZipUtils.unzip(file, this.folder);
            }
            catch (Exception exception) {
                this.addError(ErrorKey.UnableToExtractTheFile, file, exception.getLocalizedMessage());
                return;
            }
            folderMappingsForJarFiles.put(this.folder.toString(), file.getAbsoluteFile().toString() + "!");
        }
        if (!this.folder.exists()) {
            this.addError(ErrorKey.DoesNotExists, this.folder);
            return;
        }
        if (!this.folder.isDirectory()) {
            this.addError(ErrorKey.IsNotADirectory, this.folder);
            return;
        }
    }

    public void setFolder(File file) {
        this.folder = file;
    }

    public File getFolder() {
        return this.folder;
    }
}

