/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variadic;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public class PHP56UnhandledError
extends UnhandledErrorRule {
    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP56UnhandledError.appliesTo(fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            errors.addAll(checkVisitor.getErrors());
        }
    }

    private static boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhpVersionLessThan(fileObject, PhpVersion.PHP_56);
    }

    public String getDisplayName() {
        return Bundle.PHP56VersionErrorHintDispName();
    }

    private static final class PHP56VersionError
    extends VerificationError {
        private static final String KEY = "Php.Version.56";

        private PHP56VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.CheckPHP56VerDisp();
        }

        public String getDescription() {
            return Bundle.CheckPHP56VerDesc();
        }

        public String getKey() {
            return KEY;
        }
    }

    private static class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors() {
            return Collections.unmodifiableCollection(this.errors);
        }

        private static boolean isStaticScalarExpression(ASTNode node) {
            return node instanceof InfixExpression || node instanceof ConditionalExpression;
        }

        @Override
        public void visit(FormalParameter node) {
            Expression defaultValue;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isVariadic()) {
                this.createError(node);
            }
            if (CheckVisitor.isStaticScalarExpression(defaultValue = node.getDefaultValue())) {
                this.createError(defaultValue);
            }
        }

        @Override
        public void visit(InfixExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (InfixExpression.OperatorType.POW.equals((Object)node.getOperator())) {
                this.createError(node);
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(Assignment node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (Assignment.Type.POW_EQUAL.equals((Object)node.getOperator())) {
                this.createError(node);
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(ConstantDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            for (Expression expression : node.getInitializers()) {
                if (CheckVisitor.isStaticScalarExpression(expression) || expression instanceof ArrayCreation || expression instanceof ExpressionArrayAccess) {
                    this.createError(expression);
                    continue;
                }
                this.scan(expression);
            }
        }

        @Override
        public void visit(Variadic node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.createError(node);
        }

        @Override
        public void visit(UseStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (UseStatement.Type.CONST.equals((Object)node.getType()) || UseStatement.Type.FUNCTION.equals((Object)node.getType())) {
                this.createError(node);
            }
        }

        @Override
        public void visit(ExpressionArrayAccess node) {
            Identifier identifier;
            String name;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Expression expression = node.getExpression();
            if (expression instanceof Identifier && !NavUtils.isQuoted(name = (identifier = (Identifier)expression).getName())) {
                this.createError(node);
            }
            this.scan(node.getDimension());
        }

        private void createError(int startOffset, int endOffset) {
            PHP56VersionError error = new PHP56VersionError(this.fileObject, startOffset, endOffset);
            this.errors.add(error);
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
            super.visit(node);
        }
    }
}

