/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.configurations;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Platforms;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.netbeans.modules.cnd.makeproject.ui.configurations.LibraryOptionPanel;
import org.netbeans.modules.cnd.makeproject.ui.configurations.MakeArtifactChooser;
import org.netbeans.modules.cnd.makeproject.ui.configurations.PkgConfigLibrary;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StdLibPanel;
import org.netbeans.modules.cnd.makeproject.ui.configurations.TableEditorPanel;
import org.netbeans.modules.cnd.makeproject.ui.utils.PathPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LibrariesPanel
extends JPanel
implements HelpCtx.Provider,
PropertyChangeListener {
    private final Project project;
    private final MakeConfiguration conf;
    private final MyListEditorPanel myListEditorPanel;
    private final FSPath baseDir;
    private final PropertyEditorSupport editor;
    private final JButton addProjectButton;
    private final JButton addStandardLibraryButton;
    private final JButton addPkgConfigLibraryButton;
    private final JButton addLibraryButton;
    private final JButton addLibraryFileButton;
    private final JButton addLibraryOption;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JPanel outerPanel;

    public LibrariesPanel(Project project, MakeConfiguration conf, FSPath baseDir, List<LibraryItem> data, PropertyEditorSupport editor, PropertyEnv env) {
        this.project = project;
        this.conf = conf;
        this.baseDir = baseDir;
        this.editor = editor;
        this.initComponents();
        this.addProjectButton = new JButton(LibrariesPanel.getString("ADD_PROJECT_BUTTON_TXT"));
        this.addProjectButton.setToolTipText(LibrariesPanel.getString("ADD_PROJECT_BUTTON_TT"));
        this.addProjectButton.setMnemonic(LibrariesPanel.getString("ADD_PROJECT_BUTTON_MN").charAt(0));
        this.addStandardLibraryButton = new JButton(LibrariesPanel.getString("ADD_STANDARD_LIBRARY_BUTTON_TXT"));
        this.addStandardLibraryButton.setToolTipText(LibrariesPanel.getString("ADD_STANDARD_LIBRARY_BUTTON_TT"));
        this.addStandardLibraryButton.setMnemonic(LibrariesPanel.getString("ADD_STANDARD_LIBRARY_BUTTON_MN").charAt(0));
        this.addPkgConfigLibraryButton = new JButton(LibrariesPanel.getString("ADD_PKG_CONFIG_LIBRARY_BUTTON_TXT"));
        this.addPkgConfigLibraryButton.setToolTipText(LibrariesPanel.getString("ADD_PKG_CONFIG_LIBRARY_BUTTON_TT"));
        this.addPkgConfigLibraryButton.setMnemonic(LibrariesPanel.getString("ADD_PKG_CONFIG_LIBRARY_BUTTON_MN").charAt(0));
        this.addLibraryButton = new JButton(LibrariesPanel.getString("ADD_LIBRARY_BUTTON_TXT"));
        this.addLibraryButton.setToolTipText(LibrariesPanel.getString("ADD_LIBRARY_BUTTON_TT"));
        this.addLibraryButton.setMnemonic(LibrariesPanel.getString("ADD_LIBRARY_BUTTON_MN").charAt(0));
        this.addLibraryFileButton = new JButton(LibrariesPanel.getString("ADD_LIBRARY_FILE_BUTTON_TXT"));
        this.addLibraryFileButton.setToolTipText(LibrariesPanel.getString("ADD_LIBRARY_FILE_BUTTON_TT"));
        this.addLibraryFileButton.setMnemonic(LibrariesPanel.getString("ADD_LIBRARY_FILE_BUTTON_MN").charAt(0));
        this.addLibraryOption = new JButton(LibrariesPanel.getString("ADD_OPTION_BUTTON_TXT"));
        this.addLibraryOption.setToolTipText(LibrariesPanel.getString("ADD_OPTION_BUTTON_TT"));
        this.addLibraryOption.setMnemonic(LibrariesPanel.getString("ADD_OPTION_BUTTON_MN").charAt(0));
        JButton[] extraButtons = new JButton[]{this.addProjectButton, this.addStandardLibraryButton, this.addPkgConfigLibraryButton, this.addLibraryButton, this.addLibraryFileButton, this.addLibraryOption};
        this.myListEditorPanel = new MyListEditorPanel(conf, data, extraButtons);
        this.addProjectButton.addActionListener(new AddProjectButtonAction());
        this.addStandardLibraryButton.addActionListener(new AddStandardLibraryButtonAction());
        this.addPkgConfigLibraryButton.addActionListener(new AddPkgCongigLibraryButtonAction());
        this.addLibraryButton.addActionListener(new AddLibraryButtonAction());
        this.addLibraryOption.addActionListener(new AddLinkerOptionButtonAction());
        this.addLibraryFileButton.addActionListener(new AddLibraryFileButtonAction());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.outerPanel.add((Component)((Object)this.myListEditorPanel), gridBagConstraints);
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.setPreferredSize(new Dimension(700, 450));
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void setInstructionsText(String txt) {
        this.instructionsTextArea.setText(txt);
    }

    private List<LibraryItem> getListData() {
        return this.myListEditorPanel.getListData();
    }

    private ArrayList<LibraryItem> getPropertyValue() throws IllegalStateException {
        return new ArrayList<LibraryItem>(this.getListData());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Libraries");
    }

    private void initComponents() {
        this.outerPanel = new JPanel();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(323, 223));
        this.outerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.outerPanel, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 12, 0, 12);
        this.add((Component)this.instructionPanel, gridBagConstraints);
    }

    private static String getString(String s) {
        return NbBundle.getBundle(LibrariesPanel.class).getString(s);
    }

    private final class AddLinkerOptionButtonAction
    implements ActionListener {
        private AddLinkerOptionButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            LibraryOptionPanel libraryOptionPanel = new LibraryOptionPanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)libraryOptionPanel, LibrariesPanel.getString("SELECT_OPTION_DIALOG_TITLE"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            if (libraryOptionPanel.getOption(LibrariesPanel.this.conf).trim().length() == 0) {
                return;
            }
            LibrariesPanel.this.myListEditorPanel.addObjectAction(new LibraryItem.OptionItem(libraryOptionPanel.getOption(LibrariesPanel.this.conf)));
        }
    }

    private final class AddLibraryFileButtonAction
    implements ActionListener {
        private FileFilter lastSelectedFilter = null;

        private AddLibraryFileButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String chooser_key = "AddLibraryFile";
            ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)LibrariesPanel.this.baseDir.getFileSystem());
            String seed = RemoteFileChooserUtil.getCurrentChooserFile((String)"AddLibraryFile", (ExecutionEnvironment)env);
            if (seed == null) {
                seed = LibrariesPanel.this.baseDir.getPath();
            }
            FileFilter[] filters = FileFilterFactory.getLibraryFilters((FileSystem)LibrariesPanel.this.baseDir.getFileSystem());
            if (this.lastSelectedFilter == null) {
                this.lastSelectedFilter = filters[0];
            }
            JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)env, (String)LibrariesPanel.getString("SELECT_LIBRARY_FILE_CHOOSER_TITLE"), (String)LibrariesPanel.getString("SELECT_CHOOSER_BUTTON"), (int)0, (FileFilter[])filters, (String)seed, (boolean)true);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setFileFilter(this.lastSelectedFilter);
            PathPanel pathPanel = new PathPanel();
            fileChooser.setAccessory(pathPanel);
            int ret = fileChooser.showOpenDialog(null);
            if (ret == 1) {
                return;
            }
            this.lastSelectedFilter = fileChooser.getFileFilter();
            File[] files = fileChooser.getSelectedFiles();
            if (files == null || files.length == 0) {
                return;
            }
            File selectedFolder = files[0].getParentFile();
            RemoteFileChooserUtil.setCurrentChooserFile((String)"AddLibraryFile", (String)selectedFolder.getPath(), (ExecutionEnvironment)env);
            for (File libFile : files) {
                String path = ProjectSupport.toProperPath((FileObject)LibrariesPanel.this.baseDir.getFileObject(), (String)libFile.getPath(), (Project)LibrariesPanel.this.project);
                path = CndPathUtilities.normalizeSlashes((String)path);
                LibrariesPanel.this.myListEditorPanel.addObjectAction(new LibraryItem.LibFileItem(path));
            }
        }
    }

    private final class AddLibraryButtonAction
    implements ActionListener {
        private FileFilter lastSelectedFilter = null;

        private AddLibraryButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String chooser_key = "AddLibrary";
            ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)LibrariesPanel.this.baseDir.getFileSystem());
            String seed = RemoteFileChooserUtil.getCurrentChooserFile((String)"AddLibrary", (ExecutionEnvironment)env);
            if (seed == null) {
                seed = LibrariesPanel.this.baseDir.getPath();
            }
            FileFilter[] filters = FileFilterFactory.getLibraryFilters((FileSystem)LibrariesPanel.this.baseDir.getFileSystem());
            if (this.lastSelectedFilter == null) {
                this.lastSelectedFilter = filters[0];
            }
            JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)env, (String)LibrariesPanel.getString("SELECT_LIBRARY_CHOOSER_TITLE"), (String)LibrariesPanel.getString("SELECT_CHOOSER_BUTTON"), (int)0, (FileFilter[])filters, (String)seed, (boolean)true);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setFileFilter(this.lastSelectedFilter);
            int ret = fileChooser.showOpenDialog((Component)((Object)LibrariesPanel.this.myListEditorPanel));
            if (ret == 1) {
                return;
            }
            this.lastSelectedFilter = fileChooser.getFileFilter();
            File[] files = fileChooser.getSelectedFiles();
            if (files == null || files.length == 0) {
                return;
            }
            File selectedFolder = files[0].getParentFile();
            RemoteFileChooserUtil.setCurrentChooserFile((String)"AddLibrary", (String)selectedFolder.getPath(), (ExecutionEnvironment)env);
            for (File libFile : files) {
                String libName = libFile.getName();
                if (libName.startsWith("lib")) {
                    libName = libName.substring(3);
                }
                if (libName.endsWith(".so") || libName.endsWith(".dll") || libName.endsWith(".dylib") || libName.endsWith(".lib") || libName.endsWith(".a")) {
                    int i = libName.lastIndexOf(46);
                    libName = libName.substring(0, i);
                }
                LibrariesPanel.this.myListEditorPanel.addObjectAction(new LibraryItem.LibItem(libName));
            }
        }
    }

    private final class AddPkgCongigLibraryButtonAction
    implements ActionListener {
        private AddPkgCongigLibraryButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JButton okButton = new JButton(LibrariesPanel.getString("PkgConfigLibrary_CTL_OK"));
            JButton cancel = new JButton(LibrariesPanel.getString("PkgConfigLibrary_CTL_Cancel"));
            PkgConfigLibrary stdLibPanel = new PkgConfigLibrary(LibrariesPanel.this.conf.getDevelopmentHost().getExecutionEnvironment(), okButton);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)stdLibPanel, LibrariesPanel.getString("SELECT_STATNDARD_LIBRARY_DIALOG_TITLE"));
            Object[] options = new Object[]{okButton, cancel};
            dialogDescriptor.setOptions(options);
            dialogDescriptor.setClosingOptions(options);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() != okButton) {
                return;
            }
            PkgConfigManager.PackageConfiguration[] libs = stdLibPanel.getPkgConfigLibs();
            for (int i = 0; i < libs.length; ++i) {
                LibrariesPanel.this.myListEditorPanel.addObjectAction(new LibraryItem.OptionItem("`pkg-config --libs " + libs[i].getName() + "`"));
            }
        }
    }

    private final class AddStandardLibraryButtonAction
    implements ActionListener {
        private AddStandardLibraryButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            StdLibPanel stdLibPanel = new StdLibPanel(Platforms.getPlatform((int)LibrariesPanel.this.conf.getDevelopmentHost().getBuildPlatform()).getStandardLibraries());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)stdLibPanel, LibrariesPanel.getString("SELECT_STATNDARD_LIBRARY_DIALOG_TITLE"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            LibraryItem.StdLibItem[] libs = stdLibPanel.getSelectedStdLibs();
            for (int i = 0; i < libs.length; ++i) {
                LibrariesPanel.this.myListEditorPanel.addObjectAction(libs[i]);
            }
        }
    }

    private final class AddProjectButtonAction
    implements ActionListener {
        private AddProjectButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MakeArtifact[] artifacts = MakeArtifactChooser.showDialog(MakeArtifactChooser.ArtifactType.LIBRARY, LibrariesPanel.this.project, LibrariesPanel.this.baseDir, (Component)((Object)LibrariesPanel.this.myListEditorPanel));
            if (artifacts != null) {
                for (int i = 0; i < artifacts.length; ++i) {
                    String location = ProjectSupport.toProperPath((FileObject)LibrariesPanel.this.baseDir.getFileObject(), (String)artifacts[i].getProjectLocation(), (Project)LibrariesPanel.this.project);
                    String workingdir = ProjectSupport.toProperPath((FileObject)LibrariesPanel.this.baseDir.getFileObject(), (String)artifacts[i].getWorkingDirectory(), (Project)LibrariesPanel.this.project);
                    location = CndPathUtilities.normalizeSlashes((String)location);
                    workingdir = CndPathUtilities.normalizeSlashes((String)workingdir);
                    artifacts[i].setProjectLocation(location);
                    artifacts[i].setWorkingDirectory(workingdir);
                    LibrariesPanel.this.myListEditorPanel.addObjectAction(new LibraryItem.ProjectItem(artifacts[i]));
                }
            }
        }
    }

    private class MyListEditorPanel
    extends TableEditorPanel {
        public MyListEditorPanel(MakeConfiguration conf, List<LibraryItem> objects, JButton[] extraButtons) {
            super(conf, objects, extraButtons, LibrariesPanel.this.baseDir);
            this.getAddButton().setVisible(false);
            this.getEditButton().setVisible(false);
            this.getDefaultButton().setVisible(false);
        }

        public String getListLabelText() {
            return LibrariesPanel.getString("LIBRARIES_AND_OPTIONS_TXT");
        }

        public char getListLabelMnemonic() {
            return LibrariesPanel.getString("LIBRARIES_AND_OPTIONS_MN").charAt(0);
        }

        public LibraryItem copyAction(LibraryItem o) {
            LibraryItem libraryItem = o;
            return libraryItem.clone();
        }
    }
}

