/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.FileNameMatcher;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.openide.filesystems.FileObject;

public final class FolderSearchInfo
extends SearchInfoDefinition {
    private final Folder folder;

    FolderSearchInfo(Folder folder) {
        this.folder = folder;
    }

    public boolean canSearch() {
        return true;
    }

    public List<SearchRoot> getSearchRoots() {
        Set set = this.folder.getAllItemsAsFileObjectSet(false, new Folder.FileObjectNameMatcher(){

            public boolean pathMatches(FileObject fileObject) {
                return true;
            }

            public boolean isTerminated() {
                return false;
            }
        });
        HashSet<FileObject> roots = new HashSet<FileObject>();
        for (FileObject fo2 : set) {
            FileObject parent = fo2.getParent();
            if (parent == null) continue;
            boolean found = false;
            for (FileObject curr = parent; curr != null; curr = curr.getParent()) {
                if (!roots.contains(curr)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ArrayList list = new ArrayList(roots);
            roots.clear();
            for (FileObject fo22 : list) {
                FileObject parent2;
                boolean found2 = false;
                for (FileObject curr2 = parent2 = fo22.getParent(); curr2 != null; curr2 = curr2.getParent()) {
                    if (!parent.equals(curr2)) continue;
                    found2 = true;
                    break;
                }
                if (found2) continue;
                roots.add(fo22);
            }
            roots.add(parent);
        }
        ArrayList<SearchRoot> res = new ArrayList<SearchRoot>();
        roots.forEach(fo -> res.add(new SearchRoot(fo, null)));
        return res;
    }

    public Iterator<FileObject> filesToSearch(SearchScopeOptions options, SearchListener listener, AtomicBoolean terminated) {
        return this.folder.getAllItemsAsFileObjectSet(false, (Folder.FileObjectNameMatcher)new FileObjectNameMatcherImpl(options, terminated)).iterator();
    }

    public static final class FileObjectNameMatcherImpl
    implements Folder.FileObjectNameMatcher {
        private final SearchScopeOptions options;
        private final AtomicBoolean terminated;
        private final FileNameMatcher delegate;

        public FileObjectNameMatcherImpl(SearchScopeOptions options, AtomicBoolean terminated) {
            this.options = options;
            this.terminated = terminated;
            this.delegate = FileNameMatcher.create((SearchScopeOptions)options);
        }

        public boolean pathMatches(FileObject fileObject) {
            if (this.delegate.pathMatches(fileObject)) {
                for (SearchFilterDefinition filter : this.options.getFilters()) {
                    if (filter.searchFile(fileObject)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean isTerminated() {
            return this.terminated.get();
        }
    }
}

