/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.repository.HgURL;
import org.netbeans.modules.mercurial.remote.ui.repository.Repository;
import org.netbeans.modules.mercurial.remote.ui.repository.RepositoryConnection;
import org.netbeans.modules.mercurial.remote.ui.wizards.WizardStepProgressSupport;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CloneRepositoryWizardPanel
implements WizardDescriptor.AsynchronousValidatingPanel,
ChangeListener {
    private JComponent component;
    private Repository repository;
    private boolean valid;
    private String errorMessage;
    private WizardStepProgressSupport support;
    private final VCSFileProxy root;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public CloneRepositoryWizardPanel(VCSFileProxy root) {
        this.root = root;
        this.support = new RepositoryStepProgressSupport();
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new JPanel(new BorderLayout());
            if (this.root != null) {
                this.repository = new Repository(100, CloneRepositoryWizardPanel.getMessage("CTL_Repository_Location"), false, this.root);
                this.repository.addChangeListener(this);
                this.support = new RepositoryStepProgressSupport();
                this.component.add((Component)this.repository.getPanel(), "Center");
                this.component.add((Component)this.support.getProgressComponent(), "South");
            }
            this.component.setName(CloneRepositoryWizardPanel.getMessage("repositoryPanel.Name"));
            this.valid();
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(CloneRepositoryWizardPanel.class);
    }

    private static String getMessage(String msgKey) {
        return NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)msgKey);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (this.root != null) {
            if (this.repository.isValid()) {
                this.valid(this.repository.getMessage());
            } else {
                this.invalid(this.repository.getMessage());
            }
        } else {
            this.invalid(NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"NO_CONNECTED_REMOTE_FS"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    protected final void valid() {
        this.setValid(true, null);
    }

    protected final void valid(String extErrorMessage) {
        this.setValid(true, extErrorMessage);
    }

    protected final void invalid(String message) {
        this.setValid(false, message);
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    private void displayErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException("<null> message");
        }
        if (!errorMessage.equals(this.errorMessage)) {
            this.errorMessage = errorMessage;
            this.fireChangeEvent();
        }
    }

    private void setValid(boolean valid, String errorMessage) {
        if (errorMessage != null && errorMessage.length() == 0) {
            errorMessage = null;
        }
        boolean fire = this.valid != valid;
        boolean bl = errorMessage != null && !errorMessage.equals(this.errorMessage);
        this.valid = valid;
        this.errorMessage = errorMessage;
        if (fire |= bl) {
            this.fireChangeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateBeforeNext() throws WizardValidationException {
        if (this.repository == null) {
            return;
        }
        try {
            HgURL url;
            try {
                url = this.repository.getUrl();
            }
            catch (URISyntaxException ex) {
                throw new WizardValidationException(this.component, ex.getMessage(), ex.getLocalizedMessage());
            }
            if (this.support == null) {
                this.support = new RepositoryStepProgressSupport();
                this.component.add((Component)this.support.getProgressComponent(), "South");
            }
            this.support.setRepositoryRoot(url);
            RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(url);
            RequestProcessor.Task task = this.support.start(rp, url, NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"BK2012"));
            task.waitFinished();
        }
        finally {
            if (this.support != null) {
                this.component.remove(this.support.getProgressComponent());
                this.support = null;
            }
        }
    }

    public final void validate() throws WizardValidationException {
        try {
            this.validateBeforeNext();
            if (!this.isValid() || this.errorMessage != null) {
                throw new WizardValidationException(this.component, this.errorMessage, this.errorMessage);
            }
        }
        catch (WizardValidationException ex) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CloneRepositoryWizardPanel.this.repository != null) {
                        CloneRepositoryWizardPanel.this.repository.setEditable(true);
                    }
                }
            });
            throw ex;
        }
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
        if (settings instanceof WizardDescriptor) {
            try {
                ((WizardDescriptor)settings).putProperty("repository", (Object)this.repository.getUrl());
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "storeSettings", ex);
            }
        }
    }

    public void prepareValidation() {
        this.errorMessage = null;
        this.repository.setEditable(false);
    }

    private void storeHistory() {
        RepositoryConnection rc = this.getRepositoryConnection();
        if (rc != null) {
            HgModuleConfig.getDefault(this.root).insertRecentUrl(rc);
        }
    }

    private RepositoryConnection getRepositoryConnection() {
        try {
            return this.repository.getRepositoryConnection();
        }
        catch (Exception ex) {
            this.displayErrorMessage(ex.getLocalizedMessage());
            return null;
        }
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    private class RepositoryStepProgressSupport
    extends WizardStepProgressSupport {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform() {
            RepositoryConnection rc = CloneRepositoryWizardPanel.this.getRepositoryConnection();
            if (rc == null) {
                return;
            }
            String invalidMsg = null;
            HttpURLConnection con = null;
            try {
                URL url;
                HgURL hgUrl = this.getRepositoryRoot();
                HgURL.Scheme uriSch = hgUrl.getScheme();
                if (uriSch == HgURL.Scheme.FILE) {
                    VCSFileProxy f = HgURL.getFile(CloneRepositoryWizardPanel.this.root, hgUrl);
                    if (!f.exists() || !VCSFileProxySupport.canRead((VCSFileProxy)f)) {
                        invalidMsg = CloneRepositoryWizardPanel.getMessage("MSG_Progress_Clone_CannotAccess_Err");
                        return;
                    }
                } else if ((uriSch == HgURL.Scheme.HTTP || uriSch == HgURL.Scheme.HTTPS) && (con = (HttpURLConnection)(url = hgUrl.toURL()).openConnection()) != null) {
                    boolean bNoUserAndOrPasswordInURL;
                    String userInfo = url.getUserInfo();
                    boolean bl = bNoUserAndOrPasswordInURL = userInfo == null;
                    if (uriSch == HgURL.Scheme.HTTPS) {
                        this.setupHttpsConnection(con);
                    }
                    if (bNoUserAndOrPasswordInURL && con.getResponseCode() != 200) {
                        invalidMsg = CloneRepositoryWizardPanel.getMessage("MSG_Progress_Clone_CannotAccess_Err");
                        con.disconnect();
                        return;
                    }
                    if (userInfo != null) {
                        Mercurial.LOG.log(Level.FINE, "RepositoryStepProgressSupport.perform(): UserInfo - {0}", new Object[]{userInfo});
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                Mercurial.LOG.log(Level.INFO, ex.getMessage(), ex);
                invalidMsg = CloneRepositoryWizardPanel.getMessage("MSG_Progress_Clone_InvalidURL_Err");
                return;
            }
            catch (IOException ex) {
                Mercurial.LOG.log(Level.INFO, ex.getMessage(), ex);
                invalidMsg = CloneRepositoryWizardPanel.getMessage("MSG_Progress_Clone_CannotAccess_Err");
                return;
            }
            catch (RuntimeException re) {
                Throwable t = re.getCause();
                invalidMsg = t != null ? t.getLocalizedMessage() : re.getLocalizedMessage();
                Mercurial.LOG.log(Level.INFO, invalidMsg, re);
                return;
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
                if (this.isCanceled()) {
                    CloneRepositoryWizardPanel.this.displayErrorMessage(CloneRepositoryWizardPanel.getMessage("CTL_Repository_Canceled"));
                } else if (invalidMsg == null) {
                    CloneRepositoryWizardPanel.this.storeHistory();
                } else {
                    CloneRepositoryWizardPanel.this.displayErrorMessage(invalidMsg);
                }
            }
        }

        @Override
        public void setEditable(boolean editable) {
            CloneRepositoryWizardPanel.this.repository.setEditable(editable);
        }

        private void setupHttpsConnection(HttpURLConnection con) {
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            HostnameVerifier hnv = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            try {
                SSLContext context = SSLContext.getInstance("SSLv3");
                TrustManager[] trustManagerArray = new TrustManager[]{tm};
                context.init(null, trustManagerArray, null);
                HttpsURLConnection c = (HttpsURLConnection)con;
                c.setSSLSocketFactory(context.getSocketFactory());
                c.setHostnameVerifier(hnv);
            }
            catch (KeyManagementException ex) {
                Mercurial.LOG.log(Level.INFO, ex.getMessage(), ex);
            }
            catch (NoSuchAlgorithmException ex) {
                Mercurial.LOG.log(Level.INFO, ex.getMessage(), ex);
            }
        }
    }
}

