/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.status;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mercurial.remote.ui.status.HgVersioningTopComponent;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class ShowAllChangesAction
extends SystemAction {
    public String getName() {
        return NbBundle.getMessage(ShowAllChangesAction.class, (String)"CTL_MenuItem_ShowAllChanges_Label");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    public void actionPerformed(ActionEvent e) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ShowAllChangesAction.this.async();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void async() {
        try {
            String title;
            this.setEnabled(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HgVersioningTopComponent stc = HgVersioningTopComponent.findInstance();
                    stc.setContext(null);
                    stc.open();
                }
            });
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            ArrayList<AbstractNode> allNodes = new ArrayList<AbstractNode>();
            for (int i = 0; i < projects.length; ++i) {
                AbstractNode node = new AbstractNode((Children)new Children.Array(), projects[i].getLookup());
                allNodes.add(node);
            }
            final VCSContext ctx = VCSContext.forNodes((Node[])allNodes.toArray(new Node[allNodes.size()]));
            if (projects.length == 1) {
                Project project = projects[0];
                ProjectInformation pinfo = ProjectUtils.getInformation((Project)project);
                title = pinfo.getDisplayName();
            } else {
                title = NbBundle.getMessage(ShowAllChangesAction.class, (String)"CTL_ShowAllChanges_WindowTitle", (Object)Integer.toString(projects.length));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HgVersioningTopComponent stc = HgVersioningTopComponent.findInstance();
                    stc.setContentTitle(title);
                    stc.setContext(ctx);
                    stc.open();
                    stc.requestActive();
                    if (ShowAllChangesAction.this.shouldPostRefresh()) {
                        stc.performRefreshAction();
                    }
                }
            });
        }
        finally {
            this.setEnabled(true);
        }
    }

    protected boolean shouldPostRefresh() {
        return true;
    }
}

