/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.remotefs.versioning.api.RemoteFileSystemConnectionListener;
import org.netbeans.modules.remotefs.versioning.api.RemoteFileSystemConnectionManager;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSAnnotator;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;
import org.netbeans.modules.versioning.core.spi.VersioningSystem;
import org.netbeans.spi.queries.CollocationQueryImplementation2;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class MercurialVCS
extends VersioningSystem
implements PropertyChangeListener,
PreferenceChangeListener,
RemoteFileSystemConnectionListener {
    private final CollocationQueryImplementation2 collocationQueryImplementation = new CollocationQueryImplementation2(){

        public boolean areCollocated(URI a, URI b) {
            VCSFileProxy fra = VCSFileProxySupport.fromURI((URI)a);
            VCSFileProxy frb = VCSFileProxySupport.fromURI((URI)b);
            if (fra == null || frb == null) {
                return false;
            }
            fra = MercurialVCS.this.getTopmostManagedAncestor(fra);
            frb = MercurialVCS.this.getTopmostManagedAncestor(frb);
            return fra != null && fra.equals((Object)frb);
        }

        public URI findRoot(URI file) {
            VCSFileProxy topmostManagedAncestor;
            VCSFileProxy fromURI = VCSFileProxySupport.fromURI((URI)file);
            if (fromURI != null && (topmostManagedAncestor = MercurialVCS.this.getTopmostManagedAncestor(fromURI)) != null) {
                return VCSFileProxySupport.toURI((VCSFileProxy)topmostManagedAncestor);
            }
            return null;
        }
    };

    public MercurialVCS() {
        RemoteFileSystemConnectionManager.getInstance().addRemoteFileSystemConnectionListener((RemoteFileSystemConnectionListener)this);
        Mercurial.getInstance().register(this);
    }

    public static String getDisplayName() {
        return NbBundle.getMessage(MercurialVCS.class, (String)"CTL_Mercurial_DisplayName");
    }

    public CollocationQueryImplementation2 getCollocationQueryImplementation() {
        return this.collocationQueryImplementation;
    }

    public VCSHistoryProvider getVCSHistoryProvider() {
        return Mercurial.getInstance().getMercurialHistoryProvider();
    }

    public VCSFileProxy getTopmostManagedAncestor(VCSFileProxy file) {
        return Mercurial.getInstance().getTopmostManagedAncestor(file);
    }

    public VCSAnnotator getVCSAnnotator() {
        return Mercurial.getInstance().getMercurialAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return Mercurial.getInstance().getMercurialInterceptor();
    }

    public void getOriginalFile(VCSFileProxy workingCopy, VCSFileProxy originalFile) {
        Mercurial.getInstance().getOriginalFile(workingCopy, originalFile);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("status.changed")) {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)event.getNewValue();
            this.fireStatusChanged(changedEvent.getFile());
        } else if (event.getPropertyName().equals("headChanged")) {
            Set files = (Set)event.getNewValue();
            this.fireStatusChanged(files == null || files.isEmpty() ? null : files);
        } else if (event.getPropertyName().equals("annotationsChanged")) {
            this.fireAnnotationsChanged((Set)event.getNewValue());
        } else if (event.getPropertyName().equals("versionedFilesChanged")) {
            Mercurial.LOG.fine("cleaning unversioned parents cache");
            Mercurial.getInstance().clearAncestorCaches();
            this.fireVersionedFilesChanged();
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        }
    }

    public void connected(FileSystem fs) {
        Mercurial.getInstance().clearAncestorCaches();
        this.postVersionedRootsChanged();
    }

    public void disconnected(FileSystem fs) {
        Mercurial.getInstance().clearAncestorCaches();
        this.postVersionedRootsChanged();
    }

    private void postVersionedRootsChanged() {
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                VersioningSupport.versionedRootsChanged();
            }
        });
    }
}

