/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.buildsupport;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.spi.toolchain.CompilerSetFactory;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public class ToolsWrapperUtility {
    private static final Map<FileObject, CompilerSet> cache = new ConcurrentHashMap<FileObject, CompilerSet>();
    private static final String codeNameBase = "org.netbeans.modules.cnd.actions";
    private static final String windowsWrapperResource = "bin/tools-wrapper/Windows/wrapper.exe";
    private static final String unixWrapperResource = "bin/tools-wrapper/Unix/wrapper";
    private static final String toolsWrapperLocation = "nbproject/private/tools/";
    private static final String compilerPropertiesName = "compiler.properties";
    private final ExecutionEnvironment execEnv;
    private final MakeConfiguration conf;
    private final Project project;

    public ToolsWrapperUtility(ExecutionEnvironment execEnv, MakeConfiguration conf, Project project) {
        this.execEnv = execEnv;
        this.conf = conf;
        this.project = project;
    }

    public CompilerSet getToolsWrapper() {
        try {
            String cppName;
            FileObject fo;
            String cName;
            FileObject fo2;
            FileObject wrapperFolder;
            CompilerSet res;
            CompilerSet compilerSet = this.conf.getCompilerSet().getCompilerSet();
            String eeID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.execEnv).replace(':', '_').replace('@', '_');
            if (this.conf.getFileSystemHost().equals((Object)this.execEnv)) {
                eeID = "localhost";
            }
            if ((res = cache.get(wrapperFolder = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)(toolsWrapperLocation + eeID + "/" + compilerSet.getName())))) != null) {
                return res;
            }
            String wrapperBinaryFile = this.getLocalFileLocationFor(this.execEnv);
            String cPath = null;
            Tool toolC = null;
            toolC = compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
            if (toolC != null && (fo2 = wrapperFolder.getFileObject(cName = PathUtilities.getBaseName((String)(cPath = toolC.getPath())))) == null) {
                fo2 = this.copyFile(wrapperBinaryFile, wrapperFolder, cName);
                this.fixScript(fo2, cPath);
            }
            String cppPath = null;
            Tool toolCpp = null;
            toolCpp = compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            if (toolCpp != null && (fo = wrapperFolder.getFileObject(cppName = PathUtilities.getBaseName((String)(cppPath = toolCpp.getPath())))) == null) {
                fo = this.copyFile(wrapperBinaryFile, wrapperFolder, cppName);
                this.fixScript(fo, cppPath);
            }
            res = CompilerSetFactory.createCompilerSetWrapper((CompilerSet)compilerSet, (ExecutionEnvironment)this.execEnv, (String)wrapperFolder.getPath());
            cache.put(wrapperFolder, res);
            return res;
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace(System.err);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
        }
        catch (ExecutionException ex) {
            ex.printStackTrace(System.err);
        }
        return null;
    }

    private String getLocalFileLocationFor(ExecutionEnvironment env) throws MissingResourceException {
        String resource = env.isLocal() && Utilities.isWindows() ? windowsWrapperResource : unixWrapperResource;
        InstalledFileLocator fl = InstalledFileLocator.getDefault();
        File file = fl.locate(resource, codeNameBase, false);
        if (file == null || !file.exists()) {
            throw new MissingResourceException(resource, null, null);
        }
        return file.getAbsolutePath();
    }

    private void fixScript(FileObject f, String realTool) throws IOException {
        if (this.execEnv.isLocal() && Utilities.isWindows()) {
            byte[] content = f.asBytes();
            byte[] pattern = new byte[]{101, 99, 104, 111, 32, 109, 97, 103, 105, 99, 101, 99, 104, 111, 32, 109, 97, 103, 105, 99};
            for (int i = 0; i < content.length - 1000; ++i) {
                boolean find = true;
                for (int j = 0; j < pattern.length; ++j) {
                    if (content[i + j] == pattern[j]) continue;
                    find = false;
                    break;
                }
                if (!find) continue;
                byte[] tool_bytes = realTool.getBytes();
                for (int k = 0; k < tool_bytes.length && k < 1000; ++k) {
                    content[i + k] = tool_bytes[k];
                }
                if (tool_bytes.length < 1000) {
                    content[i + tool_bytes.length] = 0;
                }
                OutputStream outputStream = f.getOutputStream();
                outputStream.write(content);
                outputStream.close();
                break;
            }
        } else {
            ArrayList<String> lines = new ArrayList<String>(f.asLines());
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                if (!line.startsWith("real_tool=")) continue;
                lines.set(i, "real_tool=" + realTool);
            }
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(f.getOutputStream(), "UTF-8")){

                @Override
                public void newLine() throws IOException {
                    this.write("\n");
                }
            };
            for (String line : lines) {
                bw.write(line);
                bw.newLine();
            }
            bw.close();
        }
    }

    private FileObject copyFile(String wrapperBinaryFile, FileObject folder, String name) throws IOException, InterruptedException, ExecutionException {
        String ext = "";
        int i = name.lastIndexOf(46);
        if (i >= 0) {
            ext = name.substring(i + 1);
            name = name.substring(0, i);
        }
        if (this.execEnv.isLocal()) {
            FileObject copyFile = FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)new File(wrapperBinaryFile)), (FileObject)folder, (String)name, (String)ext);
            Future task = CommonTasksSupport.chmod((ExecutionEnvironment)this.execEnv, (String)copyFile.getPath(), (int)493, null);
            Integer retCode = (Integer)task.get();
            return copyFile;
        }
        Future uploadTask = CommonTasksSupport.uploadFile((String)wrapperBinaryFile, (ExecutionEnvironment)this.execEnv, (String)(folder.getPath() + "/" + name), (int)493, (boolean)true);
        CommonTasksSupport.UploadStatus status = (CommonTasksSupport.UploadStatus)uploadTask.get();
        if (!status.isOK()) {
            throw new IOException("Unable to upload " + wrapperBinaryFile + " to " + this.execEnv.getDisplayName() + ':' + folder.getPath() + "/" + name + " rc=" + status.getExitCode() + ' ' + status.getError());
        }
        folder.refresh();
        return folder.getFileObject(name);
    }
}

