/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.FolderProperties;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;

public final class FolderImpl
implements FolderProperties {
    private final String path;
    private final ItemProperties.LanguageKind language;
    private final Set<String> userIncludes = new LinkedHashSet<String>();
    private final Set<String> userFiles = new LinkedHashSet<String>();
    private final Set<String> systemIncludes = new LinkedHashSet<String>();
    private final Map<String, String> userMacros = new HashMap<String, String>();
    private final Set<String> undefinedMacros = new LinkedHashSet<String>();
    private final List<SourceFileProperties> files = new ArrayList<SourceFileProperties>();

    public FolderImpl(String path, SourceFileProperties source) {
        this.path = path;
        this.language = source.getLanguageKind();
        this.update(source);
    }

    void update(SourceFileProperties source) {
        this.files.add(source);
        this.userIncludes.addAll(source.getUserInludePaths());
        for (String currentPath : source.getUserInludePaths()) {
            this.userIncludes.add(DiscoveryUtils.convertRelativePathToAbsolute(source, currentPath));
        }
        this.userFiles.addAll(source.getUserInludeFiles());
        this.systemIncludes.addAll(source.getSystemInludePaths());
        this.userMacros.putAll(source.getUserMacros());
        this.undefinedMacros.addAll(source.getUndefinedMacros());
    }

    @Override
    public String getItemPath() {
        return this.path;
    }

    @Override
    public List<SourceFileProperties> getFiles() {
        return this.files;
    }

    @Override
    public List<String> getUserInludePaths() {
        return new ArrayList<String>(this.userIncludes);
    }

    @Override
    public List<String> getUserInludeFiles() {
        return new ArrayList<String>(this.userFiles);
    }

    @Override
    public List<String> getSystemInludePaths() {
        return new ArrayList<String>(this.systemIncludes);
    }

    @Override
    public Map<String, String> getUserMacros() {
        return this.userMacros;
    }

    @Override
    public List<String> getUndefinedMacros() {
        return new ArrayList<String>(this.undefinedMacros);
    }

    @Override
    public Map<String, String> getSystemMacros() {
        return null;
    }

    @Override
    public ItemProperties.LanguageKind getLanguageKind() {
        return this.language;
    }

    @Override
    public String getCompilerName() {
        return "";
    }

    @Override
    public ItemProperties.LanguageStandard getLanguageStandard() {
        return ItemProperties.LanguageStandard.Unknown;
    }
}

