/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.core.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOptions;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.customization.jaxwssettings.panel.WsimportOptionsPanel;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JaxwsSettingsEditor
implements WSEditor {
    private Service service;
    private Client client;
    private WsimportOptionsPanel panel;
    private JaxWsModel jaxWsModel;

    JaxwsSettingsEditor(JaxWsModel jaxWsModel) {
        this.jaxWsModel = jaxWsModel;
    }

    public JComponent createWSEditorComponent(Node node) {
        this.service = (Service)node.getLookup().lookup(Service.class);
        this.client = (Client)node.getLookup().lookup(Client.class);
        WsimportOptions wsimportOptions = null;
        String[] jvmArgs = null;
        String jvmOptions = "";
        if (this.service != null) {
            wsimportOptions = this.service.getWsImportOptions();
            jvmArgs = this.service.getJvmArgs();
        } else if (this.client != null) {
            wsimportOptions = this.client.getWsImportOptions();
            jvmArgs = this.client.getJvmArgs();
        }
        if (jvmArgs.length > 0) {
            jvmOptions = this.strJoin(jvmArgs);
        }
        ArrayList<WsimportOption> options = new ArrayList<WsimportOption>();
        ArrayList<WsimportOption> jaxbOptions = new ArrayList<WsimportOption>();
        if (wsimportOptions != null) {
            WsimportOption[] wsoptions = wsimportOptions.getWsimportOptions();
            for (int i = 0; i < wsoptions.length; ++i) {
                WsimportOption wsimportOption = wsoptions[i];
                if (wsimportOption.getJaxbOption() != null && wsimportOption.getJaxbOption().booleanValue()) {
                    jaxbOptions.add(wsimportOption);
                    continue;
                }
                options.add(wsimportOption);
            }
        }
        this.panel = new WsimportOptionsPanel(options, jaxbOptions, wsimportOptions, jvmOptions);
        return this.panel;
    }

    public String getTitle() {
        return NbBundle.getMessage(JaxwsSettingsEditor.class, (String)"JAXWS_SETTINGS_TITLE");
    }

    public void save(Node node) {
        try {
            String jvmOptions;
            WsimportOptions wsimportOptions = null;
            if (this.service != null) {
                wsimportOptions = this.service.getWsImportOptions();
                if (wsimportOptions == null) {
                    wsimportOptions = this.service.newWsimportOptions();
                }
                if ((jvmOptions = this.getJvmOptions()).length() > 0) {
                    this.service.setJvmArgs(jvmOptions.split("\\s+"));
                }
            } else if (this.client != null) {
                wsimportOptions = this.client.getWsImportOptions();
                if (wsimportOptions == null) {
                    wsimportOptions = this.client.newWsimportOptions();
                }
                if ((jvmOptions = this.getJvmOptions()).length() > 0) {
                    this.client.setJvmArgs(jvmOptions.split("\\s+"));
                }
            }
            if (wsimportOptions != null) {
                wsimportOptions.clearWsimportOptions();
                List<WsimportOption> options = this.getWsimportOptions();
                for (WsimportOption option : options) {
                    wsimportOptions.addWsimportOption(option);
                }
                options = this.getJaxbOptions();
                for (WsimportOption option : options) {
                    option.setJaxbOption(Boolean.valueOf(true));
                    wsimportOptions.addWsimportOption(option);
                }
            }
            this.jaxWsModel.write();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void cancel(Node node) {
    }

    public String getDescription() {
        return NbBundle.getMessage(JaxwsSettingsEditor.class, (String)"JAXWS_SETTINGS_DESC");
    }

    private List<WsimportOption> getWsimportOptions() {
        return this.panel.getWsimportOptions();
    }

    private List<WsimportOption> getJaxbOptions() {
        return this.panel.getJaxbOptions();
    }

    private String getJvmOptions() {
        return this.panel.getJvmOptions();
    }

    private String strJoin(String[] aArr) {
        StringBuilder sbStr = new StringBuilder();
        for (int i = 0; i < aArr.length; ++i) {
            if (i > 0) {
                sbStr.append(' ');
            }
            sbStr.append(aArr[i]);
        }
        return sbStr.toString();
    }
}

