/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.Collection;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.EngineProfile;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.openide.nodes.PropertySupport;

public class EngineNodeProp
extends PropertySupport<EngineType> {
    private EngineProfile profile;
    private EngineEditor engineEditor;

    public EngineNodeProp(EngineProfile profile) {
        super("EngineType", EngineType.class, Catalog.get("EnginePropDisplayName"), Catalog.get("EnginePropTT"), true, true);
        this.profile = profile;
    }

    public EngineType getValue() {
        return this.profile.getEngineType();
    }

    public void setValue(EngineType v) {
        this.profile.setEngineType(v);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.engineEditor == null) {
            this.engineEditor = new EngineEditor();
        }
        return this.engineEditor;
    }

    public Object getValue(String attributeName) {
        return super.getValue(attributeName);
    }

    private class EngineEditor
    extends PropertyEditorSupport {
        @Override
        public void setAsText(String text) {
            if (IpeUtils.isEmpty(text)) {
                EngineEditor.super.setValue(null);
            } else {
                EngineEditor.super.setValue(EngineTypeManager.getEngineTypeByDisplayName(text));
            }
        }

        @Override
        public String getAsText() {
            return EngineNodeProp.this.profile.getEngineType().getDisplayName();
        }

        @Override
        public String[] getTags() {
            Collection<EngineType> engineTypes = EngineTypeManager.getEngineTypes(true);
            String[] tags = new String[engineTypes.size()];
            int i = 0;
            for (EngineType engine : engineTypes) {
                tags[i++] = engine.getDisplayName();
            }
            return tags;
        }
    }
}

