/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.DebugCoreAction;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.NodeAction;

public final class DebugCoreNodeAction
extends NodeAction {
    static final long serialVersionUID = -6814567172958445516L;

    public DebugCoreNodeAction() {
        this.putValue("key", "CndDebugCorefileNodeAction");
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        DataObject dao = (DataObject)activatedNodes[0].getCookie(DataObject.class);
        return dao != null && "application/x-core+elf".equals(IpeUtils.getMime(dao));
    }

    protected void performAction(final Node[] activatedNodes) {
        final DebugCoreAction debugCoreAction = (DebugCoreAction)SharedClassObject.findObject(DebugCoreAction.class, (boolean)true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                debugCoreAction.performAction(activatedNodes, true);
            }
        });
    }

    public String getName() {
        return Catalog.get("CTL_DebugCorefile");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Debugging_corefile");
    }

    protected String iconResource() {
        return "org/netbeans/modules/cnd/loaders/CoreElfIcon.gif";
    }
}

