/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;

public class ModelListenerSupport
implements ModelListener {
    private final CopyOnWriteArrayList<ModelListener> listeners = new CopyOnWriteArrayList();
    private String owner;

    protected ModelListenerSupport(String owner) {
        this.owner = owner;
    }

    public void modelChanged(ModelEvent event) {
        ModelListener lastListener = null;
        for (ModelListener l : this.listeners) {
            if (l == lastListener) continue;
            l.modelChanged(event);
            lastListener = l;
        }
    }

    public void treeChanged() {
        ModelListener lastListener = null;
        for (ModelListener l : this.listeners) {
            if (l == lastListener) continue;
            l.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
            lastListener = l;
        }
    }

    public void treeNodeChanged(Object node) {
        ModelListener lastListener = null;
        for (ModelListener l : this.listeners) {
            if (l == lastListener) continue;
            l.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, node));
            lastListener = l;
        }
    }

    protected boolean addModelListenerHelp(ModelListener l) {
        this.listeners.add(l);
        return this.listeners.size() == 1;
    }

    protected boolean removeModelListenerHelp(ModelListener l) {
        this.listeners.remove(l);
        return this.listeners.size() == 0;
    }
}

