/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.spi.toolchain.CompilerProvider;
import org.netbeans.modules.cnd.toolchain.compilerset.APIAccessor;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerFlavorImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class CompilerSetImpl
extends CompilerSet {
    private final CompilerFlavor flavor;
    private String name;
    private final String displayName;
    private boolean autoGenerated;
    private boolean isDefault;
    private final String directory;
    private String commandDirectory;
    private final ArrayList<Tool> tools = new ArrayList();
    private final CompilerProvider compilerProvider;
    private Map<ToolKind, String> pathSearch;
    private boolean isSunStudioDefault;
    private Charset charset;
    private String modifyBuildPath;
    private String modifyRunPath;

    @Override
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public boolean isUrlPointer() {
        if (this.getDirectory() == null || this.getDirectory().length() == 0) {
            return this.flavor.getToolchainDescriptor().getUpdateCenterUrl() != null && this.flavor.getToolchainDescriptor().getModuleID() != null;
        }
        return false;
    }

    void setAsDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void unsetDefault() {
        this.isDefault = false;
    }

    public static CompilerSetImpl restore(ExecutionEnvironment env, CompilerFlavor flavor, String directory, String name, String displayName, String setBuildPath, String setRunPath) {
        return new CompilerSetImpl(env, flavor, directory, name, displayName, setBuildPath, setRunPath);
    }

    public static CompilerSetImpl create(CompilerFlavor flavor, ExecutionEnvironment env, String directory) {
        String setRunPath;
        String setBuildPath;
        if (env.isLocal() && Utilities.isWindows()) {
            setBuildPath = "${TOOLS_PATH};${UTILITIES_PATH};${PATH}";
            setRunPath = "${PATH};${TOOLS_PATH};${UTILITIES_PATH}";
        } else {
            setBuildPath = "${TOOLS_PATH};${PATH}";
            setRunPath = "${PATH};${TOOLS_PATH}";
        }
        String productName = CompilerSetImpl.foundProductName(flavor, env, directory);
        if (productName == null || productName.isEmpty()) {
            String name = CompilerSetImpl.createName(flavor, null);
            String displayName = CompilerSetImpl.extractDisplayName(flavor, null);
            return new CompilerSetImpl(env, flavor, directory, name, displayName, setBuildPath, setRunPath);
        }
        String displayName = CompilerSetImpl.extractDisplayName(flavor, productName);
        String name = CompilerSetImpl.createName(flavor, displayName);
        if (flavor instanceof CompilerFlavorImpl) {
            CompilerFlavorImpl.putProductName((CompilerFlavorImpl)flavor, displayName);
        }
        return new CompilerSetImpl(env, flavor, directory, name, displayName, setBuildPath, setRunPath);
    }

    public CompilerSetImpl createCopy(ExecutionEnvironment env) {
        return this.createCopy(env, this.flavor, this.getDirectory(), this.name, this.displayName, this.isAutoGenerated(), true, this.modifyBuildPath, this.modifyRunPath);
    }

    public CompilerSetImpl createCopy(ExecutionEnvironment env, CompilerFlavor flavor, String directory, String name, String displayName, boolean autoGenerated, boolean keepToolFlavor, String setBuildPath, String setRunPath) {
        flavor = flavor == null ? this.flavor : flavor;
        directory = directory == null ? this.getDirectory() : directory;
        name = name == null ? this.name : name;
        displayName = displayName == null ? this.displayName : displayName;
        setBuildPath = setBuildPath == null ? this.modifyBuildPath : setBuildPath;
        String string = setRunPath = setRunPath == null ? this.modifyRunPath : setRunPath;
        if (setBuildPath == null) {
            setBuildPath = env.isLocal() && Utilities.isWindows() ? "${TOOLS_PATH};${UTILITIES_PATH};${PATH}" : "${TOOLS_PATH};${PATH}";
        }
        if (setRunPath == null) {
            setRunPath = env.isLocal() && Utilities.isWindows() ? "${PATH};${TOOLS_PATH};${UTILITIES_PATH}" : "${PATH};${TOOLS_PATH}";
        }
        CompilerSetImpl copy = CompilerSetImpl.restore(env, flavor, directory, name, displayName, setBuildPath, setRunPath);
        copy.setAutoGenerated(autoGenerated);
        copy.setEncoding(this.getEncoding());
        for (Tool tool : this.getTools()) {
            CompilerFlavor toolFlavor = keepToolFlavor ? tool.getFlavor() : flavor;
            copy.addTool(tool.createCopy(toolFlavor));
        }
        return copy;
    }

    public static String foundProductName(CompilerFlavor compilerFlavor, ExecutionEnvironment ee, String path) {
        FileObject productName;
        FSPath fs;
        FileObject fo;
        if (compilerFlavor.isSunStudioCompiler() && (fo = (fs = new FSPath(FileSystemProvider.getFileSystem((ExecutionEnvironment)ee), path)).getFileObject()) != null && fo.isValid() && (productName = fo.getFileObject("../LEGAL/ProductName")) != null && productName.isValid()) {
            try {
                List asLines = productName.asLines();
                if (asLines != null && asLines.size() > 0) {
                    return ((String)asLines.get(0)).trim();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return null;
    }

    public static String createName(CompilerFlavor compilerFlavor, String displayName) {
        if (displayName != null && !displayName.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < displayName.length(); ++i) {
                char c = displayName.charAt(i);
                if (c == ' ') {
                    if (i + 1 < displayName.length() && Character.isDigit(displayName.charAt(i + 1))) {
                        buf.append('_');
                    }
                    if (i - 1 < 0 || !Character.isDigit(displayName.charAt(i - 1))) continue;
                    buf.append('_');
                    continue;
                }
                buf.append(c);
            }
            return buf.toString();
        }
        return compilerFlavor.getToolchainDescriptor().getName();
    }

    public static String extractDisplayName(CompilerFlavor flavor, String productName) {
        String displayName = flavor.getToolchainDescriptor().getDisplayName();
        int start = displayName.indexOf(123);
        int end = displayName.indexOf(125);
        if (start >= 0 && end > start) {
            if (productName != null) {
                return displayName.substring(0, start) + productName + displayName.substring(end + 1);
            }
            return displayName.substring(0, start) + displayName.substring(start + 1, end) + displayName.substring(end + 1);
        }
        return displayName;
    }

    private CompilerSetImpl(ExecutionEnvironment env, CompilerFlavor flavor, String directory, String name, String displayName, String setBuildPath, String setRunPath) {
        this.directory = directory == null ? "" : directory;
        this.compilerProvider = CompilerProvider.getInstance();
        this.displayName = displayName == null || displayName.isEmpty() ? CompilerSetImpl.extractDisplayName(flavor, null) : displayName;
        this.name = name != null && !name.isEmpty() ? name : flavor.toString();
        this.flavor = flavor;
        this.autoGenerated = true;
        this.isDefault = false;
        if (env.isLocal() && Utilities.isWindows()) {
            this.modifyBuildPath = setBuildPath == null ? "${TOOLS_PATH};${UTILITIES_PATH};${PATH}" : setBuildPath;
            this.modifyRunPath = setRunPath == null ? "${PATH};${TOOLS_PATH};${UTILITIES_PATH}" : setRunPath;
        } else {
            this.modifyBuildPath = setBuildPath == null ? "${TOOLS_PATH};${PATH}" : setBuildPath;
            this.modifyRunPath = setRunPath == null ? "${PATH};${TOOLS_PATH}" : setRunPath;
        }
    }

    private CompilerSetImpl(int platform) {
        this.directory = "";
        this.name = "None";
        this.flavor = CompilerFlavorImpl.getUnknown(platform);
        this.displayName = NbBundle.getMessage(CompilerSetImpl.class, (String)"LBL_EmptyCompilerSetDisplayName");
        this.compilerProvider = CompilerProvider.getInstance();
        this.autoGenerated = true;
        this.isDefault = false;
        this.modifyBuildPath = "${PATH}";
        this.modifyRunPath = "${PATH}";
    }

    protected static CompilerSet createEmptyCompilerSet(int platform) {
        return new CompilerSetImpl(platform);
    }

    @Override
    public CompilerFlavor getCompilerFlavor() {
        return this.flavor;
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    @Override
    public String getModifyBuildPath() {
        return this.modifyBuildPath;
    }

    @Override
    public String getModifyRunPath() {
        return this.modifyRunPath;
    }

    public void setModifyBuildPath(String modifyBuildPath) {
        this.modifyBuildPath = modifyBuildPath;
    }

    public void setModifyRunPath(String modifyRunPath) {
        this.modifyRunPath = modifyRunPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCommandFolder() {
        CompilerSetImpl compilerSetImpl = this;
        synchronized (compilerSetImpl) {
            if (this.commandDirectory == null) {
                this.commandDirectory = ToolUtils.getCommandFolder(this);
                if (this.commandDirectory == null) {
                    this.commandDirectory = "";
                }
            }
        }
        if (this.commandDirectory.isEmpty()) {
            return null;
        }
        return this.commandDirectory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public Tool addTool(ExecutionEnvironment env, String name, String path, ToolKind kind, CompilerFlavor aFlavor) {
        Tool tool;
        if (this.findTool(kind) != null) {
            return null;
        }
        if (aFlavor == null) {
            aFlavor = this.getCompilerFlavor();
        }
        if (!this.tools.contains(tool = this.compilerProvider.createCompiler(env, aFlavor, kind, name, kind.getDisplayName(), path))) {
            this.tools.add(tool);
        }
        APIAccessor.get().setCompilerSet(tool, this);
        return tool;
    }

    void addTool(Tool tool) {
        this.tools.add(tool);
        APIAccessor.get().setCompilerSet(tool, this);
    }

    Tool addNewTool(ExecutionEnvironment env, String name, String path, ToolKind kind, CompilerFlavor aFlavor) {
        if (aFlavor == null) {
            aFlavor = this.getCompilerFlavor();
        }
        Tool tool = this.compilerProvider.createCompiler(env, aFlavor, kind, name, kind.getDisplayName(), path);
        this.tools.add(tool);
        APIAccessor.get().setCompilerSet(tool, this);
        return tool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tool getTool(ToolKind kind) {
        for (Tool tool : this.tools) {
            if (tool.getKind() != kind) continue;
            return tool;
        }
        CndUtils.assertFalse((boolean)true, (String)"Should not be here, cuz we should create empty tools in CompilerSetManager");
        Tool t = this.compilerProvider.createCompiler(ExecutionEnvironmentFactory.getLocal(), this.getCompilerFlavor(), kind, "", kind.getDisplayName(), "");
        APIAccessor.get().setCompilerSet(t, this);
        ArrayList<Tool> arrayList = this.tools;
        synchronized (arrayList) {
            this.tools.add(t);
        }
        return t;
    }

    @Override
    public Tool findTool(ToolKind kind) {
        for (Tool tool : this.tools) {
            if (tool.getKind() != kind) continue;
            return tool;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Tool> getTools() {
        ArrayList<Tool> arrayList = this.tools;
        synchronized (arrayList) {
            return (List)this.tools.clone();
        }
    }

    void addPathCandidate(ToolKind tool, String path) {
        if (this.pathSearch == null) {
            this.pathSearch = new HashMap<ToolKind, String>();
        }
        this.pathSearch.put(tool, path);
    }

    String getPathCandidate(ToolKind tool) {
        if (this.pathSearch == null) {
            return null;
        }
        return this.pathSearch.get(tool);
    }

    void setSunStudioDefault(boolean isSunStudioDefault) {
        this.isSunStudioDefault = isSunStudioDefault;
    }

    boolean isSunStudioDefault() {
        return this.isSunStudioDefault;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Charset getEncoding() {
        if (this.charset == null) {
            if (this.flavor != null && this.flavor.isSunStudioCompiler()) {
                this.charset = Charset.defaultCharset();
            }
            if (this.charset == null) {
                this.charset = Charset.forName("UTF-8");
                if (this.charset == null) {
                    this.charset = Charset.defaultCharset();
                }
            }
        }
        return this.charset;
    }

    public void setEncoding(Charset charset) {
        this.charset = charset;
    }

    public static class UnknownToolchainDescriptor
    implements ToolchainManager.ToolchainDescriptor {
        private static final ToolchainManager.CompilerDescriptor unknowDescriptor = new UnknownCompilerDescriptor(null);
        private final ToolchainManager.ToolchainDescriptor proxy;

        UnknownToolchainDescriptor(ToolchainManager.ToolchainDescriptor proxy) {
            this.proxy = proxy;
        }

        @Override
        public String getFileName() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getFileName();
        }

        @Override
        public String getName() {
            return "Unknown";
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(UnknownToolchainDescriptor.class, (String)"UnknownToolCollection");
        }

        @Override
        public String[] getFamily() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getFamily();
        }

        @Override
        public String[] getPlatforms() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getPlatforms();
        }

        @Override
        public String getUpdateCenterUrl() {
            if (this.proxy == null) {
                return null;
            }
            return this.proxy.getUpdateCenterUrl();
        }

        @Override
        public String getUpdateCenterDisplayName() {
            if (this.proxy == null) {
                return null;
            }
            return this.proxy.getUpdateCenterDisplayName();
        }

        @Override
        public String getUpgradeUrl() {
            if (this.proxy == null) {
                return null;
            }
            return this.proxy.getUpgradeUrl();
        }

        @Override
        public String getModuleID() {
            if (this.proxy == null) {
                return null;
            }
            return this.proxy.getModuleID();
        }

        @Override
        public boolean isAbstract() {
            if (this.proxy == null) {
                return true;
            }
            return this.proxy.isAbstract();
        }

        @Override
        public boolean isAutoDetected() {
            if (this.proxy == null) {
                return true;
            }
            return this.proxy.isAutoDetected();
        }

        @Override
        public String[] getAliases() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getAliases();
        }

        @Override
        public String getSubstitute() {
            if (this.proxy == null) {
                return null;
            }
            return this.proxy.getSubstitute();
        }

        @Override
        public String getDriveLetterPrefix() {
            if (this.proxy == null) {
                return "/";
            }
            return this.proxy.getDriveLetterPrefix();
        }

        @Override
        public List<ToolchainManager.BaseFolder> getBaseFolders() {
            if (this.proxy == null) {
                return Collections.emptyList();
            }
            return this.proxy.getBaseFolders();
        }

        @Override
        public List<ToolchainManager.BaseFolder> getCommandFolders() {
            if (this.proxy == null) {
                return Collections.emptyList();
            }
            return this.proxy.getCommandFolders();
        }

        @Override
        public String getQmakeSpec() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getQmakeSpec();
        }

        @Override
        public ToolchainManager.CompilerDescriptor getC() {
            if (this.proxy == null) {
                return unknowDescriptor;
            }
            return this.proxy.getC();
        }

        @Override
        public ToolchainManager.CompilerDescriptor getCpp() {
            if (this.proxy == null) {
                return unknowDescriptor;
            }
            return this.proxy.getCpp();
        }

        @Override
        public ToolchainManager.CompilerDescriptor getFortran() {
            if (this.proxy == null) {
                return unknowDescriptor;
            }
            return this.proxy.getFortran();
        }

        @Override
        public ToolchainManager.CompilerDescriptor getAssembler() {
            if (this.proxy == null) {
                return unknowDescriptor;
            }
            return this.proxy.getAssembler();
        }

        @Override
        public ToolchainManager.ScannerDescriptor getScanner() {
            if (this.proxy == null) {
                return new ToolchainManager.ScannerDescriptor(){

                    @Override
                    public String getID() {
                        return "";
                    }

                    @Override
                    public List<ToolchainManager.ScannerPattern> getPatterns() {
                        return Collections.emptyList();
                    }

                    @Override
                    public String getChangeDirectoryPattern() {
                        return "";
                    }

                    @Override
                    public String getEnterDirectoryPattern() {
                        return "";
                    }

                    @Override
                    public String getLeaveDirectoryPattern() {
                        return "";
                    }

                    @Override
                    public String getMakeAllInDirectoryPattern() {
                        return "";
                    }

                    @Override
                    public List<String> getStackHeaderPattern() {
                        return Collections.emptyList();
                    }

                    @Override
                    public List<String> getStackNextPattern() {
                        return Collections.emptyList();
                    }

                    @Override
                    public List<String> getFilterOutPatterns() {
                        return Collections.emptyList();
                    }
                };
            }
            return this.proxy.getScanner();
        }

        @Override
        public ToolchainManager.LinkerDescriptor getLinker() {
            if (this.proxy == null) {
                return new ToolchainManager.LinkerDescriptor(){

                    @Override
                    public String getLibraryPrefix() {
                        return "";
                    }

                    @Override
                    public String getLibrarySearchFlag() {
                        return "";
                    }

                    @Override
                    public String getDynamicLibrarySearchFlag() {
                        return "";
                    }

                    @Override
                    public String getLibraryFlag() {
                        return "";
                    }

                    @Override
                    public String getPICFlag() {
                        return "";
                    }

                    @Override
                    public String getStaticLibraryFlag() {
                        return "";
                    }

                    @Override
                    public String getDynamicLibraryFlag() {
                        return "";
                    }

                    @Override
                    public String getDynamicLibraryBasicFlag() {
                        return "";
                    }

                    @Override
                    public String getOutputFileFlag() {
                        return "";
                    }

                    @Override
                    public String getStripFlag() {
                        return "";
                    }

                    @Override
                    public String getPreferredCompiler() {
                        return "";
                    }
                };
            }
            return this.proxy.getLinker();
        }

        @Override
        public ToolchainManager.MakeDescriptor getMake() {
            if (this.proxy == null) {
                return null;
            }
            return this.proxy.getMake();
        }

        @Override
        public Map<String, List<String>> getDefaultLocations() {
            if (this.proxy == null) {
                return Collections.emptyMap();
            }
            return this.proxy.getDefaultLocations();
        }

        @Override
        public ToolchainManager.DebuggerDescriptor getDebugger() {
            if (this.proxy == null) {
                return null;
            }
            return this.proxy.getDebugger();
        }

        @Override
        public String getMakefileWriter() {
            if (this.proxy == null) {
                return null;
            }
            return this.proxy.getMakefileWriter();
        }

        @Override
        public ToolchainManager.QMakeDescriptor getQMake() {
            if (this.proxy == null) {
                return new ToolchainManager.QMakeDescriptor(){

                    @Override
                    public String[] getNames() {
                        return new String[0];
                    }

                    @Override
                    public String getVersionFlags() {
                        return "";
                    }

                    @Override
                    public String getVersionPattern() {
                        return "";
                    }

                    @Override
                    public String getFingerPrintFlags() {
                        return "";
                    }

                    @Override
                    public String getFingerPrintPattern() {
                        return "";
                    }

                    @Override
                    public boolean skipSearch() {
                        return true;
                    }

                    @Override
                    public ToolchainManager.AlternativePath[] getAlternativePath() {
                        return new ToolchainManager.AlternativePath[0];
                    }
                };
            }
            return this.proxy.getQMake();
        }

        @Override
        public ToolchainManager.CMakeDescriptor getCMake() {
            if (this.proxy == null) {
                return new ToolchainManager.CMakeDescriptor(){

                    @Override
                    public String[] getNames() {
                        return new String[0];
                    }

                    @Override
                    public String getVersionFlags() {
                        return "";
                    }

                    @Override
                    public String getVersionPattern() {
                        return "";
                    }

                    @Override
                    public String getFingerPrintFlags() {
                        return "";
                    }

                    @Override
                    public String getFingerPrintPattern() {
                        return "";
                    }

                    @Override
                    public boolean skipSearch() {
                        return true;
                    }

                    @Override
                    public ToolchainManager.AlternativePath[] getAlternativePath() {
                        return new ToolchainManager.AlternativePath[0];
                    }
                };
            }
            return this.proxy.getCMake();
        }
    }

    private static class UnknownCompilerDescriptor
    implements ToolchainManager.CompilerDescriptor {
        private final ToolchainManager.CompilerDescriptor proxy;

        UnknownCompilerDescriptor(ToolchainManager.CompilerDescriptor proxy) {
            this.proxy = proxy;
        }

        @Override
        public String getPathPattern() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getPathPattern();
        }

        @Override
        public String getExistFolder() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getExistFolder();
        }

        @Override
        public String getIncludeFlags() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getIncludeFlags();
        }

        @Override
        public String getUserIncludeFlag() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getUserIncludeFlag();
        }

        @Override
        public String getUserFileFlag() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getUserFileFlag();
        }

        @Override
        public String getIncludeParser() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getIncludeParser();
        }

        @Override
        public String getRemoveIncludePathPrefix() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getRemoveIncludePathPrefix();
        }

        @Override
        public String getRemoveIncludeOutputPrefix() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getRemoveIncludeOutputPrefix();
        }

        @Override
        public String getImportantFlags() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getImportantFlags();
        }

        @Override
        public String getMacroFlags() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getMacroFlags();
        }

        @Override
        public String getMacroParser() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getMacroParser();
        }

        @Override
        public List<ToolchainManager.PredefinedMacro> getPredefinedMacros() {
            if (this.proxy == null) {
                return Collections.emptyList();
            }
            return this.proxy.getPredefinedMacros();
        }

        @Override
        public String getUserMacroFlag() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getUserMacroFlag();
        }

        @Override
        public String[] getDevelopmentModeFlags() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getDevelopmentModeFlags();
        }

        @Override
        public String[] getWarningLevelFlags() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getWarningLevelFlags();
        }

        @Override
        public String[] getArchitectureFlags() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getArchitectureFlags();
        }

        @Override
        public String getStripFlag() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getStripFlag();
        }

        @Override
        public String[] getMultithreadingFlags() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getMultithreadingFlags();
        }

        @Override
        public String[] getStandardFlags() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getStandardFlags();
        }

        @Override
        public String[] getLanguageExtensionFlags() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getLanguageExtensionFlags();
        }

        @Override
        public String[] getCppStandardFlags() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getCppStandardFlags();
        }

        @Override
        public String[] getCStandardFlags() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getCStandardFlags();
        }

        @Override
        public String[] getLibraryFlags() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getLibraryFlags();
        }

        @Override
        public String getOutputObjectFileFlags() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getOutputObjectFileFlags();
        }

        @Override
        public String getDependencyGenerationFlags() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getDependencyGenerationFlags();
        }

        @Override
        public String getPrecompiledHeaderFlags() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getPrecompiledHeaderFlags();
        }

        @Override
        public String getPrecompiledHeaderSuffix() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getPrecompiledHeaderSuffix();
        }

        @Override
        public boolean getPrecompiledHeaderSuffixAppend() {
            if (this.proxy == null) {
                return false;
            }
            return this.proxy.getPrecompiledHeaderSuffixAppend();
        }

        @Override
        public String[] getNames() {
            if (this.proxy == null) {
                return new String[0];
            }
            return this.proxy.getNames();
        }

        @Override
        public String getVersionFlags() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getVersionFlags();
        }

        @Override
        public String getVersionPattern() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getVersionPattern();
        }

        @Override
        public String getFingerPrintFlags() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getFingerPrintFlags();
        }

        @Override
        public String getFingerPrintPattern() {
            if (this.proxy == null) {
                return "";
            }
            return this.proxy.getFingerPrintPattern();
        }

        @Override
        public boolean skipSearch() {
            if (this.proxy == null) {
                return true;
            }
            return this.proxy.skipSearch();
        }

        @Override
        public ToolchainManager.AlternativePath[] getAlternativePath() {
            if (this.proxy == null) {
                return new ToolchainManager.AlternativePath[0];
            }
            return this.proxy.getAlternativePath();
        }
    }
}

