/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.breakpoints;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;

final class URLEquality {
    private final String protocol;
    private final String host;
    private final int port;
    private final String path;
    private final int hash;

    public URLEquality(URL url) {
        this.protocol = url.getProtocol().toLowerCase();
        String h = url.getHost();
        if (h != null) {
            h = h.toLowerCase();
        }
        this.host = h;
        this.port = url.getPort();
        this.path = url.getPath();
        int last = url.getPath().lastIndexOf("/");
        this.hash = this.protocol.hashCode() + this.host.hashCode() + this.port + url.getPath().substring(last + 1).hashCode();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URLEquality)) {
            return false;
        }
        URLEquality ue = (URLEquality)obj;
        if (ue.hash != this.hash) {
            return false;
        }
        if (this.protocol.equals(ue.protocol) && Objects.equals(this.host, ue.host) && this.port == ue.port) {
            if (Objects.equals(this.path, ue.path)) {
                return true;
            }
            if ("file".equals(this.protocol) && this.path != null && ue.path != null) {
                try {
                    File fThis = new File(this.path);
                    File fObj = new File(ue.path);
                    if (fThis.getCanonicalPath().equals(fObj.getCanonicalPath())) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

