/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditFactory;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CodeAssistanceHintProvider
extends CsmErrorProvider
implements CodeAuditProvider {
    public static final String NAME = "CodeAssistance";
    private Collection<CodeAudit> audits;
    private final AuditPreferences myPreferences;

    public static CsmErrorProvider getInstance() {
        for (CsmErrorProvider provider : Lookup.getDefault().lookupAll(CsmErrorProvider.class)) {
            if (!NAME.equals(provider.getName())) continue;
            return provider;
        }
        return null;
    }

    public CodeAssistanceHintProvider() {
        this.myPreferences = new AuditPreferences(AuditPreferences.AUDIT_PREFERENCES_ROOT.node(NAME));
    }

    CodeAssistanceHintProvider(Preferences preferences) {
        try {
            if (preferences.nodeExists(NAME)) {
                preferences = preferences.node(NAME);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        this.myPreferences = preferences.absolutePath().endsWith("/CodeAssistance") ? new AuditPreferences(preferences) : new AuditPreferences(preferences.node(NAME));
    }

    protected boolean validate(CsmErrorProvider.Request request) {
        CsmFile file = request.getFile();
        if (file == null) {
            return false;
        }
        for (CodeAudit audit : this.getAudits()) {
            if (!audit.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean hasHintControlPanel() {
        return true;
    }

    public String getName() {
        return NAME;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CodeAssistanceHintProvider.class, (String)"CA_NAME");
    }

    public String getDescription() {
        return NbBundle.getMessage(CodeAssistanceHintProvider.class, (String)"CA_DESCRIPTION");
    }

    public String getMimeType() {
        return "text/x-cnd+sourcefile";
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        for (CodeAudit audit : this.getAudits()) {
            AbstractCodeAudit engine = (AbstractCodeAudit)audit;
            if (!engine.isSupportedEvent(kind)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile file = request.getFile();
        if (file != null) {
            if (request.isCancelled()) {
                return;
            }
            CsmCacheManager.enter();
            try {
                for (CodeAudit audit : this.getAudits()) {
                    if (request.isCancelled()) {
                        return;
                    }
                    AbstractCodeAudit engine = (AbstractCodeAudit)audit;
                    if (!engine.isEnabled() || !engine.isSupportedEvent(request.getEvent())) continue;
                    engine.doGetErrors(request, response);
                }
            }
            finally {
                CsmCacheManager.leave();
            }
        }
    }

    public synchronized Collection<CodeAudit> getAudits() {
        if (this.audits == null) {
            ArrayList<CodeAudit> res = new ArrayList<CodeAudit>();
            for (CodeAuditFactory factory : Lookups.forPath((String)"CND/CndHintsFactory/CodeAssistance").lookupAll(CodeAuditFactory.class)) {
                res.add((CodeAudit)factory.create(this.myPreferences));
            }
            Collections.sort(res, new Comparator<CodeAudit>(){

                @Override
                public int compare(CodeAudit o1, CodeAudit o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.audits = res;
        }
        return this.audits;
    }

    public AuditPreferences getPreferences() {
        return this.myPreferences;
    }
}

