/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.uiapi;

import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.spi.project.ActionProgress;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public abstract class LongOperation {
    private static final Default DEFAULT = new Default();

    public abstract void executeLongOperation(CancellableTask var1, String var2, String var3);

    public abstract void executeLongOperation2(Runnable var1, String var2, String var3);

    public static LongOperation getLongOperation() {
        LongOperation defaultFactory = (LongOperation)Lookup.getDefault().lookup(LongOperation.class);
        return defaultFactory == null ? DEFAULT : defaultFactory;
    }

    private static final class Default
    extends LongOperation {
        private Default() {
        }

        @Override
        public void executeLongOperation(CancellableTask task, String title, String message) {
            task.run();
        }

        @Override
        public void executeLongOperation2(Runnable task, String title, String message) {
            task.run();
        }
    }

    public static abstract class CancellableTask
    implements Runnable,
    Cancellable {
        private volatile Thread thread;
        private final CanceledState cancelled;

        public CancellableTask(ActionProgress actionProgress) {
            this.cancelled = new CanceledState(actionProgress);
        }

        protected abstract void runImpl();

        @Override
        public final void run() {
            this.thread = Thread.currentThread();
            if (!this.cancelled.isCanceled()) {
                this.runImpl();
            }
        }

        public boolean cancel() {
            this.cancelled.cancel();
            if (this.thread != null && this.cancelled.isInterruptable()) {
                this.thread.interrupt();
            }
            return true;
        }

        public CanceledState getCancelled() {
            return this.cancelled;
        }
    }

    public static final class CanceledState {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final AtomicBoolean interruptable = new AtomicBoolean(true);
        private final ActionProgress actionProgress;

        private CanceledState(ActionProgress actionProgress) {
            this.actionProgress = actionProgress;
        }

        public synchronized void cancel() {
            this.cancelled.set(true);
            if (this.actionProgress != null) {
                this.actionProgress.finished(false);
            }
        }

        public synchronized boolean isCanceled() {
            return this.cancelled.get();
        }

        public synchronized void setInterruptable(boolean interruptable) {
            this.interruptable.set(interruptable);
        }

        public synchronized boolean isInterruptable() {
            return this.interruptable.get();
        }

        public ActionProgress getActionProgress() {
            return this.actionProgress;
        }
    }
}

