/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ant;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.netbeans.modules.java.source.parsing.CachingArchiveClassLoader;
import org.openide.filesystems.FileUtil;

public class DeleteTask
extends Delete {
    private static final boolean ALL_OS = Boolean.getBoolean("DeleteTask.lock.allOS");
    private static final Logger LOG = Logger.getLogger(DeleteTask.class.getName());
    private static final String PROP_DIST_DIR = "dist.dir";

    public void execute() throws BuildException {
        boolean needsLock = this.requiresExclusion();
        Callable<Void> action = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DeleteTask.super.execute();
                return null;
            }
        };
        try {
            if (needsLock) {
                CachingArchiveClassLoader.writeAction((Callable)action);
            } else {
                action.call();
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private boolean requiresExclusion() {
        boolean osCond = ALL_OS || Os.isFamily((String)"windows");
        boolean distCond = this.isTarget(PROP_DIST_DIR, this.file, this.dir);
        boolean allCond = osCond && distCond;
        LOG.log(Level.FINE, "Requires exclusion: {0}, [os: {1}, dist: {2}]", new Object[]{allCond, osCond, distCond});
        return allCond;
    }

    private boolean isTarget(String propName, File ... targets) {
        Project p = this.getProject();
        String propVal = p.getProperty(propName);
        if (propVal == null) {
            return false;
        }
        File resolvedFile = p.resolveFile(propVal);
        if (resolvedFile == null) {
            return false;
        }
        File normalizedResolvedFile = FileUtil.normalizeFile((File)resolvedFile);
        for (File target : targets) {
            File normalizedTarget;
            if (target == null || !DeleteTask.isParentOf(normalizedTarget = FileUtil.normalizeFile((File)target), normalizedResolvedFile)) continue;
            return true;
        }
        return false;
    }

    private static boolean isParentOf(File folder, File file) {
        while (file != null) {
            if (folder.equals(file)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }
}

