/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class SourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation,
AntProjectListener {
    private static final String CACHE_FREEFORM_ARTIFICAL_BIN = "nbproject/.artificial-binaries";
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private AuxiliaryConfiguration aux;
    private final Map<URI, URL> artificalBinariesCache;
    private Map<URL, FileObject[]> roots = null;

    public SourceForBinaryQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.aux = aux;
        this.artificalBinariesCache = new HashMap<URI, URL>();
        helper.addAntProjectListener((AntProjectListener)this);
    }

    private synchronized void refresh() {
        this.roots = null;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        Map<URL, FileObject[]> rts = this.getRoots();
        assert (rts != null);
        FileObject[] sources = rts.get(binaryRoot);
        return sources == null ? null : new Result(sources);
    }

    public Collection<URL> findBinaryRoots(URL sourceRoot) {
        Map<URL, FileObject[]> rts = this.getRoots();
        assert (rts != null);
        ArrayList<URL> res = new ArrayList<URL>();
        for (Map.Entry<URL, FileObject[]> e : rts.entrySet()) {
            for (FileObject root : e.getValue()) {
                if (!root.toURL().equals(sourceRoot)) continue;
                res.add(e.getKey());
            }
        }
        return res;
    }

    private Map<URL, FileObject[]> getRoots() {
        return (Map)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Map<URL, FileObject[]>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<URL, FileObject[]> run() {
                SourceForBinaryQueryImpl sourceForBinaryQueryImpl = SourceForBinaryQueryImpl.this;
                synchronized (sourceForBinaryQueryImpl) {
                    if (SourceForBinaryQueryImpl.this.roots == null) {
                        HashMap<URL, FileObject[]> tmp = new HashMap<URL, FileObject[]>();
                        Element java = SourceForBinaryQueryImpl.this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/4", true);
                        if (java == null) {
                            return null;
                        }
                        for (Element compilationUnit : XMLUtil.findSubElements((Element)java)) {
                            assert (compilationUnit.getLocalName().equals("compilation-unit")) : compilationUnit;
                            List binaries = SourceForBinaryQueryImpl.this.findBinaries(compilationUnit);
                            List<FileObject> packageRoots = Classpaths.findPackageRoots(SourceForBinaryQueryImpl.this.helper, SourceForBinaryQueryImpl.this.evaluator, compilationUnit);
                            FileObject[] sources = packageRoots.toArray(new FileObject[packageRoots.size()]);
                            if (binaries.isEmpty()) {
                                binaries = SourceForBinaryQueryImpl.this.createArtificialBinaries(sources);
                            }
                            for (URL u : binaries) {
                                FileObject[] orig = (FileObject[])tmp.get(u);
                                if (orig != null) {
                                    FileObject[] merged = new FileObject[orig.length + sources.length];
                                    System.arraycopy(orig, 0, merged, 0, orig.length);
                                    System.arraycopy(sources, 0, merged, orig.length, sources.length);
                                    sources = merged;
                                }
                                tmp.put(u, sources);
                            }
                        }
                        SourceForBinaryQueryImpl.this.roots = Collections.unmodifiableMap(tmp);
                    }
                    return SourceForBinaryQueryImpl.this.roots;
                }
            }
        });
    }

    private List<URL> findBinaries(Element compilationUnitEl) {
        ArrayList<URL> binaries = new ArrayList<URL>();
        for (Element builtToEl : XMLUtil.findSubElements((Element)compilationUnitEl)) {
            String text;
            String textEval;
            if (!builtToEl.getLocalName().equals("built-to") || (textEval = this.evaluator.evaluate(text = XMLUtil.findText((Node)builtToEl))) == null) continue;
            File buildProduct = this.helper.resolveFile(textEval);
            URL buildProductURL = FileUtil.urlForArchiveOrDir((File)buildProduct);
            binaries.add(buildProductURL);
        }
        return binaries;
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.refresh();
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    private List<URL> createArtificialBinaries(FileObject[] fos) {
        assert (Thread.holdsLock(this));
        ArrayList<URL> res = new ArrayList<URL>(fos.length);
        File artBinaries = null;
        MessageDigest md5 = null;
        try {
            for (FileObject fo : fos) {
                URI srcURI = fo.toURI();
                URL bin = this.artificalBinariesCache.get(srcURI);
                if (bin == null) {
                    if (artBinaries == null) {
                        File projectFolder = FileUtil.toFile((FileObject)this.helper.getProjectDirectory());
                        artBinaries = new File(projectFolder, CACHE_FREEFORM_ARTIFICAL_BIN.replace('/', File.separatorChar));
                        md5 = MessageDigest.getInstance("MD5");
                    } else {
                        md5.reset();
                    }
                    String digest = SourceForBinaryQueryImpl.str(md5.digest(srcURI.toString().getBytes("UTF-8")));
                    File binFile = new File(artBinaries, digest);
                    bin = FileUtil.urlForArchiveOrDir((File)binFile);
                    this.artificalBinariesCache.put(srcURI, bin);
                }
                res.add(bin);
            }
            return res;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String str(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            String sbyte = Integer.toHexString(data[i] & 0xFF);
            if (sbyte.length() == 1) {
                sb.append('0');
            }
            sb.append(sbyte);
        }
        return sb.toString();
    }

    private static class Result
    implements SourceForBinaryQuery.Result {
        private FileObject[] ret;

        public Result(FileObject[] ret) {
            this.ret = ret;
        }

        public FileObject[] getRoots() {
            return this.ret;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

