/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;

public class AttributeFinder {
    private final XMLSyntaxSupport syntaxSupport;
    private final int start;
    private int foundOffset = -1;

    public AttributeFinder(XMLSyntaxSupport syntaxSupport, int start) {
        this.syntaxSupport = syntaxSupport;
        this.start = start;
    }

    public boolean find(String attrName) throws BadLocationException {
        this.foundOffset = -1;
        BaseDocument doc = this.syntaxSupport.getDocument();
        TokenItem item = this.syntaxSupport.getTokenChain(this.start, Math.min(this.start + 1, doc.getLength()));
        if (item == null || item.getTokenID() != XMLDefaultTokenContext.TAG) {
            return false;
        }
        String currentAttrName = null;
        for (item = item.getNext(); item != null; item = item.getNext()) {
            TokenID id = item.getTokenID();
            if (id == XMLDefaultTokenContext.ARGUMENT) {
                currentAttrName = item.getImage();
                if (currentAttrName == null || !currentAttrName.equals(attrName)) continue;
                this.foundOffset = item.getOffset();
                return true;
            }
            if (id == XMLDefaultTokenContext.TAG) break;
        }
        return false;
    }

    public int getFoundOffset() {
        return this.foundOffset;
    }
}

