/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class MoveClassPanel
extends JPanel
implements ActionListener,
DocumentListener,
CustomRefactoringPanel {
    private static final ListCellRenderer GROUP_CELL_RENDERER = new GroupCellRenderer();
    private static final ListCellRenderer PROJECT_CELL_RENDERER = new ProjectCellRenderer();
    private final String startPackage;
    private final FileObject fo;
    private Project project;
    private boolean initialized = false;
    private JPanel bottomPanel;
    private JLabel labelHeadLine;
    private JLabel labelLocation;
    private JLabel labelPackage;
    private JLabel labelProject;
    private JComboBox packageComboBox;
    private JComboBox projectsComboBox;
    private JComboBox rootComboBox;

    public MoveClassPanel(String startPackage, String sourceName, FileObject fo) {
        this.startPackage = startPackage;
        this.fo = fo;
        this.initComponents();
        this.initComboBoxes();
        this.labelHeadLine.setText(sourceName);
        this.project = fo != null ? FileOwnerQuery.getOwner((FileObject)fo) : OpenProjects.getDefault().getOpenProjects()[0];
    }

    private void initComboBoxes() {
        this.projectsComboBox.setEnabled(true);
        this.projectsComboBox.setRenderer(PROJECT_CELL_RENDERER);
        this.packageComboBox.setEnabled(true);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.rootComboBox.setEnabled(true);
        this.rootComboBox.setRenderer(GROUP_CELL_RENDERER);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initValues(this.startPackage);
        this.rootComboBox.addActionListener(this);
        this.packageComboBox.addActionListener(this);
        this.projectsComboBox.addActionListener(this);
        Component textField = this.packageComboBox.getEditor().getEditorComponent();
        if (textField instanceof JTextField) {
            ((JTextField)textField).getDocument().addDocumentListener(this);
        }
        this.initialized = true;
    }

    public void initValues(String preselectedFolder) {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        Arrays.sort(openProjects, new ProjectByDisplayNameComparator());
        this.projectsComboBox.setModel(new DefaultComboBoxModel<Project>(openProjects));
        this.projectsComboBox.setSelectedItem(this.project);
        this.updateSourceRoots();
        this.updatePackages();
        if (preselectedFolder != null) {
            this.packageComboBox.setSelectedItem(preselectedFolder);
        }
    }

    @Override
    public void requestFocus() {
        this.packageComboBox.requestFocus();
    }

    public FileObject getRootFolder() {
        return ((SourceGroup)this.rootComboBox.getSelectedItem()).getRootFolder();
    }

    public String getPackageName() {
        return this.packageComboBox.getEditor().getItem().toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.projectsComboBox == e.getSource()) {
            this.project = (Project)this.projectsComboBox.getSelectedItem();
            this.updateSourceRoots();
            this.updatePackages();
        } else if (this.rootComboBox == e.getSource()) {
            this.updatePackages();
        }
    }

    private void updatePackages() {
        SourceGroup selectedGroup = (SourceGroup)this.rootComboBox.getSelectedItem();
        if (selectedGroup != null) {
            this.packageComboBox.setModel(PackageView.createListView((SourceGroup)selectedGroup));
        } else {
            this.packageComboBox.setModel(new DefaultComboBoxModel());
        }
    }

    private void updateSourceRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        List groups = GroovySources.getGroovySourceGroups((Sources)sources);
        if (groups.isEmpty()) {
            groups.addAll(Arrays.asList(sources.getSourceGroups("generic")));
        }
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(groups.toArray(new SourceGroup[0])));
        for (SourceGroup group : groups) {
            if (!group.contains(this.fo)) continue;
            this.rootComboBox.setSelectedItem(group);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    public Component getComponent() {
        return this;
    }

    private void initComponents() {
        this.labelProject = new JLabel();
        this.projectsComboBox = new JComboBox();
        this.labelLocation = new JLabel();
        this.rootComboBox = new JComboBox();
        this.labelPackage = new JLabel();
        this.packageComboBox = new JComboBox();
        this.bottomPanel = new JPanel();
        this.labelHeadLine = new JLabel();
        this.setLayout(new GridBagLayout());
        this.labelProject.setLabelFor(this.projectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelProject, (String)NbBundle.getMessage(MoveClassPanel.class, (String)"LBL_Project"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectsComboBox, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/groovy/refactoring/ui/Bundle");
        this.projectsComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_projectsCombo"));
        this.labelLocation.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(MoveClassPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelLocation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_rootCombo"));
        this.labelPackage.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelPackage, (String)NbBundle.getMessage(MoveClassPanel.class, (String)"LBL_ToPackage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelPackage, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MoveClassPanel.class, (String)"MoveClassPanel.packageComboBox.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanel, gridBagConstraints);
        this.labelHeadLine.setBorder(BorderFactory.createEmptyBorder(1, 1, 6, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.labelHeadLine, gridBagConstraints);
    }

    private static class ProjectByDisplayNameComparator
    implements Comparator {
        private static Comparator COLLATOR = Collator.getInstance();

        private ProjectByDisplayNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Project)) {
                return 1;
            }
            if (!(o2 instanceof Project)) {
                return -1;
            }
            Project p1 = (Project)o1;
            Project p2 = (Project)o2;
            return COLLATOR.compare(ProjectUtils.getInformation((Project)p1).getDisplayName(), ProjectUtils.getInformation((Project)p2).getDisplayName());
        }
    }

    private static class ProjectCellRenderer
    extends BaseCellRenderer {
        private ProjectCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)value));
                this.setText(pi.getDisplayName());
                this.setIcon(pi.getIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static class GroupCellRenderer
    extends BaseCellRenderer {
        private GroupCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value instanceof SourceGroup) {
                SourceGroup g = (SourceGroup)value;
                this.setText(g.getDisplayName());
                this.setIcon(g.getIcon(false));
            } else {
                this.setText("");
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static abstract class BaseCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public BaseCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

