/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client;

import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLKeyException;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnClientFactory;
import org.netbeans.modules.subversion.remote.client.SvnClientRefreshHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.client.cli.CommandlineClient;
import org.netbeans.modules.subversion.remote.config.SvnConfigFiles;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class SvnClientInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = Logger.getLogger(SvnClientInvocationHandler.class.getName());
    protected static final String GET_SINGLE_STATUS = "getSingleStatus";
    protected static final String GET_STATUS = "getStatus";
    protected static final String GET_INFO_FROM_WORKING_COPY = "getInfoFromWorkingCopy";
    protected static final String CANCEL_OPERATION = "cancel";
    private static final String DISPOSE_METHOD = "dispose";
    private static final String CHECKOUT_METHOD = "checkout";
    private static final Set<String> ADMINISTRATIVE_METHODS = new HashSet<String>(Arrays.asList("addConflictResolutionCallback", "addNotifyListener", "addPasswordCallback", "cancelOperation", "canCommitAcrossWC", "dispose", "getAdminDirectoryName", "getNotificationHandler", "getPostCommitError", "getSvnUrl", "isAdminDirectory", "isThreadsafe", "removeNotifyListener", "setConfigDirectory", "setProgressListener", "setPassword", "setUsername", "statusReturnsRemoteInfo", "suggestMergeSources", "cancel", "dispose"));
    private static final Set<String> READ_ONLY_METHODS = new HashSet<String>(Arrays.asList("annotate", "createPatch", "diff", "diffSummarize", "doImport", "doExport", "getContent", "getDirEntry", "getIgnoredPatterns", "getInfo", "getInfoFromWorkingCopy", "getKeywords", "getList", "getListWithLocks", "getLogMessages", "getMergeInfo", "getMergeinfoLog", "getProperties", "getPropertiesIncludingInherited", "getRevProperties", "getRevProperty", "getSingleStatus", "getStatus", "propertyGet"));
    private final CommandlineClient adapter;
    private final SvnClientDescriptor desc;
    private final Cancellable cancellable;
    private SvnProgressSupport support;
    private final int handledExceptions;
    private static boolean metricsAlreadyLogged = false;
    private volatile boolean disposed;
    private static final Map<String, Mutex> locks = new HashMap<String, Mutex>(5);
    private static final ConfigFiles SENSITIVE_CONFIG_FILES = new ConfigFiles();
    private static final boolean KEEP_SERVERS_FILE = Boolean.getBoolean("versioning.subversion.keepServersFile");

    public SvnClientInvocationHandler(CommandlineClient adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions) {
        assert (adapter != null);
        assert (desc != null);
        this.adapter = adapter;
        this.desc = desc;
        this.support = support;
        this.handledExceptions = handledExceptions;
        this.cancellable = new Cancellable(){

            public boolean cancel() {
                try {
                    SvnClientInvocationHandler.this.adapter.cancelOperation();
                }
                catch (SVNClientException ex) {
                    Subversion.LOG.log(Level.SEVERE, null, ex);
                    return false;
                }
                return true;
            }
        };
    }

    private static String print(Object[] args) {
        if (args == null || args.length == 0) {
            return "no parameters";
        }
        StringBuilder sb = new StringBuilder();
        for (Object a : args) {
            sb.append("\n  ");
            if (a == null) {
                sb.append("null");
            } else {
                sb.append(a.toString());
                sb.append(" : ");
                sb.append(a.getClass().getName());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        boolean fsReadOnlyAction = this.isFSWrittingCommand(method);
        try {
            Object action;
            Mutex mutex;
            block30: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "~~~ SVN: invoking ''{0}'' with {1}", new Object[]{method.getName(), SvnClientInvocationHandler.print(args)});
                }
                if (DISPOSE_METHOD.equals(method.getName())) {
                    this.disposed = true;
                }
                if ((mutex = this.getLock(method, args)) == null) {
                    Object object = this.invokeMethod(method, args);
                    return object;
                }
                action = new Mutex.ExceptionAction<Object>(){

                    public Object run() throws Exception {
                        return SvnClientInvocationHandler.this.invokeMethod(method, args);
                    }
                };
                try {
                    if (!this.isReadMethod(method)) break block30;
                    Object refreshHandler = mutex.readAccess((Mutex.ExceptionAction)action);
                    return refreshHandler;
                }
                catch (MutexException ex) {
                    try {
                        throw ex.getException();
                    }
                    catch (Exception e) {
                        block31: {
                            if (!this.handleException((SvnClient)proxy, e, method.getName())) break block31;
                            action = this.invoke(proxy, method, args);
                            return action;
                        }
                        try {
                            throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                        }
                        catch (InvocationTargetException ite) {
                            Throwable t = ite.getTargetException();
                            if (t instanceof SVNClientException) {
                                throw t;
                            }
                            throw ite;
                        }
                        catch (SSLKeyException ex2) {
                            if (ex2.getCause() instanceof InvalidKeyException) {
                                InvalidKeyException ike = (InvalidKeyException)ex2.getCause();
                                if (ike.getMessage().toLowerCase(Locale.ENGLISH).equals("illegal key size or default parameters")) {
                                    SvnClientExceptionHandler.handleInvalidKeyException(ike);
                                }
                                Object refreshHandler = null;
                                return refreshHandler;
                            }
                            throw ex2;
                        }
                        catch (Throwable t) {
                            Throwable c;
                            if (t instanceof InterruptedException) {
                                throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                            }
                            if (t instanceof SVNClientException && (c = t.getCause()) instanceof IOException && (c = c.getCause()) instanceof InterruptedException) {
                                throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                            }
                            c = t.getCause();
                            if (c != null) {
                                String exMessage = c.getMessage();
                                if (c instanceof InterruptedException || exMessage != null && SvnClientExceptionHandler.isOperationCancelled(exMessage)) {
                                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                                }
                            }
                            if (this.support != null && this.support.isCanceled()) {
                                if (Subversion.LOG.isLoggable(Level.FINE)) {
                                    Subversion.LOG.log(Level.FINE, null, t);
                                }
                                throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                            }
                            throw t;
                        }
                    }
                }
            }
            Object refreshHandler = mutex.writeAccess((Mutex.ExceptionAction)action);
            return refreshHandler;
        }
        finally {
            SvnClientRefreshHandler refreshHandler;
            if (fsReadOnlyAction && (refreshHandler = Subversion.getInstance().getRefreshHandler()) != null) {
                refreshHandler.refresh();
            }
        }
    }

    private boolean isFSWrittingCommand(Method method) {
        return !method.getName().equals("update") && !method.getName().equals("revert") && !method.getName().equals("switchToUrl") && !method.getName().equals("remove") && !method.getName().equals("mkdir") && !method.getName().equals(CHECKOUT_METHOD) && !method.getName().equals("copy") && !method.getName().equals("move") && !method.getName().equals("merge");
    }

    private void logClientInvoked() {
        if (metricsAlreadyLogged) {
            return;
        }
        try {
            SvnClientFactory.checkClientAvailable(new Context(VCSFileProxy.createFileProxy((FileObject)this.adapter.getFileSystem().getRoot())));
        }
        catch (SVNClientException e) {
            return;
        }
        Utils.logVCSClientEvent((String)"SVN", (String)"CLI");
        metricsAlreadyLogged = true;
    }

    private boolean parallelizable(Method method) {
        String methodName = method.getName();
        return this.isClientAdministrativMethod(methodName) || this.isCancelCommand(method) || methodName.equals(GET_SINGLE_STATUS) || methodName.equals(GET_INFO_FROM_WORKING_COPY) || methodName.equals(GET_STATUS) || "getIgnoredPatterns".equals(methodName);
    }

    private Mutex getLock(Method method, Object[] args) {
        if (EventQueue.isDispatchThread() && this.parallelizable(method) || args == null || this.isClientAdministrativMethod(method.getName())) {
            return null;
        }
        VCSFileProxy root = null;
        for (Object o : args) {
            if (o instanceof VCSFileProxy) {
                VCSFileProxy f = (VCSFileProxy)o;
                root = SvnClientInvocationHandler.getRoot(method.getName(), f);
            } else if (o instanceof VCSFileProxy[]) {
                for (VCSFileProxy f : (VCSFileProxy[])o) {
                    root = SvnClientInvocationHandler.getRoot(method.getName(), f);
                    if (root != null) break;
                }
            }
            if (root != null) break;
        }
        if (root != null) {
            return this.getLock(root.getPath());
        }
        return null;
    }

    private static VCSFileProxy getRoot(String methodName, VCSFileProxy f) {
        if (CHECKOUT_METHOD.equals(methodName)) {
            return f;
        }
        return Subversion.getInstance().getTopmostManagedAncestor(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mutex getLock(String key) {
        Map<String, Mutex> map = locks;
        synchronized (map) {
            Mutex mutex = locks.get(key);
            if (mutex == null) {
                mutex = new Mutex();
                locks.put(key, mutex);
            }
            return mutex;
        }
    }

    private boolean isClientAdministrativMethod(String name) {
        return ADMINISTRATIVE_METHODS.contains(name);
    }

    private boolean isReadMethod(Method method) {
        return READ_ONLY_METHODS.contains(method.getName());
    }

    protected boolean isCancelCommand(Method method) {
        String methodName = method.getName();
        return Cancellable.class.isAssignableFrom(method.getDeclaringClass()) && methodName.equals(CANCEL_OPERATION);
    }

    protected Object invokeMethod(Method proxyMethod, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.handle(proxyMethod, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Object handle(Method proxyMethod, Object[] args) throws SecurityException, InvocationTargetException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException {
        Object arg;
        Class<?>[] parameters = proxyMethod.getParameterTypes();
        Class<?> declaringClass = proxyMethod.getDeclaringClass();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                arg = args[i];
                if (arg == null || !(arg instanceof SVNUrl)) continue;
                try {
                    args[i] = SvnUtils.decodeAndEncodeUrl((SVNUrl)arg);
                    continue;
                }
                catch (MalformedURLException ex) {
                    Subversion.LOG.log(Level.INFO, "Url: " + arg, ex);
                }
            }
        }
        if (SvnClient.class.isAssignableFrom(declaringClass)) {
            Object ret;
            if (this.support != null) {
                this.support.setCancellableDelegate(this.cancellable);
            }
            VCSFileProxy serversConfigFile = null;
            try {
                if (this.desc != null && this.desc.getSvnUrl() != null) {
                    arg = SENSITIVE_CONFIG_FILES;
                    // MONITORENTER : arg
                    serversConfigFile = SvnConfigFiles.getInstance(this.adapter.getFileSystem()).storeSvnServersSettings(this.desc.getSvnUrl());
                    if (serversConfigFile != null) {
                        SENSITIVE_CONFIG_FILES.add(serversConfigFile);
                    }
                    // MONITOREXIT : arg
                    if (!this.parallelizable(proxyMethod) && !"getInfo".equals(proxyMethod.getName())) {
                        String url = this.desc.getSvnUrl().toString();
                        if (url.startsWith("file://")) {
                            url = null;
                        }
                        Utils.logVCSExternalRepository((String)"SVN", (String)url);
                    }
                }
                this.logClientInvoked();
                ret = this.adapter.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.adapter, args);
                if (serversConfigFile != null) {
                    SENSITIVE_CONFIG_FILES.decrease(serversConfigFile);
                }
            }
            catch (Throwable throwable) {
                if (serversConfigFile == null) throw throwable;
                SENSITIVE_CONFIG_FILES.decrease(serversConfigFile);
                throw throwable;
            }
            if (this.support == null) return ret;
            this.support.setCancellableDelegate(null);
            return ret;
        }
        if (Cancellable.class.isAssignableFrom(declaringClass)) {
            return this.cancellable.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.cancellable, args);
        }
        if (!SvnClientDescriptor.class.isAssignableFrom(declaringClass)) return this.adapter.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.adapter, args);
        if (this.desc == null) throw new NoSuchMethodException(proxyMethod.getName());
        return this.desc.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.desc, args);
    }

    private boolean handleException(SvnClient client, Throwable t, String methodName) throws Throwable {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getCause();
        }
        if (!(t instanceof SVNClientException)) {
            throw t;
        }
        SvnClientExceptionHandler eh = new SvnClientExceptionHandler((SVNClientException)t, this.adapter, client, this.desc, this.handledExceptions);
        eh.setMethod(methodName);
        return eh.handleException();
    }

    protected void finalize() throws Throwable {
        if (!this.disposed) {
            try {
                this.adapter.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }

    private static class ConfigFiles
    extends HashMap<VCSFileProxy, Integer> {
        private ConfigFiles() {
        }

        public synchronized void add(VCSFileProxy file) {
            Integer currentCounter = (Integer)this.get(file);
            if (currentCounter == null) {
                currentCounter = 0;
            }
            Integer n = currentCounter;
            Integer n2 = currentCounter = Integer.valueOf(currentCounter + 1);
            this.put(file, currentCounter);
        }

        public synchronized void decrease(VCSFileProxy file) {
            Integer currentCounter = (Integer)this.get(file);
            if (currentCounter == null) {
                currentCounter = 1;
            }
            Integer n = currentCounter;
            Integer n2 = currentCounter = Integer.valueOf(currentCounter - 1);
            if (currentCounter == 0) {
                this.remove(file);
                if (!KEEP_SERVERS_FILE) {
                    VCSFileProxySupport.delete((VCSFileProxy)file);
                }
            } else {
                this.put(file, currentCounter);
            }
        }
    }
}

