/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.api;

import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.ConnectionNotifierImplementation;
import org.openide.util.Lookup;

public class ConnectionNotifier {
    private static ConnectionNotifierImplementation impl;

    private ConnectionNotifier() {
    }

    public static void addTask(ExecutionEnvironment executionEnvironment, NamedRunnable task) {
        ConnectionNotifier.getImpl().addTask(executionEnvironment, task);
    }

    public static void removeTask(ExecutionEnvironment executionEnvironment, NamedRunnable task) {
        ConnectionNotifier.getImpl().removeTask(executionEnvironment, task);
    }

    public static void addExplicitConnectionListener(ExecutionEnvironment executionEnvironment, ExplicitConnectionListener listener) {
        ConnectionNotifier.getImpl().addExplicitConnectionListener(executionEnvironment, listener);
    }

    public static void removeExplicitConnectionListener(ExecutionEnvironment executionEnvironment, ExplicitConnectionListener listener) {
        ConnectionNotifier.getImpl().removeExplicitConnectionListener(executionEnvironment, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnectionNotifierImplementation getImpl() {
        Class<ClassNotFoundException> clazz = ClassNotFoundException.class;
        synchronized (ClassNotFoundException.class) {
            if (impl == null) {
                impl = (ConnectionNotifierImplementation)Lookup.getDefault().lookup(ConnectionNotifierImplementation.class);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return impl == null ? new Dummy() : impl;
        }
    }

    private static class Dummy
    implements ConnectionNotifierImplementation {
        private Dummy() {
        }

        @Override
        public void addTask(ExecutionEnvironment executionEnvironment, NamedRunnable task) {
        }

        @Override
        public void removeTask(ExecutionEnvironment executionEnvironment, NamedRunnable task) {
        }

        @Override
        public void addExplicitConnectionListener(ExecutionEnvironment executionEnvironment, ExplicitConnectionListener listener) {
        }

        @Override
        public void removeExplicitConnectionListener(ExecutionEnvironment executionEnvironment, ExplicitConnectionListener listener) {
        }
    }

    public static abstract class NamedRunnable
    implements Runnable {
        private final String name;

        public NamedRunnable(String name) {
            this.name = name;
        }

        @Override
        public final void run() {
            String oldName = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(this.getName());
                this.runImpl();
            }
            finally {
                Thread.currentThread().setName(oldName);
            }
        }

        public String getName() {
            return this.name;
        }

        protected abstract void runImpl();
    }

    public static interface ExplicitConnectionListener {
        public void connected();
    }
}

