/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.session.TimerOptions;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class SessionGenerator {
    public static final String EJB21_EJBCLASS = "Templates/J2EE/EJB21/SessionEjbClass.java";
    public static final String EJB21_LOCAL = "Templates/J2EE/EJB21/SessionLocal.java";
    public static final String EJB21_LOCALHOME = "Templates/J2EE/EJB21/SessionLocalHome.java";
    public static final String EJB21_REMOTE = "Templates/J2EE/EJB21/SessionRemote.java";
    public static final String EJB21_REMOTEHOME = "Templates/J2EE/EJB21/SessionRemoteHome.java";
    public static final String EJB30_STATELESS_EJBCLASS = "Templates/J2EE/EJB30/StatelessEjbClass.java";
    public static final String EJB30_STATEFUL_EJBCLASS = "Templates/J2EE/EJB30/StatefulEjbClass.java";
    public static final String EJB30_LOCAL = "Templates/J2EE/EJB30/SessionLocal.java";
    public static final String EJB30_REMOTE = "Templates/J2EE/EJB30/SessionRemote.java";
    public static final String EJB31_SINGLETON_EJBCLASS = "Templates/J2EE/EJB31/SingletonEjbClass.java";
    public static final String ANNOTATION_LOCAL_BEAN = "javax.ejb.LocalBean";
    public static final String TEMPLATE_PROPERTY_INTERFACES = "interfaces";
    public static final String TEMPLATE_PROPERTY_LOCAL_BEAN = "annotationLocalBean";
    private final FileObject pkg;
    private FileObject remotePkg;
    private final boolean hasRemote;
    private final boolean hasLocal;
    private final String sessionType;
    private final boolean isSimplified;
    private final boolean isXmlBased;
    private final EJBNameOptions ejbNameOptions;
    private final String ejbName;
    private final String ejbClassName;
    private final String remoteName;
    private final String remoteHomeName;
    private final String localName;
    private final String localHomeName;
    private final String displayName;
    private final String packageName;
    private final String packageNameWithDot;
    private final Map<String, Object> templateParameters;

    public static SessionGenerator create(String wizardTargetName, FileObject pkg, boolean hasRemote, boolean hasLocal, String sessionType, boolean isSimplified, boolean hasBusinessInterface, boolean isXmlBased, TimerOptions timerOptions, boolean exposeTimer, boolean nonPersistentTimer) {
        return new SessionGenerator(wizardTargetName, pkg, hasRemote, hasLocal, sessionType, isSimplified, hasBusinessInterface, isXmlBased, timerOptions, exposeTimer, nonPersistentTimer, false);
    }

    protected SessionGenerator(String wizardTargetName, FileObject pkg, boolean hasRemote, boolean hasLocal, String sessionType, boolean isSimplified, boolean hasBusinessInterface, boolean isXmlBased, TimerOptions timerOptions, boolean exposeTimer, boolean nonPersistentTimer, boolean isTest) {
        this.pkg = pkg;
        this.remotePkg = pkg;
        this.hasRemote = hasRemote;
        this.hasLocal = hasLocal;
        this.sessionType = sessionType;
        this.isSimplified = isSimplified;
        this.isXmlBased = isXmlBased;
        this.ejbNameOptions = new EJBNameOptions();
        this.ejbName = this.ejbNameOptions.getSessionEjbNamePrefix() + wizardTargetName + this.ejbNameOptions.getSessionEjbNameSuffix();
        this.ejbClassName = this.ejbNameOptions.getSessionEjbClassPrefix() + wizardTargetName + this.ejbNameOptions.getSessionEjbClassSuffix();
        this.remoteName = this.ejbNameOptions.getSessionRemotePrefix() + wizardTargetName + this.ejbNameOptions.getSessionRemoteSuffix();
        this.remoteHomeName = this.ejbNameOptions.getSessionRemoteHomePrefix() + wizardTargetName + this.ejbNameOptions.getSessionRemoteHomeSuffix();
        this.localName = this.ejbNameOptions.getSessionLocalPrefix() + wizardTargetName + this.ejbNameOptions.getSessionLocalSuffix();
        this.localHomeName = this.ejbNameOptions.getSessionLocalHomePrefix() + wizardTargetName + this.ejbNameOptions.getSessionLocalHomeSuffix();
        this.displayName = this.ejbNameOptions.getSessionDisplayNamePrefix() + wizardTargetName + this.ejbNameOptions.getSessionDisplayNameSuffix();
        this.packageName = EjbGenerationUtil.getSelectedPackageName(pkg);
        this.packageNameWithDot = this.packageName + ".";
        this.templateParameters = new HashMap<String, Object>();
        this.templateParameters.put("package", this.packageName);
        this.templateParameters.put("localInterface", this.packageNameWithDot + this.localName);
        this.templateParameters.put("remoteInterface", this.packageNameWithDot + this.remoteName);
        if (timerOptions != null) {
            this.templateParameters.put("timerExist", true);
            this.templateParameters.put("timerString", SessionGenerator.getScheduleAnnotationValue(timerOptions, nonPersistentTimer));
            this.templateParameters.put("exposeTimer", exposeTimer && (hasLocal || hasRemote));
        } else {
            this.templateParameters.put("timerExist", false);
            this.templateParameters.put("exposeTimer", false);
        }
        if (isTest) {
            this.templateParameters.put("date", "{date}");
            this.templateParameters.put("time", "{time}");
            this.templateParameters.put("user", "{user}");
        }
    }

    public static String getScheduleAnnotationValue(TimerOptions timerOptions, boolean nonPersistentTimer) {
        String timerValue = timerOptions.getAnnotationValue();
        return nonPersistentTimer ? timerValue + ", persistent = false" : timerValue;
    }

    public void initRemoteInterfacePackage(Project projectForRemoteInterface, String remoteInterfacePackageName, FileObject ejbSourcePackage) throws IOException {
        this.remotePkg = SessionGenerator.createRemoteInterfacePackage(projectForRemoteInterface, remoteInterfacePackageName, ejbSourcePackage);
    }

    public static FileObject createRemoteInterfacePackage(Project projectForRemoteInterface, String remoteInterfacePackageName, FileObject ejbSourcePackage) throws IOException {
        assert (ProjectUtils.getSources((Project)projectForRemoteInterface).getSourceGroups("java").length > 0);
        FileObject root = ProjectUtils.getSources((Project)projectForRemoteInterface).getSourceGroups("java")[0].getRootFolder();
        FileObject remotePkg = FileUtil.createFolder((FileObject)root, (String)remoteInterfacePackageName.replace('.', '/'));
        ProjectClassPathModifier.addProjects((Project[])new Project[]{projectForRemoteInterface}, (FileObject)ejbSourcePackage, (String)"classpath/compile");
        assert (LibraryManager.getDefault().getLibrary("javaee-api-6.0") != null);
        if (ClassPath.getClassPath((FileObject)remotePkg, (String)"classpath/compile").findResource("javax/ejb") == null) {
            try {
                ProjectClassPathModifier.addLibraries((Library[])new Library[]{LibraryManager.getDefault().getLibrary("javaee-api-6.0")}, (FileObject)remotePkg, (String)"classpath/compile_only");
            }
            catch (UnsupportedOperationException e) {
                ProjectClassPathModifier.addLibraries((Library[])new Library[]{LibraryManager.getDefault().getLibrary("javaee-api-6.0")}, (FileObject)remotePkg, (String)"classpath/compile");
            }
        }
        return remotePkg;
    }

    public FileObject generate() throws IOException {
        FileObject resultFileObject = null;
        if (this.isSimplified) {
            resultFileObject = this.generateEJB30Classes();
            Project project = FileOwnerQuery.getOwner((FileObject)this.pkg);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
            if (this.isXmlBased) {
                this.generateEJB30Xml();
            }
        } else {
            resultFileObject = this.generateEJB21Classes();
            Project project = FileOwnerQuery.getOwner((FileObject)this.pkg);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
            if (this.isXmlBased) {
                this.generateEJB21Xml();
            }
        }
        return resultFileObject;
    }

    private FileObject generateEJB21Classes() throws IOException {
        FileObject ejbClassFO = GenerationUtils.createClass((String)EJB21_EJBCLASS, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
        if (this.hasRemote) {
            GenerationUtils.createClass((String)EJB21_REMOTE, (FileObject)this.remotePkg, (String)this.remoteName, null, this.templateParameters);
            GenerationUtils.createClass((String)EJB21_REMOTEHOME, (FileObject)this.remotePkg, (String)this.remoteHomeName, null, this.templateParameters);
        }
        if (this.hasLocal) {
            GenerationUtils.createClass((String)EJB21_LOCAL, (FileObject)this.pkg, (String)this.localName, null, this.templateParameters);
            GenerationUtils.createClass((String)EJB21_LOCALHOME, (FileObject)this.pkg, (String)this.localHomeName, null, this.templateParameters);
        }
        return ejbClassFO;
    }

    private FileObject generateEJB30Classes() throws IOException {
        String ejbClassTemplateName = "";
        if (this.sessionType.equals("Stateless")) {
            ejbClassTemplateName = EJB30_STATELESS_EJBCLASS;
        } else if (this.sessionType.equals("Stateful")) {
            ejbClassTemplateName = EJB30_STATEFUL_EJBCLASS;
        } else if (this.sessionType.equals("Singleton")) {
            ejbClassTemplateName = EJB31_SINGLETON_EJBCLASS;
        } else assert (false);
        if (this.hasLocal && this.hasRemote) {
            this.templateParameters.put(TEMPLATE_PROPERTY_INTERFACES, this.remoteName + ", " + this.localName);
        } else if (this.hasLocal) {
            this.templateParameters.put(TEMPLATE_PROPERTY_INTERFACES, this.localName);
        } else if (this.hasRemote) {
            this.templateParameters.put(TEMPLATE_PROPERTY_INTERFACES, this.remoteName);
        } else {
            Project project = FileOwnerQuery.getOwner((FileObject)this.pkg);
            J2eeProjectCapabilities projectCap = J2eeProjectCapabilities.forProject((Project)project);
            if (projectCap != null && projectCap.isEjb31Supported()) {
                this.templateParameters.put(TEMPLATE_PROPERTY_LOCAL_BEAN, Boolean.TRUE.toString());
            }
        }
        FileObject ejbClassFO = GenerationUtils.createClass((String)ejbClassTemplateName, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
        if (this.hasRemote) {
            GenerationUtils.createClass((String)EJB30_REMOTE, (FileObject)this.remotePkg, (String)this.remoteName, null, this.templateParameters);
        }
        if (this.hasLocal) {
            GenerationUtils.createClass((String)EJB30_LOCAL, (FileObject)this.pkg, (String)this.localName, null, this.templateParameters);
        }
        return ejbClassFO;
    }

    private void generateEJB21Xml() throws IOException {
        org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar;
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.pkg);
        FileObject ddFO = ejbModule.getDeploymentDescriptor();
        if (ddFO == null && ejbModule.getMetaInf() != null) {
            String resource = "org-netbeans-modules-j2ee-ejbjarproject/ejb-jar-2.1.xml";
            ddFO = FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)resource), (FileObject)ejbModule.getMetaInf(), (String)"ejb-jar");
        }
        if ((ejbJar = DDProvider.getDefault().getDDRoot(ddFO)) == null) {
            String fileName = ddFO == null ? null : FileUtil.getFileDisplayName((FileObject)ddFO);
            Logger.getLogger(SessionGenerator.class.getName()).warning("EjbJar not found for " + fileName);
            return;
        }
        EnterpriseBeans beans = ejbJar.getEnterpriseBeans();
        Session session = null;
        if (beans == null) {
            beans = ejbJar.newEnterpriseBeans();
            ejbJar.setEnterpriseBeans(beans);
        }
        session = beans.newSession();
        session.setEjbName(this.ejbName);
        session.setDisplayName(this.displayName);
        session.setEjbClass(this.packageNameWithDot + this.ejbClassName);
        if (this.hasRemote) {
            session.setRemote(this.packageNameWithDot + this.remoteName);
            session.setHome(this.packageNameWithDot + this.remoteHomeName);
        }
        if (this.hasLocal) {
            session.setLocal(this.packageNameWithDot + this.localName);
            session.setLocalHome(this.packageNameWithDot + this.localHomeName);
        }
        session.setSessionType(this.sessionType);
        session.setTransactionType("Container");
        beans.addSession(session);
        AssemblyDescriptor assemblyDescriptor = ejbJar.getSingleAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = ejbJar.newAssemblyDescriptor();
            ejbJar.setAssemblyDescriptor(assemblyDescriptor);
        }
        ContainerTransaction containerTransaction = assemblyDescriptor.newContainerTransaction();
        containerTransaction.setTransAttribute("Required");
        Method method = containerTransaction.newMethod();
        method.setEjbName(this.ejbName);
        method.setMethodName("*");
        containerTransaction.addMethod(method);
        assemblyDescriptor.addContainerTransaction(containerTransaction);
        ejbJar.write(ejbModule.getDeploymentDescriptor());
    }

    private void generateEJB30Xml() throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }
}

