/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.CallingConv;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.X86TargetInfo;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;

public class X86_64TargetInfo
extends X86TargetInfo
implements Destructors.ClassWithDestructor {
    public X86_64TargetInfo(Triple _Triple, TargetOptions Opts) {
        super(_Triple, Opts);
        boolean IsX32 = this.getTriple().getEnvironment() == Triple.EnvironmentType.GNUX32;
        boolean IsWinCOFF = this.getTriple().isOSWindows() && this.getTriple().isOSBinFormatCOFF();
        this.PointerWidth = this.PointerAlign = Unsigned.$int2uchar((int)(IsX32 ? 32 : 64));
        this.LongAlign = this.PointerAlign;
        this.LongWidth = this.PointerAlign;
        this.LongDoubleWidth = Unsigned.$int2uchar((int)128);
        this.LongDoubleAlign = Unsigned.$int2uchar((int)128);
        this.LargeArrayMinWidth = Unsigned.$int2uchar((int)128);
        this.LargeArrayAlign = Unsigned.$int2uchar((int)128);
        this.SuitableAlign = Unsigned.$int2uchar((int)128);
        this.SizeType = IsX32 ? TargetInfo.IntType.UnsignedInt : TargetInfo.IntType.UnsignedLong;
        this.PtrDiffType = IsX32 ? TargetInfo.IntType.SignedInt : TargetInfo.IntType.SignedLong;
        this.IntPtrType = IsX32 ? TargetInfo.IntType.SignedInt : TargetInfo.IntType.SignedLong;
        this.IntMaxType = IsX32 ? TargetInfo.IntType.SignedLongLong : TargetInfo.IntType.SignedLong;
        this.Int64Type = IsX32 ? TargetInfo.IntType.SignedLongLong : TargetInfo.IntType.SignedLong;
        this.RegParmMax = (byte)6;
        this.resetDataLayout(new StringRef(IsX32 ? NativePointer.$((String)"e-m:e-p:32:32-i64:64-f80:128-n8:16:32:64-S128") : (IsWinCOFF ? NativePointer.$((String)"e-m:w-i64:64-f80:128-n8:16:32:64-S128") : NativePointer.$((String)"e-m:e-i64:64-f80:128-n8:16:32:64-S128"))));
        this.RealTypeUsesObjCFPRet = (byte)(1 << TargetInfo.RealType.LongDouble.getValue());
        this.ComplexLongDoubleUsesFP2Ret = true;
        this.HasBuiltinMSVaList = true;
        this.MaxAtomicPromoteWidth = Unsigned.$int2uchar((int)128);
        this.MaxAtomicInlineWidth = Unsigned.$int2uchar((int)128);
    }

    @Override
    public TargetInfo.BuiltinVaListKind getBuiltinVaListKind() {
        return TargetInfo.BuiltinVaListKind.X86_64ABIBuiltinVaList;
    }

    @Override
    public int getEHDataRegisterNumber(int RegNo) {
        if (RegNo == 0) {
            return 0;
        }
        if (RegNo == 1) {
            return 1;
        }
        return -1;
    }

    @Override
    public TargetInfo.CallingConvCheckResult checkCallingConvention(CallingConv CC) {
        switch (CC) {
            case CC_C: 
            case CC_Swift: 
            case CC_X86VectorCall: 
            case CC_IntelOclBicc: 
            case CC_X86_64Win64: 
            case CC_PreserveMost: 
            case CC_PreserveAll: {
                return TargetInfo.CallingConvCheckResult.CCCR_OK;
            }
        }
        return TargetInfo.CallingConvCheckResult.CCCR_Warning;
    }

    @Override
    public CallingConv getDefaultCallingConv(TargetInfo.CallingConvMethodType MT) {
        return CallingConv.CC_C;
    }

    @Override
    public boolean hasInt128Type() {
        return true;
    }

    @Override
    public int getUnwindWordWidth() {
        return 64;
    }

    @Override
    public int getRegisterWidth() {
        return 64;
    }

    @Override
    public boolean validateGlobalRegisterVariable(StringRef RegName, int RegSize, bool.ref HasSizeMismatch) {
        if (RegName.equals("rsp") || RegName.equals("rbp")) {
            HasSizeMismatch.$set(RegSize != 64);
            return true;
        }
        return super.validateGlobalRegisterVariable(new StringRef(RegName), RegSize, HasSizeMismatch);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

