/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.VersionTuple;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.OSTargetInfo;
import org.clang.basic.target.impl.TargetInfo;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;

public class LinuxTargetInfo<Target extends TargetInfo>
extends OSTargetInfo<Target> {
    @Override
    protected void getOSDefines(LangOptions Opts, Triple Triple2, MacroBuilder Builder2) {
        TargetsStatics.DefineStd(Builder2, new StringRef("unix"), Opts);
        TargetsStatics.DefineStd(Builder2, new StringRef("linux"), Opts);
        Builder2.defineMacro(new Twine("__gnu_linux__"));
        Builder2.defineMacro(new Twine("__ELF__"));
        if (Triple2.isAndroid()) {
            Builder2.defineMacro(new Twine("__ANDROID__"), new Twine(NativePointer.$1));
            uint.ref Maj = NativePointer.create_uint$ref();
            uint.ref Min = NativePointer.create_uint$ref();
            uint.ref Rev = NativePointer.create_uint$ref();
            Triple2.getEnvironmentVersion(Maj, Min, Rev);
            this.tgt.PlatformName.$assign("android");
            this.tgt.PlatformMinVersion = new VersionTuple(Maj.$deref(), Min.$deref(), Rev.$deref());
        }
        if (Opts.POSIXThreads) {
            Builder2.defineMacro(new Twine("_REENTRANT"));
        }
        if (Opts.CPlusPlus) {
            Builder2.defineMacro(new Twine("_GNU_SOURCE"));
        }
        if (this.tgt.HasFloat128) {
            Builder2.defineMacro(new Twine("__FLOAT128__"));
        }
    }

    public LinuxTargetInfo(Target T, Triple Triple2, TargetOptions Opts) {
        super(T, Triple2, Opts);
        this.tgt.WIntType = TargetInfo.IntType.UnsignedInt;
        switch (Triple2.getArch()) {
            default: {
                break;
            }
            case ppc: 
            case ppc64: 
            case ppc64le: {
                this.tgt.MCountName = NativePointer.$((String)"_mcount");
                break;
            }
            case x86: 
            case x86_64: 
            case systemz: {
                this.tgt.HasFloat128 = true;
            }
        }
    }

    @Override
    public char.ptr getStaticInitSectionSpecifier() {
        return NativePointer.$((String)".text.startup");
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

