/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.clang.basic.SmallVectorSLocEntry;
import org.clank.support.ByteUtils;
import org.clank.support.NativeTrace;
import org.llvm.support.llvm;

final class SmallVectorSLocEntryByteBuffers
extends SmallVectorSLocEntry {
    private ByteBuffer int_arrayRaw_Offsets;
    private ByteBuffer int_arrayRaw_Union_IncludeLoc_or_SpellingLoc;
    private ByteBuffer int_arrayRaw_Union_NumCreatedFIDs_or_ExpansionLocStart;
    private ByteBuffer int_arrayRaw_Union_Data_or_ExpansionLocEnd;

    protected SmallVectorSLocEntryByteBuffers(int capacity) {
        super(capacity);
        int newSizeInBytes = capacity * 4;
        this.int_arrayRaw_Offsets = this.copyBytes(null, newSizeInBytes);
        this.int_arrayRaw_Union_IncludeLoc_or_SpellingLoc = this.copyBytes(null, newSizeInBytes);
        this.int_arrayRaw_Union_NumCreatedFIDs_or_ExpansionLocStart = this.copyBytes(null, newSizeInBytes);
        this.int_arrayRaw_Union_Data_or_ExpansionLocEnd = this.copyBytes(null, newSizeInBytes);
    }

    @Override
    protected int clearImpl(int keepCapacity) {
        this.releaseBuffers();
        int newSizeInBytes = keepCapacity * 4;
        this.int_arrayRaw_Offsets = ByteBuffer.allocateDirect(newSizeInBytes);
        this.int_arrayRaw_Union_IncludeLoc_or_SpellingLoc = ByteBuffer.allocateDirect(newSizeInBytes);
        this.int_arrayRaw_Union_NumCreatedFIDs_or_ExpansionLocStart = ByteBuffer.allocateDirect(newSizeInBytes);
        this.int_arrayRaw_Union_Data_or_ExpansionLocEnd = ByteBuffer.allocateDirect(newSizeInBytes);
        return keepCapacity;
    }

    private void releaseBuffers() {
        ByteUtils.releaseDirectByteBuffer((Buffer)this.int_arrayRaw_Offsets);
        this.int_arrayRaw_Offsets = null;
        ByteUtils.releaseDirectByteBuffer((Buffer)this.int_arrayRaw_Union_IncludeLoc_or_SpellingLoc);
        this.int_arrayRaw_Union_IncludeLoc_or_SpellingLoc = null;
        ByteUtils.releaseDirectByteBuffer((Buffer)this.int_arrayRaw_Union_NumCreatedFIDs_or_ExpansionLocStart);
        this.int_arrayRaw_Union_NumCreatedFIDs_or_ExpansionLocStart = null;
        ByteUtils.releaseDirectByteBuffer((Buffer)this.int_arrayRaw_Union_Data_or_ExpansionLocEnd);
        this.int_arrayRaw_Union_Data_or_ExpansionLocEnd = null;
    }

    @Override
    public void $destroy() {
        this.releaseBuffers();
    }

    @Override
    public int capacity_in_bytes() {
        return 4 * (this.capacity * 4 + 12);
    }

    @Override
    protected boolean isSlicedByOffsets() {
        return false;
    }

    @Override
    protected int $OffsetsMaxSliceIndex() {
        throw new UnsupportedOperationException("Not supported for this collection");
    }

    @Override
    protected int[] $OffsetsSliceByIndex(int slice) {
        throw new UnsupportedOperationException("Not supported for this collection");
    }

    @Override
    protected int $OffsetsSliceSize() {
        throw new UnsupportedOperationException("Not supported for this collection");
    }

    @Override
    protected int offset_$at(int[] Array, int origIdx) {
        return -1;
    }

    @Override
    protected int offset_$at(int[] Array, int origIdx, int slice, int idxInSlice) {
        return -1;
    }

    @Override
    protected SmallVectorSLocEntry grow(int newSize) {
        this.capacity = newSize;
        assert (this.capacity > 0);
        int newSizeInBytes = this.capacity * 4;
        this.int_arrayRaw_Offsets = this.copyBytes(this.int_arrayRaw_Offsets, newSizeInBytes);
        this.int_arrayRaw_Union_IncludeLoc_or_SpellingLoc = this.copyBytes(this.int_arrayRaw_Union_IncludeLoc_or_SpellingLoc, newSizeInBytes);
        this.int_arrayRaw_Union_NumCreatedFIDs_or_ExpansionLocStart = this.copyBytes(this.int_arrayRaw_Union_NumCreatedFIDs_or_ExpansionLocStart, newSizeInBytes);
        this.int_arrayRaw_Union_Data_or_ExpansionLocEnd = this.copyBytes(this.int_arrayRaw_Union_Data_or_ExpansionLocEnd, newSizeInBytes);
        return this;
    }

    private ByteBuffer copyBytes(ByteBuffer orig, int newSizeInBytes) {
        ByteBuffer NewBuffer;
        try {
            NewBuffer = ByteBuffer.allocateDirect(newSizeInBytes);
        }
        catch (OutOfMemoryError e) {
            llvm.errs().$out("Can not allocate new direct buffer for size " + NativeTrace.formatNumber((long)newSizeInBytes));
            NewBuffer = ByteBuffer.allocate(newSizeInBytes);
        }
        if (orig != null) {
            for (int i = 0; i < orig.capacity(); ++i) {
                NewBuffer.put(i, orig.get(i));
            }
            assert (NewBuffer.position() == 0);
            ByteUtils.releaseDirectByteBuffer((Buffer)orig);
        }
        return NewBuffer;
    }

    @Override
    protected int get_Raw_Offset(int origIdx) {
        origIdx = this.toIntIndex(origIdx);
        return this.int_arrayRaw_Offsets.getInt(origIdx);
    }

    @Override
    protected int get_Raw_Union_IncludeLoc_or_SpellingLoc(int origIdx) {
        origIdx = this.toIntIndex(origIdx);
        return this.int_arrayRaw_Union_IncludeLoc_or_SpellingLoc.getInt(origIdx);
    }

    @Override
    protected int get_Raw_Union_NumCreatedFIDs_or_ExpansionLocStart(int origIdx) {
        origIdx = this.toIntIndex(origIdx);
        return this.int_arrayRaw_Union_NumCreatedFIDs_or_ExpansionLocStart.getInt(origIdx);
    }

    @Override
    protected int get_Raw_Union_Data_or_ExpansionLocEnd(int origIdx) {
        origIdx = this.toIntIndex(origIdx);
        return this.int_arrayRaw_Union_Data_or_ExpansionLocEnd.getInt(origIdx);
    }

    @Override
    protected void set_Raw_Offset(int origIdx, int Value) {
        origIdx = this.toIntIndex(origIdx);
        this.int_arrayRaw_Offsets.putInt(origIdx, Value);
    }

    @Override
    protected void set_Raw_Union_IncludeLoc_or_SpellingLoc(int origIdx, int Value) {
        origIdx = this.toIntIndex(origIdx);
        this.int_arrayRaw_Union_IncludeLoc_or_SpellingLoc.putInt(origIdx, Value);
    }

    @Override
    protected void set_Raw_Union_NumCreatedFIDs_or_ExpansionLocStart(int origIdx, int Value) {
        origIdx = this.toIntIndex(origIdx);
        this.int_arrayRaw_Union_NumCreatedFIDs_or_ExpansionLocStart.putInt(origIdx, Value);
    }

    @Override
    protected void set_Raw_Union_Data_or_ExpansionLocEnd(int origIdx, int Value) {
        origIdx = this.toIntIndex(origIdx);
        this.int_arrayRaw_Union_Data_or_ExpansionLocEnd.putInt(origIdx, Value);
    }

    @Override
    protected void setImpl(int origIdx, int Raw_Offset, int Raw_Union_IncludeLoc_or_SpellingLoc, int Raw_Union_NumCreatedFIDs_or_ExpansionLocStart, int Raw_Union_Data_or_ExpansionLocEnd) {
        origIdx = this.toIntIndex(origIdx);
        this.int_arrayRaw_Offsets.putInt(origIdx, Raw_Offset);
        this.int_arrayRaw_Union_IncludeLoc_or_SpellingLoc.putInt(origIdx, Raw_Union_IncludeLoc_or_SpellingLoc);
        this.int_arrayRaw_Union_NumCreatedFIDs_or_ExpansionLocStart.putInt(origIdx, Raw_Union_NumCreatedFIDs_or_ExpansionLocStart);
        this.int_arrayRaw_Union_Data_or_ExpansionLocEnd.putInt(origIdx, Raw_Union_Data_or_ExpansionLocEnd);
    }

    private int toIntIndex(int origIdx) {
        return origIdx * 4;
    }
}

