/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.branch.BranchSelector;
import org.netbeans.modules.mercurial.ui.branch.HgBranch;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.Setup;
import org.netbeans.modules.mercurial.ui.log.DiffResultsView;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchCriteriaPanel;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SearchHistoryTopComponent
extends TopComponent
implements DiffSetupSource {
    private SearchHistoryPanel shp;
    private SearchCriteriaPanel scp;

    public SearchHistoryTopComponent() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSN_SearchHistoryT_Top_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSD_SearchHistoryT_Top_Component"));
    }

    public SearchHistoryTopComponent(File[] files, String branchName, String revision) {
        this();
        this.initComponents(files, revision, revision, branchName);
    }

    SearchHistoryTopComponent(File file, DiffResultsViewFactory fac) {
        this();
        this.initComponents(new File[]{file}, null, null, "");
        this.shp.setDiffResultsViewFactory(fac);
    }

    public void search(boolean showCriteria) {
        this.shp.executeSearch();
        this.shp.setSearchCriteria(showCriteria);
    }

    public void searchOut() {
        this.shp.setOutSearch();
        this.scp.setTo("");
        this.shp.setSearchCriteria(false);
        this.shp.executeSearch();
    }

    public void searchIncoming() {
        this.shp.setIncomingSearch();
        this.scp.setTo("");
        this.shp.setSearchCriteria(false);
        this.shp.executeSearch();
    }

    void activateDiffView(boolean selectFirstRevision) {
        this.shp.activateDiffView(selectFirstRevision);
    }

    private void initComponents(File[] roots, String from, String to, String branchName) {
        this.setLayout(new BorderLayout());
        this.scp = new SearchCriteriaPanel();
        if (from != null) {
            this.scp.setFrom(from);
        }
        if (to != null) {
            this.scp.setTo(to);
        }
        this.shp = new SearchHistoryPanel(roots, this.scp);
        this.add(this.shp);
        this.shp.setCurrentBranch(branchName);
        if (!HgBranch.DEFAULT_NAME.equals(branchName) && HgModuleConfig.getDefault().isSearchOnBranchEnabled(branchName)) {
            this.scp.setBranch(branchName);
        }
        if (roots.length > 0) {
            this.scp.btnSelectBranch.addActionListener(new BranchSelectorOpener(roots, this.scp));
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        this.shp.windowClosed();
        super.componentClosed();
    }

    protected String preferredID() {
        if (this.shp.isIncomingSearch()) {
            return "Hg.IncomingSearchHistoryTopComponent";
        }
        if (this.shp.isOutSearch()) {
            return "Hg.OutSearchHistoryTopComponent";
        }
        return "Hg.SearchHistoryTopComponent";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    @Override
    public Collection<Setup> getSetups() {
        return this.shp.getSetups();
    }

    @Override
    public String getSetupDisplayName() {
        return this.getDisplayName();
    }

    private static class BranchSelectorOpener
    implements ActionListener {
        private final SearchCriteriaPanel scp;
        private final File root;

        public BranchSelectorOpener(File[] roots, SearchCriteriaPanel scp) {
            this.scp = scp;
            this.root = roots[0];
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.scp.btnSelectBranch.setEnabled(false);
            Utils.postParallel((Runnable)new Runnable(){

                @Override
                public void run() {
                    BranchSelector selector;
                    File repoRoot = Mercurial.getInstance().getRepositoryRoot(BranchSelectorOpener.this.root);
                    final String branchName = repoRoot == null ? null : ((selector = new BranchSelector(repoRoot)).showGeneralDialog() ? selector.getBranchName() : null);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((BranchSelectorOpener)BranchSelectorOpener.this).scp.btnSelectBranch.setEnabled(true);
                            if (branchName != null) {
                                BranchSelectorOpener.this.scp.setBranch(branchName);
                            }
                        }
                    });
                }
            }, (int)0);
        }
    }

    public static class DiffResultsViewFactory {
        DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
            return new DiffResultsView(panel, results);
        }
    }
}

