/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2me.keystore.KeyStoreRepository;
import org.netbeans.modules.j2me.keystore.ui.EnterPasswordPanel;
import org.netbeans.modules.j2me.keystore.ui.ExportPanel;
import org.netbeans.modules.j2me.keystore.ui.KeyAliasCellRenderer;
import org.netbeans.modules.j2me.keystore.ui.KeystoreCellRenderer;
import org.netbeans.modules.j2me.keystore.ui.SecurityManagerPanel;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEProjectProperties;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class J2MESigningPanel
extends JPanel
implements HelpCtx.Provider {
    private final J2MEProjectProperties properties;
    private final ItemListener keystoreListener;
    private final ItemListener aliasListener;
    private JButton bAliasUnlock;
    private JButton bExport;
    private JButton bKeyStoreUnlock;
    private JButton bOpenSecurityManager;
    private JComboBox cAlias;
    private JCheckBox cEnabled;
    private JComboBox cKeystore;
    private JPanel jPanel1;
    private JLabel lAlias;
    private JLabel lDetails;
    private JLabel lKeystore;
    private JPanel pDetails;

    public J2MESigningPanel(J2MEProjectProperties properties) {
        this.initComponents();
        this.properties = properties;
        this.cEnabled.setModel(properties.SIGN_ENABLED_MODEL);
        this.cKeystore.setRenderer(new KeystoreCellRenderer());
        this.cAlias.setRenderer(new KeyAliasCellRenderer());
        this.cKeystore.setModel(properties.SIGN_KEYSTORE_MODEL);
        this.cAlias.setModel(properties.SIGN_ALIAS_MODEL);
        this.keystoreListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                J2MESigningPanel.this.loadKeystoreUnlock();
                J2MESigningPanel.this.loadAliases();
            }
        };
        this.aliasListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                J2MESigningPanel.this.loadAliasUnlock();
                J2MESigningPanel.this.loadDetails();
            }
        };
        this.cEnabled.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                J2MESigningPanel.this.toggleEnabledState();
                J2MESigningPanel.this.loadDetails();
            }
        });
        this.cKeystore.addItemListener(this.keystoreListener);
        this.cAlias.addItemListener(this.aliasListener);
        this.loadDetails();
        this.loadKeystoreUnlock();
        this.loadAliasUnlock();
        this.toggleEnabledState();
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2MESigningPanel.class, (String)"ACSN_Sign"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MESigningPanel.class, (String)"ACSD_Sign"));
    }

    private void initComponents() {
        this.bAliasUnlock = new JButton();
        this.jPanel1 = new JPanel();
        this.cEnabled = new JCheckBox();
        this.bOpenSecurityManager = new JButton();
        this.lAlias = new JLabel();
        this.cKeystore = new JComboBox();
        this.bKeyStoreUnlock = new JButton();
        this.cAlias = new JComboBox();
        this.pDetails = new JPanel();
        this.lDetails = new JLabel();
        this.bExport = new JButton();
        this.lKeystore = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.bAliasUnlock, (String)NbBundle.getMessage(J2MESigningPanel.class, (String)"J2MESigningPanel.bAliasUnlock.text"));
        this.bAliasUnlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MESigningPanel.this.bAliasUnlockActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.bAliasUnlock, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cEnabled, (String)NbBundle.getMessage(J2MESigningPanel.class, (String)"J2MESigningPanel.cEnabled.text"));
        this.cEnabled.setMargin(new Insets(0, 0, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 12, 0);
        this.jPanel1.add((Component)this.cEnabled, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bOpenSecurityManager, (String)NbBundle.getMessage(J2MESigningPanel.class, (String)"J2MESigningPanel.bOpenSecurityManager.text"));
        this.bOpenSecurityManager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MESigningPanel.this.bOpenSecurityManagerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 12, 0);
        this.jPanel1.add((Component)this.bOpenSecurityManager, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lAlias, (String)NbBundle.getMessage(J2MESigningPanel.class, (String)"J2MESigningPanel.lAlias.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.lAlias, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.add((Component)this.cKeystore, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bKeyStoreUnlock, (String)NbBundle.getMessage(J2MESigningPanel.class, (String)"J2MESigningPanel.bKeyStoreUnlock.text"));
        this.bKeyStoreUnlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MESigningPanel.this.bKeyStoreUnlockActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.bKeyStoreUnlock, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.cAlias, gridBagConstraints);
        this.pDetails.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(J2MESigningPanel.class, (String)"J2MESigningPanel.pDetails.border.title")));
        this.pDetails.setEnabled(false);
        this.pDetails.setLayout(new GridBagLayout());
        this.lDetails.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pDetails.add((Component)this.lDetails, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(J2MESigningPanel.class, (String)"J2MESigningPanel.bExport.text"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MESigningPanel.this.bExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.pDetails.add((Component)this.bExport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.pDetails, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lKeystore, (String)NbBundle.getMessage(J2MESigningPanel.class, (String)"J2MESigningPanel.lKeystore.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.add((Component)this.lKeystore, gridBagConstraints);
    }

    private void bAliasUnlockActionPerformed(ActionEvent evt) {
        KeyStoreRepository.KeyStoreBean.KeyAliasBean alias;
        KeyStoreRepository.KeyStoreBean bean = (KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem();
        if (EnterPasswordPanel.getAliasPassword((KeyStoreRepository.KeyStoreBean)bean, (KeyStoreRepository.KeyStoreBean.KeyAliasBean)(alias = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem())) != null) {
            this.loadAliasUnlock();
            this.loadDetails();
        }
    }

    private void bOpenSecurityManagerActionPerformed(ActionEvent evt) {
        SecurityManagerPanel.showSecurityManager((KeyStoreRepository.KeyStoreBean)((KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem()), (KeyStoreRepository.KeyStoreBean.KeyAliasBean)((KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem()));
        this.loadKeystores();
    }

    private void bKeyStoreUnlockActionPerformed(ActionEvent evt) {
        KeyStoreRepository.KeyStoreBean bean = (KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem();
        if (EnterPasswordPanel.getKeystorePassword((KeyStoreRepository.KeyStoreBean)bean) != null) {
            this.loadKeystoreUnlock();
            this.loadAliases();
        }
    }

    private void bExportActionPerformed(ActionEvent evt) {
        KeyStoreRepository.KeyStoreBean bean = (KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem();
        KeyStoreRepository.KeyStoreBean.KeyAliasBean alias = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem();
        ExportPanel.showExportKeyIntoPlatform((KeyStoreRepository.KeyStoreBean)bean, (KeyStoreRepository.KeyStoreBean.KeyAliasBean)alias, null, null);
    }

    private boolean isEditEnabled() {
        return this.cEnabled.isEnabled() && this.cEnabled.isSelected();
    }

    private void toggleEnabledState() {
        boolean editEnabled = this.isEditEnabled();
        this.cKeystore.setEnabled(editEnabled);
        this.lKeystore.setEnabled(editEnabled);
        this.lAlias.setEnabled(editEnabled);
        this.cAlias.setEnabled(editEnabled);
        KeyStoreRepository.KeyStoreBean.KeyAliasBean alias = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem();
        this.bExport.setEnabled(alias != null ? this.isEditEnabled() && alias.isValid() && alias.isOpened() : false);
    }

    private void loadKeystores() {
        this.toggleEnabledState();
        Object[] items = this.properties.loadKeystores().toArray();
        this.refreshComboboxContent(this.cKeystore, items);
        this.loadKeystoreUnlock();
        this.loadAliases();
    }

    private void loadAliases() {
        Object[] items = this.properties.loadAliases().toArray();
        this.refreshComboboxContent(this.cAlias, items);
        this.loadAliasUnlock();
        this.loadDetails();
    }

    private void loadKeystoreUnlock() {
        KeyStoreRepository.KeyStoreBean bean = (KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem();
        this.bKeyStoreUnlock.setEnabled(bean != null ? this.isEditEnabled() && bean.isValid() && !bean.isOpened() : false);
    }

    private void loadAliasUnlock() {
        KeyStoreRepository.KeyStoreBean.KeyAliasBean alias = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem();
        this.bAliasUnlock.setEnabled(alias != null ? this.isEditEnabled() && alias.isValid() && !alias.isOpened() : false);
        this.bExport.setEnabled(alias != null ? this.isEditEnabled() && alias.isValid() && alias.isOpened() : false);
    }

    private void loadDetails() {
        KeyStoreRepository.KeyStoreBean.KeyAliasBean alias = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem();
        this.lDetails.setText(alias != null ? KeyAliasCellRenderer.getHtmlFormattedText((KeyStoreRepository.KeyStoreBean.KeyAliasBean)alias) : "");
        Color color = UIManager.getDefaults().getColor(this.isEditEnabled() ? "Label.foreground" : "Label.disabledForeground");
        this.lDetails.setForeground(color);
        Border b = this.pDetails.getBorder();
        if (b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleColor(color);
        }
    }

    private void refreshComboboxContent(JComboBox comboBox, Object[] items) {
        this.cKeystore.removeItemListener(this.keystoreListener);
        this.cAlias.removeItemListener(this.aliasListener);
        Object currentSelected = comboBox.getSelectedItem();
        comboBox.removeAllItems();
        if (items == null) {
            return;
        }
        for (Object item : items) {
            comboBox.addItem(item);
            if (!item.equals(currentSelected)) continue;
            comboBox.setSelectedItem(item);
        }
        this.cKeystore.addItemListener(this.keystoreListener);
        this.cAlias.addItemListener(this.aliasListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.j2me.project.ui.customizer.J2MESigningPanel");
    }
}

