/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandlerFactory;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.remote.sync.RemoteBuildProjectActionHandler;
import org.netbeans.modules.cnd.remote.sync.RfsSyncFactory;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;

public class RemoteBuildProjectActionHandlerFactory
implements ProjectActionHandlerFactory {
    private static boolean canHandleType(ProjectActionEvent.Type type) {
        if (type instanceof ProjectActionEvent.PredefinedType) {
            ProjectActionEvent.PredefinedType predefinedType = (ProjectActionEvent.PredefinedType)type;
            switch (predefinedType) {
                case PRE_BUILD: 
                case BUILD: 
                case BUILD_TESTS: 
                case CLEAN: 
                case COMPILE_SINGLE: {
                    return true;
                }
                case RUN: 
                case DEBUG: 
                case DEBUG_STEPINTO: 
                case ATTACH: 
                case DEBUG_TEST: 
                case DEBUG_STEPINTO_TEST: 
                case CHECK_EXECUTABLE: 
                case CUSTOM_ACTION: 
                case TEST: {
                    return false;
                }
            }
            AssertionError e = new AssertionError((Object)("Unexpected action type " + predefinedType.name()));
            if (CndUtils.isDebugMode()) {
                throw e;
            }
            ((Throwable)((Object)e)).printStackTrace(System.err);
        }
        return false;
    }

    public boolean canHandle(ProjectActionEvent.Type type, Lookup context, Configuration configuration) {
        MakeConfiguration conf;
        if (RemoteBuildProjectActionHandlerFactory.canHandleType(type) && configuration instanceof MakeConfiguration && (conf = (MakeConfiguration)configuration).getDevelopmentHost().getExecutionEnvironment().isRemote()) {
            return RfsSyncFactory.ENABLE_RFS;
        }
        return false;
    }

    public ProjectActionHandler createHandler() {
        return new RemoteBuildProjectActionHandler();
    }

    static ProjectActionHandler createDelegateHandler(ProjectActionEvent pae) {
        boolean selfFound = false;
        for (ProjectActionHandlerFactory factory : Lookup.getDefault().lookupAll(ProjectActionHandlerFactory.class)) {
            if (factory instanceof RemoteBuildProjectActionHandlerFactory) {
                selfFound = true;
                continue;
            }
            if (!selfFound || !factory.canHandle(pae)) continue;
            return factory.createHandler();
        }
        return null;
    }

    public boolean canHandle(ProjectActionEvent pae) {
        return this.canHandle(pae.getType(), pae.getContext(), (Configuration)pae.getConfiguration());
    }
}

