/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.model.ImageElement;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.ReportElementReadHandler;
import org.libreoffice.report.pentaho.parser.xlink.XLinkReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImageReadHandler
extends ElementReadHandler {
    private final ImageElement contentElement = new ImageElement();
    private XLinkReadHandler xLinkReadHandler;

    protected void startParsing(Attributes attributes) throws SAXException {
        super.startParsing(attributes);
        String string = attributes.getValue("http://openoffice.org/2005/report", "formula");
        if (string != null && string.length() != 0) {
            FormulaExpression formulaExpression = new FormulaExpression();
            formulaExpression.setFormula(string);
            this.contentElement.setFormula(formulaExpression);
        }
        this.contentElement.setNamespace("urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        this.contentElement.setType("image");
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        if ("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(string) && "image-data".equals(string2)) {
            this.xLinkReadHandler = new XLinkReadHandler();
            return this.xLinkReadHandler;
        }
        if ("http://openoffice.org/2005/report".equals(string)) {
            if ("report-control".equals(string2)) {
                return new IgnoreAnyChildReadHandler();
            }
            if ("report-element".equals(string2)) {
                return new ReportElementReadHandler(this.contentElement);
            }
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        if (this.xLinkReadHandler != null) {
            this.contentElement.setAttribute("http://openoffice.org/2005/report", "alternate-content", this.xLinkReadHandler.getUri());
        }
    }

    public Element getElement() {
        return this.contentElement;
    }
}

