/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.ssa;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.PhiListAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.blocksmaker.BlockFinish;
import jadx.core.dex.visitors.ssa.LiveVarAnalysis;
import jadx.core.utils.InsnList;
import jadx.core.utils.InstructionRemover;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@JadxVisitor(name="SSATransform", desc="Calculate Single Side Assign (SSA) variables", runAfter={BlockFinish.class})
public class SSATransform
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        SSATransform.process(mth);
    }

    private static void process(MethodNode mth) {
        boolean repeatFix;
        LiveVarAnalysis la = new LiveVarAnalysis(mth);
        la.runAnalysis();
        int regsCount = mth.getRegsCount();
        for (int i = 0; i < regsCount; ++i) {
            SSATransform.placePhi(mth, i, la);
        }
        SSATransform.renameVariables(mth);
        SSATransform.fixLastAssignInTry(mth);
        SSATransform.removeBlockerInsns(mth);
        SSATransform.markThisArgs(mth.getThisArg());
        int k = 0;
        do {
            repeatFix = SSATransform.fixUselessPhi(mth);
            if (k++ <= 50) continue;
            throw new JadxRuntimeException("Phi nodes fix limit reached!");
        } while (repeatFix);
    }

    private static void placePhi(MethodNode mth, int regNum, LiveVarAnalysis la) {
        List<BlockNode> blocks = mth.getBasicBlocks();
        int blocksCount = blocks.size();
        BitSet hasPhi = new BitSet(blocksCount);
        BitSet processed = new BitSet(blocksCount);
        LinkedList<BlockNode> workList = new LinkedList<BlockNode>();
        BitSet assignBlocks = la.getAssignBlocks(regNum);
        int id = assignBlocks.nextSetBit(0);
        while (id >= 0) {
            processed.set(id);
            workList.add(blocks.get(id));
            id = assignBlocks.nextSetBit(id + 1);
        }
        while (!workList.isEmpty()) {
            BlockNode block = (BlockNode)workList.pop();
            BitSet domFrontier = block.getDomFrontier();
            int id2 = domFrontier.nextSetBit(0);
            while (id2 >= 0) {
                if (!hasPhi.get(id2) && la.isLive(id2, regNum)) {
                    BlockNode df = blocks.get(id2);
                    SSATransform.addPhi(mth, df, regNum);
                    hasPhi.set(id2);
                    if (!processed.get(id2)) {
                        processed.set(id2);
                        workList.add(df);
                    }
                }
                id2 = domFrontier.nextSetBit(id2 + 1);
            }
        }
    }

    public static PhiInsn addPhi(MethodNode mth, BlockNode block, int regNum) {
        PhiListAttr phiList = block.get(AType.PHI_LIST);
        if (phiList == null) {
            phiList = new PhiListAttr();
            block.addAttr(phiList);
        }
        int size = block.getPredecessors().size();
        if (mth.getEnterBlock() == block) {
            for (RegisterArg arg : mth.getArguments(true)) {
                if (arg.getRegNum() != regNum) continue;
                ++size;
                break;
            }
        }
        PhiInsn phiInsn = new PhiInsn(regNum, size);
        phiList.getList().add(phiInsn);
        phiInsn.setOffset(block.getStartOffset());
        block.getInstructions().add(0, phiInsn);
        return phiInsn;
    }

    private static void renameVariables(MethodNode mth) {
        if (!mth.getSVars().isEmpty()) {
            throw new JadxRuntimeException("SSA rename variables already executed");
        }
        int regsCount = mth.getRegsCount();
        SSAVar[] vars = new SSAVar[regsCount];
        int[] versions = new int[regsCount];
        for (RegisterArg arg : mth.getArguments(true)) {
            int regNum = arg.getRegNum();
            vars[regNum] = SSATransform.newSSAVar(mth, versions, arg, regNum);
        }
        BlockNode enterBlock = mth.getEnterBlock();
        SSATransform.initPhiInEnterBlock(vars, enterBlock);
        SSATransform.renameVar(mth, vars, versions, enterBlock);
    }

    private static SSAVar newSSAVar(MethodNode mth, int[] versions, RegisterArg arg, int regNum) {
        int n = regNum;
        int n2 = versions[n];
        versions[n] = n2 + 1;
        int version = n2;
        return mth.makeNewSVar(regNum, version, arg);
    }

    private static void initPhiInEnterBlock(SSAVar[] vars, BlockNode enterBlock) {
        PhiListAttr phiList = enterBlock.get(AType.PHI_LIST);
        if (phiList != null) {
            for (PhiInsn phiInsn : phiList.getList()) {
                SSATransform.bindPhiArg(vars, enterBlock, phiInsn);
            }
        }
    }

    private static void renameVar(MethodNode mth, SSAVar[] vars, int[] vers, BlockNode block) {
        SSAVar[] inputVars = Arrays.copyOf(vars, vars.length);
        for (InsnNode insn : block.getInstructions()) {
            RegisterArg result;
            if (insn.getType() != InsnType.PHI) {
                for (InsnArg arg : insn.getArguments()) {
                    if (!arg.isRegister()) continue;
                    RegisterArg reg = (RegisterArg)arg;
                    int regNum = reg.getRegNum();
                    SSAVar var = vars[regNum];
                    if (var == null) {
                        throw new JadxRuntimeException("Not initialized variable reg: " + regNum + ", insn: " + insn + ", block:" + block + ", method: " + mth);
                    }
                    var.use(reg);
                }
            }
            if ((result = insn.getResult()) == null) continue;
            int regNum = result.getRegNum();
            vars[regNum] = SSATransform.newSSAVar(mth, vers, result, regNum);
        }
        for (BlockNode s : block.getSuccessors()) {
            PhiListAttr phiList = s.get(AType.PHI_LIST);
            if (phiList == null) continue;
            for (PhiInsn phiInsn : phiList.getList()) {
                SSATransform.bindPhiArg(vars, block, phiInsn);
            }
        }
        for (BlockNode domOn : block.getDominatesOn()) {
            SSATransform.renameVar(mth, vars, vers, domOn);
        }
        System.arraycopy(inputVars, 0, vars, 0, vars.length);
    }

    private static void bindPhiArg(SSAVar[] vars, BlockNode block, PhiInsn phiInsn) {
        int regNum = phiInsn.getResult().getRegNum();
        SSAVar var = vars[regNum];
        if (var == null) {
            return;
        }
        RegisterArg arg = phiInsn.bindArg(block);
        var.use(arg);
        var.setUsedInPhi(phiInsn);
    }

    private static void fixLastAssignInTry(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiList = block.get(AType.PHI_LIST);
            if (phiList == null || !block.contains(AType.EXC_HANDLER)) continue;
            for (PhiInsn phi : phiList.getList()) {
                SSATransform.fixPhiInTryCatch(phi);
            }
        }
    }

    private static void fixPhiInTryCatch(PhiInsn phi) {
        int argsCount = phi.getArgsCount();
        int k = 0;
        while (k < argsCount) {
            RegisterArg arg = phi.getArg(k);
            InsnNode parentInsn = arg.getAssignInsn();
            if (parentInsn != null && parentInsn.getResult() != null && parentInsn.contains(AFlag.TRY_LEAVE) && phi.removeArg(arg)) {
                --argsCount;
                continue;
            }
            ++k;
        }
    }

    private static boolean removeBlockerInsns(MethodNode mth) {
        boolean removed = false;
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiList = block.get(AType.PHI_LIST);
            if (phiList == null) continue;
            for (PhiInsn phi : phiList.getList()) {
                for (int i = 0; i < phi.getArgsCount(); ++i) {
                    RegisterArg arg = phi.getArg(i);
                    InsnNode parentInsn = arg.getAssignInsn();
                    if (parentInsn == null || !parentInsn.contains(AFlag.REMOVE)) continue;
                    phi.removeArg(arg);
                    InstructionRemover.remove(mth, block, parentInsn);
                    removed = true;
                }
            }
        }
        return removed;
    }

    private static boolean fixUselessPhi(MethodNode mth) {
        boolean changed = false;
        ArrayList<PhiInsn> insnToRemove = new ArrayList<PhiInsn>();
        for (SSAVar var : mth.getSVars()) {
            InsnNode assignInsn;
            if (var.getUseCount() != 0 || (assignInsn = var.getAssign().getParentInsn()) == null || assignInsn.getType() != InsnType.PHI) continue;
            insnToRemove.add((PhiInsn)assignInsn);
            changed = true;
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiList = block.get(AType.PHI_LIST);
            if (phiList == null) continue;
            Iterator<PhiInsn> it = phiList.getList().iterator();
            while (it.hasNext()) {
                PhiInsn phi = it.next();
                if (!SSATransform.fixPhiWithSameArgs(mth, block, phi)) continue;
                it.remove();
                changed = true;
            }
        }
        SSATransform.removePhiList(mth, insnToRemove);
        return changed;
    }

    private static boolean fixPhiWithSameArgs(MethodNode mth, BlockNode block, PhiInsn phi) {
        boolean allSame;
        if (phi.getArgsCount() == 0) {
            for (RegisterArg useArg : phi.getResult().getSVar().getUseList()) {
                InsnNode useInsn = useArg.getParentInsn();
                if (useInsn == null || useInsn.getType() != InsnType.PHI) continue;
                phi.removeArg(useArg);
            }
            InstructionRemover.remove(mth, block, phi);
            return true;
        }
        boolean bl = allSame = phi.getArgsCount() == 1 || SSATransform.isSameArgs(phi);
        if (!allSame) {
            return false;
        }
        return SSATransform.replacePhiWithMove(mth, block, phi, phi.getArg(0));
    }

    private static boolean isSameArgs(PhiInsn phi) {
        boolean allSame = true;
        SSAVar var = null;
        for (int i = 0; i < phi.getArgsCount(); ++i) {
            RegisterArg arg = phi.getArg(i);
            if (var == null) {
                var = arg.getSVar();
                continue;
            }
            if (var == arg.getSVar()) continue;
            allSame = false;
            break;
        }
        return allSame;
    }

    private static boolean removePhiList(MethodNode mth, List<PhiInsn> insnToRemove) {
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiList = block.get(AType.PHI_LIST);
            if (phiList == null) continue;
            List<PhiInsn> list = phiList.getList();
            for (PhiInsn phiInsn : insnToRemove) {
                if (!list.remove(phiInsn)) continue;
                for (InsnArg arg : phiInsn.getArguments()) {
                    SSAVar sVar;
                    if (arg == null || (sVar = ((RegisterArg)arg).getSVar()) == null) continue;
                    sVar.setUsedInPhi(null);
                }
                InstructionRemover.remove(mth, block, phiInsn);
            }
            if (!list.isEmpty()) continue;
            block.remove(AType.PHI_LIST);
        }
        insnToRemove.clear();
        return true;
    }

    private static boolean replacePhiWithMove(MethodNode mth, BlockNode block, PhiInsn phi, RegisterArg arg) {
        List<InsnNode> insns = block.getInstructions();
        int phiIndex = InsnList.getIndex(insns, phi);
        if (phiIndex == -1) {
            return false;
        }
        SSAVar assign = phi.getResult().getSVar();
        SSAVar argVar = arg.getSVar();
        if (argVar != null) {
            argVar.removeUse(arg);
            argVar.setUsedInPhi(null);
        }
        if (SSATransform.inlinePhiInsn(mth, block, phi)) {
            insns.remove(phiIndex);
        } else {
            assign.setUsedInPhi(null);
            InsnNode m = new InsnNode(InsnType.MOVE, 1);
            m.add(AFlag.SYNTHETIC);
            m.setResult(phi.getResult());
            m.addArg(arg);
            arg.getSVar().use(arg);
            insns.set(phiIndex, m);
        }
        return true;
    }

    private static boolean inlinePhiInsn(MethodNode mth, BlockNode block, PhiInsn phi) {
        InsnNode assignInsn;
        SSAVar resVar = phi.getResult().getSVar();
        if (resVar == null) {
            return false;
        }
        RegisterArg arg = phi.getArg(0);
        if (arg.getSVar() == null) {
            return false;
        }
        List<RegisterArg> useList = resVar.getUseList();
        for (RegisterArg useArg : new ArrayList<RegisterArg>(useList)) {
            InsnNode useInsn = useArg.getParentInsn();
            if (useInsn == null || useInsn == phi) {
                return false;
            }
            useArg.getSVar().removeUse(useArg);
            RegisterArg inlArg = arg.duplicate();
            if (!useInsn.replaceArg(useArg, inlArg)) {
                return false;
            }
            inlArg.getSVar().use(inlArg);
            inlArg.setName(useArg.getName());
            inlArg.setType(useArg.getType());
        }
        if (block.contains(AType.EXC_HANDLER) && (assignInsn = arg.getAssignInsn()) != null) {
            assignInsn.add(AFlag.DONT_INLINE);
        }
        InstructionRemover.unbindInsn(mth, phi);
        return true;
    }

    private static void markThisArgs(RegisterArg thisArg) {
        if (thisArg != null) {
            SSATransform.markOneArgAsThis(thisArg);
            thisArg.getSVar().getUseList().forEach(SSATransform::markOneArgAsThis);
        }
    }

    private static void markOneArgAsThis(RegisterArg arg) {
        RegisterArg resArg;
        if (arg == null) {
            return;
        }
        arg.add(AFlag.THIS);
        arg.setName("this");
        InsnNode parentInsn = arg.getParentInsn();
        if (parentInsn != null && parentInsn.getType() == InsnType.MOVE && parentInsn.getArg(0) == arg && (resArg = parentInsn.getResult()).getRegNum() != arg.getRegNum() && !resArg.getSVar().isUsedInPhi()) {
            SSATransform.markThisArgs(resArg);
            parentInsn.add(AFlag.SKIP);
        }
    }
}

