/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrList;
import jadx.core.dex.attributes.AttributeStorage;
import jadx.core.dex.attributes.EmptyAttrStorage;
import jadx.core.dex.attributes.IAttribute;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.attributes.annotations.Annotation;
import java.util.List;

public abstract class AttrNode
implements IAttributeNode {
    private static final AttributeStorage EMPTY_ATTR_STORAGE = new EmptyAttrStorage();
    private AttributeStorage storage = EMPTY_ATTR_STORAGE;

    @Override
    public void add(AFlag flag) {
        this.initStorage().add(flag);
    }

    @Override
    public void addAttr(IAttribute attr) {
        this.initStorage().add(attr);
    }

    @Override
    public <T> void addAttr(AType<AttrList<T>> type, T obj) {
        this.initStorage().add(type, obj);
    }

    @Override
    public void copyAttributesFrom(AttrNode attrNode) {
        AttributeStorage copyFrom = attrNode.storage;
        if (!copyFrom.isEmpty()) {
            this.initStorage().addAll(copyFrom);
        }
    }

    private AttributeStorage initStorage() {
        AttributeStorage store = this.storage;
        if (store == EMPTY_ATTR_STORAGE) {
            this.storage = store = new AttributeStorage();
        }
        return store;
    }

    @Override
    public boolean contains(AFlag flag) {
        return this.storage.contains(flag);
    }

    @Override
    public <T extends IAttribute> boolean contains(AType<T> type) {
        return this.storage.contains(type);
    }

    @Override
    public <T extends IAttribute> T get(AType<T> type) {
        return this.storage.get(type);
    }

    @Override
    public Annotation getAnnotation(String cls) {
        return this.storage.getAnnotation(cls);
    }

    @Override
    public <T> List<T> getAll(AType<AttrList<T>> type) {
        return this.storage.getAll(type);
    }

    @Override
    public void remove(AFlag flag) {
        this.storage.remove(flag);
    }

    @Override
    public <T extends IAttribute> void remove(AType<T> type) {
        this.storage.remove(type);
    }

    @Override
    public void removeAttr(IAttribute attr) {
        this.storage.remove(attr);
    }

    @Override
    public void clearAttributes() {
        this.storage.clear();
    }

    @Override
    public List<String> getAttributesStringsList() {
        return this.storage.getAttributeStrings();
    }

    @Override
    public String getAttributesString() {
        return this.storage.toString();
    }

    public boolean isAttrStorageEmpty() {
        return this.storage.isEmpty();
    }
}

