/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util.exit;

import com.vladium.util.IJREVersion;
import com.vladium.util.Property;
import java.util.HashMap;
import java.util.Map;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public abstract class ExitHookManager
implements IJREVersion {
    private static ExitHookManager s_singleton;

    public abstract boolean addExitHook(Runnable var1);

    public abstract boolean removeExitHook(Runnable var1);

    public static synchronized ExitHookManager getSingleton() {
        if (s_singleton == null) {
            if (JRE_1_3_PLUS) {
                s_singleton = new JRE13ExitHookManager();
            } else if (JRE_SUN_SIGNAL_COMPATIBLE) {
                s_singleton = new SunJREExitHookManager();
            } else {
                throw new UnsupportedOperationException("no shutdown hook manager available [JVM: " + Property.getSystemFingerprint() + "]");
            }
        }
        return s_singleton;
    }

    protected ExitHookManager() {
    }

    private static final class INTSignalHandler
    implements SignalHandler {
        private Runnable m_runnable;
        private SignalHandler m_previous;

        public synchronized void handle(Signal signal) {
            if (this.m_runnable != null) {
                try {
                    this.m_runnable.run();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            this.m_runnable = null;
            if (this.m_previous != null && this.m_previous != SIG_DFL && this.m_previous != SIG_IGN) {
                try {
                    this.m_previous.handle(signal);
                }
                catch (Throwable throwable) {}
            } else {
                System.exit(0);
            }
        }

        INTSignalHandler(Runnable runnable) {
            this.m_runnable = runnable;
        }

        synchronized void register() {
            this.m_previous = Signal.handle(new Signal("INT"), this);
        }

        synchronized void unregister() {
            this.m_runnable = null;
        }
    }

    private static final class SunJREExitHookManager
    extends ExitHookManager {
        private final Map m_signalHandlerMap = new HashMap();

        public synchronized boolean addExitHook(Runnable runnable) {
            if (runnable != null && !this.m_signalHandlerMap.containsKey(runnable)) {
                INTSignalHandler handler = new INTSignalHandler(runnable);
                try {
                    handler.register();
                    this.m_signalHandlerMap.put(runnable, handler);
                    return true;
                }
                catch (Throwable t) {
                    System.out.println("exception caught while adding a shutdown hook:");
                    t.printStackTrace(System.out);
                }
            }
            return false;
        }

        public synchronized boolean removeExitHook(Runnable runnable) {
            INTSignalHandler handler;
            if (runnable != null && (handler = (INTSignalHandler)this.m_signalHandlerMap.get(runnable)) != null) {
                try {
                    handler.unregister();
                    this.m_signalHandlerMap.remove(runnable);
                    return true;
                }
                catch (Exception e) {
                    System.out.println("exception caught while removing a shutdown hook:");
                    e.printStackTrace(System.out);
                }
            }
            return false;
        }

        SunJREExitHookManager() {
        }
    }

    private static final class JRE13ExitHookManager
    extends ExitHookManager {
        private final Map m_exitThreadMap = new HashMap();

        public synchronized boolean addExitHook(Runnable runnable) {
            if (runnable != null && !this.m_exitThreadMap.containsKey(runnable)) {
                Thread exitThread = new Thread(runnable, "EMMA shutdown handler thread");
                try {
                    Runtime.getRuntime().addShutdownHook(exitThread);
                    this.m_exitThreadMap.put(runnable, exitThread);
                    return true;
                }
                catch (Exception e) {
                    System.out.println("exception caught while adding a shutdown hook:");
                    e.printStackTrace(System.out);
                }
            }
            return false;
        }

        public synchronized boolean removeExitHook(Runnable runnable) {
            Thread exitThread;
            if (runnable != null && (exitThread = (Thread)this.m_exitThreadMap.get(runnable)) != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(exitThread);
                    this.m_exitThreadMap.remove(runnable);
                    return true;
                }
                catch (Exception e) {
                    System.out.println("exception caught while removing a shutdown hook:");
                    e.printStackTrace(System.out);
                }
            }
            return false;
        }

        JRE13ExitHookManager() {
        }
    }
}

