/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.xml;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemAttribute;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.ItemComparator;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IProperties;
import com.vladium.util.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;

public final class ReportGenerator
extends AbstractReportGenerator
implements IAppErrorCodes {
    private IndentingWriter m_out;
    private static final String TYPE = "xml";
    private static final int IO_BUF_SIZE = 65536;

    public String getType() {
        return TYPE;
    }

    public void process(IMetaData mdata, ICoverageData cdata, SourcePathCache cache, IProperties properties) throws EMMARuntimeException {
        this.initialize(mdata, cdata, cache, properties);
        long start = 0L;
        boolean trace1 = this.m_log.atTRACE1();
        if (trace1) {
            start = System.currentTimeMillis();
        }
        this.m_view.getRoot().accept(this, null);
        this.close();
        if (trace1) {
            long end = System.currentTimeMillis();
            this.m_log.trace1("process", "[" + this.getType() + "] report generated in " + (end - start) + " ms");
        }
    }

    public void cleanup() {
        this.close();
        super.cleanup();
    }

    public Object visit(AllItem item, Object ctx) {
        try {
            File outFile = this.m_settings.getOutFile();
            if (outFile == null) {
                outFile = new File("coverage.xml");
                this.m_settings.setOutFile(outFile);
            }
            File fullOutFile = Files.newFile(this.m_settings.getOutDir(), outFile);
            this.m_log.info("writing [" + this.getType() + "] report to [" + fullOutFile.getAbsolutePath() + "] ...");
            this.openOutFile(fullOutFile, this.m_settings.getOutEncoding(), true);
            this.m_out.write("<?xml version=\"1.0\" encoding=\"" + this.m_settings.getOutEncoding() + "\"?>");
            try {
                StringBuffer label = new StringBuffer(101);
                label.append("<!-- ");
                label.append("EMMA");
                label.append(" v");
                label.append("0.0.0 (unsupported private build)");
                label.append(" report, generated ");
                label.append(new Date(EMMAProperties.getTimeStamp()));
                label.append(" -->");
                this.m_out.write(label.toString());
                this.m_out.newLine();
                this.m_out.flush();
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
            }
            this.eol();
            this.openElementTag("report");
            this.closeElementTag(false);
            this.m_out.incIndent();
            this.eol();
            this.openElementTag("stats");
            this.closeElementTag(false);
            this.m_out.incIndent();
            this.emitStatsCount("packages", item.getChildCount());
            this.emitStatsCount("classes", item.getAggregate(11));
            this.emitStatsCount("methods", item.getAggregate(10));
            if (this.m_srcView && this.m_hasSrcFileInfo) {
                this.emitStatsCount("srcfiles", item.getAggregate(12));
                if (this.m_hasLineNumberInfo) {
                    this.emitStatsCount("srclines", item.getAggregate(7));
                }
            }
            this.m_out.decIndent();
            this.eol();
            this.endElement("stats");
            this.eol();
            this.openElementTag("data");
            this.closeElementTag(false);
            this.m_out.incIndent();
            ItemComparator childrenOrder = this.m_typeSortComparators[PackageItem.getTypeMetadata().getTypeID()];
            this.emitItem(item, childrenOrder);
            this.m_out.decIndent();
            this.eol();
            this.endElement("data");
            this.m_out.decIndent();
            this.eol();
            this.endElement("report");
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
        return ctx;
    }

    public Object visit(PackageItem item, Object ctx) {
        if (this.m_verbose) {
            this.m_log.verbose("  report: processing package [" + item.getName() + "] ...");
        }
        try {
            ItemComparator childrenOrder = this.m_typeSortComparators[this.m_srcView ? SrcFileItem.getTypeMetadata().getTypeID() : ClassItem.getTypeMetadata().getTypeID()];
            this.emitItem(item, childrenOrder);
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
        return ctx;
    }

    public Object visit(SrcFileItem item, Object ctx) {
        try {
            ItemComparator childrenOrder = this.m_typeSortComparators[ClassItem.getTypeMetadata().getTypeID()];
            this.emitItem(item, childrenOrder);
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
        return ctx;
    }

    public Object visit(ClassItem item, Object ctx) {
        try {
            ItemComparator childrenOrder = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
            this.emitItem(item, childrenOrder);
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
        return ctx;
    }

    public Object visit(MethodItem item, Object ctx) {
        try {
            this.emitItem(item, null);
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
        return ctx;
    }

    private void emitStatsCount(String name, int value) throws IOException {
        this.eol();
        this.openElementTag(name);
        this.m_out.write(" value=\"" + value);
        this.m_out.write(34);
        this.closeElementTag(true);
    }

    private void emitItem(IItem item, ItemComparator childrenOrder) throws IOException {
        boolean deeper;
        IItemMetadata metadata = item.getMetadata();
        int[] columns = this.m_settings.getColumnOrder();
        String tag = metadata.getTypeName();
        this.eol();
        this.openElementTag(tag);
        this.m_out.write(" name=\"");
        this.m_out.write(Strings.HTMLEscape(item.getName()));
        this.m_out.write(34);
        this.closeElementTag(false);
        this.eol();
        this.m_out.incIndent();
        this.emitItemCoverage(item, columns);
        boolean bl = deeper = childrenOrder != null && this.m_settings.getDepth() > metadata.getTypeID() && item.getChildCount() > 0;
        if (deeper) {
            Iterator packages = item.getChildren(childrenOrder);
            while (packages.hasNext()) {
                ((IItem)packages.next()).accept(this, null);
            }
            this.eol();
        }
        this.m_out.decIndent();
        this.endElement(tag);
    }

    private void emitItemCoverage(IItem item, int[] columns) throws IOException {
        StringBuffer buf = new StringBuffer(64);
        int cLimit = columns.length;
        for (int c = 0; c < cLimit; ++c) {
            IItemAttribute attr;
            int attrID = columns[c];
            if (attrID == 0 || (attr = item.getAttribute(attrID, this.m_settings.getUnitsType())) == null) continue;
            this.openElementTag("coverage");
            this.m_out.write(" type=\"");
            this.m_out.write(Strings.HTMLEscape(attr.getName()));
            this.m_out.write("\" value=\"");
            attr.format(item, buf);
            this.m_out.write(Strings.HTMLEscape(buf.toString()));
            this.m_out.write(34);
            buf.setLength(0);
            this.closeElementTag(true);
            this.eol();
        }
    }

    private void openElementTag(String tag) throws IOException {
        this.m_out.write(60);
        this.m_out.write(tag);
    }

    private void closeElementTag(boolean simple) throws IOException {
        if (simple) {
            this.m_out.write("/>");
        } else {
            this.m_out.write(62);
        }
    }

    private void endElement(String tag) throws IOException {
        this.m_out.write("</");
        this.m_out.write(tag);
        this.m_out.write(62);
    }

    private void eol() throws IOException {
        this.m_out.newLine();
    }

    private void close() {
        if (this.m_out != null) {
            try {
                this.m_out.flush();
                this.m_out.close();
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
            }
            finally {
                this.m_out = null;
            }
        }
    }

    private void openOutFile(File file, String encoding, boolean mkdirs) {
        try {
            File parent;
            if (mkdirs && (parent = file.getParentFile()) != null) {
                parent.mkdirs();
            }
            this.m_out = new IndentingWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding), 65536, 0);
        }
        catch (UnsupportedEncodingException uee) {
            throw new EMMARuntimeException(uee);
        }
        catch (IOException fnfe) {
            throw new EMMARuntimeException(fnfe);
        }
    }

    private static final class IndentingWriter
    extends BufferedWriter {
        private int m_indent;
        private int m_state;
        private transient String m_sindent;
        private static final int INDENT_INCREMENT = 2;

        public void newLine() throws IOException {
            this.m_state = 0;
            super.write(IConstants.EOL, 0, IConstants.EOL.length());
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.indent();
            super.write(cbuf, off, len);
        }

        public void write(int c) throws IOException {
            this.indent();
            super.write(c);
        }

        public void write(String s, int off, int len) throws IOException {
            this.indent();
            super.write(s, off, len);
        }

        IndentingWriter(Writer out, int buffer, int indent) {
            super(out, buffer);
            this.m_indent = indent;
        }

        void incIndent(int delta) {
            if (delta < 0) {
                throw new IllegalArgumentException("delta be non-negative: " + delta);
            }
            this.m_indent += delta;
        }

        void incIndent() {
            this.incIndent(2);
        }

        void decIndent(int delta) {
            if (delta < 0) {
                throw new IllegalArgumentException("delta be non-negative: " + delta);
            }
            if (delta > this.m_indent) {
                throw new IllegalArgumentException("delta = " + delta + ", current indent = " + this.m_indent);
            }
            this.m_indent -= delta;
        }

        void decIndent() {
            this.decIndent(2);
        }

        String getIndent() {
            if (this.m_indent <= 0) {
                return "";
            }
            if (this.m_sindent == null || this.m_sindent.length() < this.m_indent) {
                char[] ca = new char[this.m_indent];
                for (int i = 0; i < this.m_indent; ++i) {
                    ca[i] = 32;
                }
                this.m_sindent = new String(ca);
                return this.m_sindent;
            }
            return this.m_sindent.substring(0, this.m_indent);
        }

        private void indent() throws IOException {
            if (this.m_state == 0) {
                String indent = this.getIndent();
                super.write(indent, 0, indent.length());
                this.m_state = 1;
            }
        }
    }
}

