/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EclipseImportMap {
    private final Properties myProperties = new Properties();
    private static final String MAP_PROPERTIES = "EclipseImportMap.properties";
    private static final Logger LOG = Logger.getInstance(EclipseImportMap.class);

    public void load() {
        try (InputStream sourceStream = this.getClass().getResourceAsStream(MAP_PROPERTIES);){
            this.myProperties.load(sourceStream);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public ImportDescriptor getImportDescriptor(String name) {
        String rawData = this.myProperties.getProperty(name);
        if (rawData != null && !rawData.trim().isEmpty()) {
            if (rawData.contains(":")) {
                String[] parameters = rawData.split(":");
                if (parameters.length == 2) {
                    return new ImportDescriptor(parameters[0].trim(), parameters[1].trim());
                }
                if (parameters.length == 3) {
                    boolean indentOptions = "indentOptions".equalsIgnoreCase(parameters[1].trim());
                    return new ImportDescriptor(parameters[0].trim(), parameters[2], indentOptions);
                }
            } else {
                return new ImportDescriptor(rawData.trim());
            }
        }
        return null;
    }

    public static class ImportDescriptor {
        private final String myLanguage;
        private final String myFieldName;
        private final boolean myIndentOptions;
        private final boolean myIsCustomField;

        public ImportDescriptor(String language, String fieldName, boolean indentOptions) {
            this.myLanguage = language;
            this.myFieldName = fieldName;
            this.myIsCustomField = ImportDescriptor.isCustomField(fieldName);
            this.myIndentOptions = indentOptions;
        }

        public ImportDescriptor(String language, String fieldName) {
            this(language, fieldName, false);
        }

        public ImportDescriptor(String fieldName) {
            this(null, fieldName);
        }

        public String getLanguage() {
            return this.myLanguage;
        }

        public String getFieldName() {
            return this.myFieldName;
        }

        public boolean isIndentOptions() {
            return this.myIndentOptions;
        }

        public boolean isLanguageSpecific() {
            return this.myLanguage != null;
        }

        public boolean isCustomField() {
            return this.myIsCustomField;
        }

        private static boolean isCustomField(@NotNull String fieldName) {
            if (fieldName == null) {
                ImportDescriptor.$$$reportNull$$$0(0);
            }
            if ("<Programmatic>".equals(fieldName)) {
                return false;
            }
            for (Field field : CommonCodeStyleSettings.class.getFields()) {
                if (!fieldName.equals(field.getName())) continue;
                return false;
            }
            for (Field field : CommonCodeStyleSettings.IndentOptions.class.getFields()) {
                if (!fieldName.equals(field.getName())) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/idea/eclipse/importer/EclipseImportMap$ImportDescriptor", "isCustomField"));
        }
    }
}

