/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importWizard;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importWizard.EclipseCodeStyleImportStep;
import org.jetbrains.idea.eclipse.importWizard.EclipseImportBuilder;
import org.jetbrains.idea.eclipse.importWizard.EclipseProjectOpenProcessor;
import org.jetbrains.idea.eclipse.importWizard.EclipseWorkspaceRootStep;
import org.jetbrains.idea.eclipse.importWizard.SelectEclipseImportedProjectsStep;

public class EclipseProjectImportProvider
extends ProjectImportProvider {
    private final EclipseProjectOpenProcessor myProcessor;

    public EclipseProjectImportProvider(EclipseImportBuilder builder) {
        super((ProjectImportBuilder)builder);
        this.myProcessor = new EclipseProjectOpenProcessor(builder);
    }

    public ModuleWizardStep[] createSteps(WizardContext context) {
        ProjectWizardStepFactory stepFactory = ProjectWizardStepFactory.getInstance();
        return new ModuleWizardStep[]{new EclipseWorkspaceRootStep(context), new SelectEclipseImportedProjectsStep(context), new EclipseCodeStyleImportStep(context), stepFactory.createProjectJdkStep(context)};
    }

    protected boolean canImportFromFile(VirtualFile file) {
        return this.myProcessor.canOpenProject(file);
    }

    @Nullable
    public String getFileSample() {
        return "<b>Eclipse</b> project (.project) or classpath (.classpath) file";
    }
}

