/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.export;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseBundle;

public class ExportEclipseProjectsDialog
extends DialogWrapper {
    private JPanel contentPane;
    private ElementsChooser<Module> moduleChooser;
    private JCheckBox linkCheckBox;
    private TextFieldWithBrowseButton myUserLibrariesTF;
    private JCheckBox myExportProjectLibrariesCb;
    private JLabel myPathToUserLibsLabel;

    public ExportEclipseProjectsDialog(Project project, List<Module> modules) {
        super(project, false);
        this.$$$setupUI$$$();
        this.moduleChooser.setElements(modules, true);
        this.setTitle(EclipseBundle.message("eclipse.export.dialog.title", new Object[0]));
        this.init();
        this.myUserLibrariesTF.setText(project.getBasePath() + File.separator + project.getName() + ".userlibraries");
        this.myUserLibrariesTF.addBrowseFolderListener("Locate .userlibraries", "Locate .userlibraries file where project libraries would be exported", project, FileChooserDescriptorFactory.createSingleLocalFileDescriptor());
        this.myExportProjectLibrariesCb.setSelected(true);
        this.myExportProjectLibrariesCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportEclipseProjectsDialog.this.myUserLibrariesTF.setEnabled(ExportEclipseProjectsDialog.this.myExportProjectLibrariesCb.isSelected());
                ExportEclipseProjectsDialog.this.myPathToUserLibsLabel.setEnabled(ExportEclipseProjectsDialog.this.myExportProjectLibrariesCb.isSelected());
            }
        });
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    private void createUIComponents() {
        this.moduleChooser = new ElementsChooser<Module>(true){

            protected String getItemText(@NotNull Module module) {
                if (module == null) {
                    2.$$$reportNull$$$0(0);
                }
                return module.getName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/eclipse/export/ExportEclipseProjectsDialog$2", "getItemText"));
            }
        };
    }

    public boolean isLink() {
        return this.linkCheckBox.isSelected();
    }

    public List<Module> getSelectedModules() {
        return this.moduleChooser.getMarkedElements();
    }

    @Nullable
    public File getUserLibrariesFile() {
        return this.myExportProjectLibrariesCb.isSelected() ? new File(this.myUserLibrariesTF.getText()) : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Modules to export", (int)0, (int)0, (Font)this.$$$getFont$$$(null, -1, -1, jPanel2.getFont()), null));
        ElementsChooser<Module> elementsChooser = this.moduleChooser;
        jPanel2.add((Component)elementsChooser, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.linkCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Switch selected modules to Eclipse-compatible format");
        jCheckBox2.setMnemonic('E');
        jCheckBox2.setDisplayedMnemonicIndex(27);
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myPathToUserLibsLabel = jLabel = new JLabel();
        jLabel.setText("Path to resulting .userlibraries");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myUserLibrariesTF = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myExportProjectLibrariesCb = jCheckBox = new JCheckBox();
        jCheckBox.setText("Export non-module libraries");
        jCheckBox.setMnemonic('X');
        jCheckBox.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

