/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelState;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.config.EclipseModuleManagerImpl;
import org.jetbrains.idea.eclipse.conversion.AbstractIdeaSpecificSettings;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;

public class IdeaSpecificSettings
extends AbstractIdeaSpecificSettings<ModifiableRootModel, ContentEntry, Sdk> {
    @NonNls
    private static final String RELATIVE_MODULE_SRC = "relative-module-src";
    @NonNls
    private static final String RELATIVE_MODULE_CLS = "relative-module-cls";
    @NonNls
    private static final String RELATIVE_MODULE_JAVADOC = "relative-module-javadoc";
    @NonNls
    private static final String PROJECT_RELATED = "project-related";
    @NonNls
    private static final String SRCROOT_ATTR = "srcroot";
    @NonNls
    private static final String SRCROOT_BIND_ATTR = "bind";
    private static final Logger LOG = Logger.getInstance(IdeaSpecificSettings.class);
    @NonNls
    private static final String JAVADOCROOT_ATTR = "javadocroot_attr";
    public static final String INHERIT_JDK = "inheritJdk";

    protected ContentEntry[] getEntries(ModifiableRootModel model) {
        return model.getContentEntries();
    }

    protected ContentEntry createContentEntry(ModifiableRootModel model, String url) {
        return model.addContentEntry(url);
    }

    protected void setupLibraryRoots(Element root, ModifiableRootModel model) {
        for (Element libElement : root.getChildren("lib")) {
            String libName = libElement.getAttributeValue("name");
            Library libraryByName = model.getModuleLibraryTable().getLibraryByName(libName);
            if (libraryByName != null) {
                IdeaSpecificSettings.appendLibraryScope(model, libElement, libraryByName);
                Library.ModifiableModel modifiableModel = libraryByName.getModifiableModel();
                IdeaSpecificSettings.replaceCollapsedByEclipseSourceRoots(libElement, modifiableModel);
                for (Element r : libElement.getChildren(JAVADOCROOT_ATTR)) {
                    modifiableModel.addRoot(r.getAttributeValue("url"), JavadocOrderRootType.getInstance());
                }
                IdeaSpecificSettings.replaceModuleRelatedRoots(model.getProject(), modifiableModel, libElement, OrderRootType.SOURCES, RELATIVE_MODULE_SRC);
                IdeaSpecificSettings.replaceModuleRelatedRoots(model.getProject(), modifiableModel, libElement, OrderRootType.CLASSES, RELATIVE_MODULE_CLS);
                IdeaSpecificSettings.replaceModuleRelatedRoots(model.getProject(), modifiableModel, libElement, JavadocOrderRootType.getInstance(), RELATIVE_MODULE_JAVADOC);
                modifiableModel.commit();
                continue;
            }
            Library library = EclipseClasspathReader.findLibraryByName(model.getProject(), libName);
            if (library == null) continue;
            IdeaSpecificSettings.appendLibraryScope(model, libElement, library);
        }
    }

    protected void setupJdk(Element root, ModifiableRootModel model, @Nullable Sdk sdk) {
        String inheritJdk = root.getAttributeValue(INHERIT_JDK);
        if (inheritJdk != null && Boolean.parseBoolean(inheritJdk)) {
            model.inheritSdk();
        } else {
            Sdk jdkByName;
            String jdkName = root.getAttributeValue("jdk");
            if (jdkName != null && (jdkByName = ProjectJdkTable.getInstance().findJdk(jdkName)) != null) {
                model.setSdk(jdkByName);
            }
        }
    }

    protected void setupCompilerOutputs(Element root, ModifiableRootModel model) {
        String inheritedOutput;
        CompilerModuleExtension compilerModuleExtension = (CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class);
        Element testOutputElement = root.getChild("output-test");
        if (testOutputElement != null) {
            compilerModuleExtension.setCompilerOutputPathForTests(testOutputElement.getAttributeValue("url"));
        }
        if ((inheritedOutput = root.getAttributeValue("inherit-compiler-output")) != null && Boolean.valueOf(inheritedOutput).booleanValue()) {
            compilerModuleExtension.inheritCompilerOutputPath(true);
        }
        compilerModuleExtension.setExcludeOutput(root.getChild("exclude-output") != null);
    }

    protected void readLanguageLevel(Element root, ModifiableRootModel model) {
        LanguageLevelModuleExtensionImpl component = (LanguageLevelModuleExtensionImpl)model.getModuleExtension(LanguageLevelModuleExtensionImpl.class);
        component.loadState((LanguageLevelState)XmlSerializer.deserialize((Element)root, (Class)ComponentSerializationUtil.getStateClass(component.getClass())));
    }

    protected void expandElement(Element root, ModifiableRootModel model) {
        PathMacroManager.getInstance((ComponentManager)model.getModule()).expandPaths(root);
    }

    protected void overrideModulesScopes(Element root, ModifiableRootModel model) {
        block0: for (Element o : root.getChildren("module")) {
            String moduleName = o.getAttributeValue("name");
            String scope = o.getAttributeValue("scope");
            if (scope == null) continue;
            for (OrderEntry entry : model.getOrderEntries()) {
                if (!(entry instanceof ModuleOrderEntry) || !Comparing.strEqual((String)((ModuleOrderEntry)entry).getModuleName(), (String)moduleName)) continue;
                ((ModuleOrderEntry)entry).setScope(DependencyScope.valueOf((String)scope));
                continue block0;
            }
        }
    }

    private static void appendLibraryScope(ModifiableRootModel model, Element libElement, Library libraryByName) {
        LibraryOrderEntry libraryOrderEntry = model.findLibraryOrderEntry(libraryByName);
        if (libraryOrderEntry != null) {
            String scopeAttribute = libElement.getAttributeValue("scope");
            libraryOrderEntry.setScope(scopeAttribute == null ? DependencyScope.COMPILE : DependencyScope.valueOf((String)scopeAttribute));
        }
    }

    private static void replaceCollapsedByEclipseSourceRoots(Element libElement, Library.ModifiableModel modifiableModel) {
        String[] srcUrlsFromClasspath = modifiableModel.getUrls(OrderRootType.SOURCES);
        LOG.assertTrue(srcUrlsFromClasspath.length <= 1);
        String eclipseUrl = srcUrlsFromClasspath.length > 0 ? srcUrlsFromClasspath[0] : null;
        for (Element r : libElement.getChildren(SRCROOT_ATTR)) {
            boolean notBind;
            String url = r.getAttributeValue("url");
            String bindAttr = r.getAttributeValue(SRCROOT_BIND_ATTR);
            boolean bl = notBind = bindAttr != null && !Boolean.parseBoolean(bindAttr);
            if (notBind) {
                modifiableModel.addRoot(url, OrderRootType.SOURCES);
                continue;
            }
            if (eclipseUrl == null || !EPathUtil.areUrlsPointTheSame(url, eclipseUrl) || Comparing.strEqual((String)url, (String)eclipseUrl)) continue;
            modifiableModel.addRoot(url, OrderRootType.SOURCES);
            if (srcUrlsFromClasspath == null || srcUrlsFromClasspath.length != 1) continue;
            modifiableModel.removeRoot(eclipseUrl, OrderRootType.SOURCES);
            srcUrlsFromClasspath = null;
        }
    }

    public void readContentEntry(Element root, ContentEntry entry, ModifiableRootModel model) {
        SourceFolder[] folders = entry.getSourceFolders();
        String[] sourceFoldersUrls = new String[folders.length];
        for (int i = 0; i < folders.length; ++i) {
            SourceFolder folder = folders[i];
            sourceFoldersUrls[i] = folder.getUrl();
            entry.removeSourceFolder(folder);
        }
        boolean[] testFolders = new boolean[sourceFoldersUrls.length];
        block1: for (Element o : root.getChildren("testFolder")) {
            String url = o.getAttributeValue("url");
            for (int i = 0; i < sourceFoldersUrls.length; ++i) {
                if (!Comparing.strEqual((String)sourceFoldersUrls[i], (String)url)) continue;
                testFolders[i] = true;
                continue block1;
            }
        }
        for (int i = 0; i < sourceFoldersUrls.length; ++i) {
            entry.addSourceFolder(sourceFoldersUrls[i], testFolders[i]);
        }
        block4: for (Element ppElement : root.getChildren("packagePrefix")) {
            String prefix = ppElement.getAttributeValue("value");
            String url = ppElement.getAttributeValue("url");
            for (SourceFolder folder : entry.getSourceFolders()) {
                if (!Comparing.strEqual((String)folder.getUrl(), (String)url)) continue;
                folder.setPackagePrefix(prefix);
                continue block4;
            }
        }
        String url = entry.getUrl();
        for (Element o : root.getChildren("excludeFolder")) {
            String excludeUrl = o.getAttributeValue("url");
            if (!FileUtil.isAncestor((File)new File(url), (File)new File(excludeUrl), (boolean)false)) continue;
            entry.addExcludeFolder(excludeUrl);
        }
    }

    public static boolean writeIdeaSpecificClasspath(@NotNull Element root, @NotNull ModuleRootModel model) {
        LanguageLevelModuleExtensionImpl languageLevelModuleExtension;
        if (root == null) {
            IdeaSpecificSettings.$$$reportNull$$$0(0);
        }
        if (model == null) {
            IdeaSpecificSettings.$$$reportNull$$$0(1);
        }
        boolean isModified = false;
        CompilerModuleExtension compilerModuleExtension = (CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class);
        if (compilerModuleExtension.getCompilerOutputUrlForTests() != null) {
            Element pathElement = new Element("output-test");
            pathElement.setAttribute("url", compilerModuleExtension.getCompilerOutputUrlForTests());
            root.addContent(pathElement);
            isModified = true;
        }
        if (compilerModuleExtension.isCompilerOutputPathInherited()) {
            root.setAttribute("inherit-compiler-output", String.valueOf(true));
            isModified = true;
        }
        if (compilerModuleExtension.isExcludeOutput()) {
            root.addContent(new Element("exclude-output"));
            isModified = true;
        }
        if ((languageLevelModuleExtension = (LanguageLevelModuleExtensionImpl)model.getModuleExtension(LanguageLevelModuleExtensionImpl.class)).getLanguageLevel() != null) {
            XmlSerializer.serializeStateInto((PersistentStateComponent)languageLevelModuleExtension, (Element)root);
            isModified = true;
        }
        for (ContentEntry entry : model.getContentEntries()) {
            Element contentEntryElement = new Element("contentEntry");
            contentEntryElement.setAttribute("url", entry.getUrl());
            root.addContent(contentEntryElement);
            for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                String packagePrefix;
                if (sourceFolder.isTestSource()) {
                    Element element = new Element("testFolder");
                    contentEntryElement.addContent(element);
                    element.setAttribute("url", sourceFolder.getUrl());
                    isModified = true;
                }
                if (StringUtil.isEmptyOrSpaces((String)(packagePrefix = sourceFolder.getPackagePrefix()))) continue;
                Element element = new Element("packagePrefix");
                contentEntryElement.addContent(element);
                element.setAttribute("url", sourceFolder.getUrl());
                element.setAttribute("value", packagePrefix);
                isModified = true;
            }
            VirtualFile entryFile = entry.getFile();
            for (ExcludeFolder excludeFolder : entry.getExcludeFolders()) {
                VirtualFile excludeFile = excludeFolder.getFile();
                if (entryFile != null && excludeFile != null && !VfsUtilCore.isAncestor((VirtualFile)entryFile, (VirtualFile)excludeFile, (boolean)false)) continue;
                Element element = new Element("excludeFolder");
                contentEntryElement.addContent(element);
                element.setAttribute("url", excludeFolder.getUrl());
                isModified = true;
            }
        }
        LinkedHashMap<String, String> libLevels = new LinkedHashMap<String, String>();
        for (OrderEntry entry : model.getOrderEntries()) {
            DependencyScope scope;
            if (entry instanceof ModuleOrderEntry && !(scope = ((ModuleOrderEntry)entry).getScope()).equals((Object)DependencyScope.COMPILE)) {
                Element element = new Element("module");
                element.setAttribute("name", ((ModuleOrderEntry)entry).getModuleName());
                element.setAttribute("scope", scope.name());
                root.addContent(element);
                isModified = true;
            }
            if (entry instanceof JdkOrderEntry) {
                Sdk jdk = ((JdkOrderEntry)entry).getJdk();
                if (EclipseModuleManagerImpl.getInstance(entry.getOwnerModule()).getInvalidJdk() != null || jdk != null) {
                    if (entry instanceof InheritedJdkOrderEntry) {
                        root.setAttribute(INHERIT_JDK, "true");
                    } else {
                        root.setAttribute("jdk", ((JdkOrderEntry)entry).getJdkName());
                        if (jdk != null) {
                            root.setAttribute("jdk_type", jdk.getSdkType().getName());
                        }
                    }
                    isModified = true;
                }
            }
            if (!(entry instanceof LibraryOrderEntry)) continue;
            Element element = new Element("lib");
            LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entry;
            String libraryName = ((LibraryOrderEntry)entry).getLibraryName();
            if (libraryName == null) {
                String[] urls = libraryEntry.getRootUrls(OrderRootType.CLASSES);
                if (urls.length > 0) {
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(urls[0]);
                    VirtualFile fileForJar = JarFileSystem.getInstance().getVirtualFileForJar(file);
                    if (fileForJar != null) {
                        file = fileForJar;
                    }
                    String string = libraryName = file != null ? file.getName() : null;
                }
                if (libraryName == null) {
                    libraryName = libraryEntry.getPresentableName();
                }
            }
            element.setAttribute("name", libraryName);
            DependencyScope scope2 = libraryEntry.getScope();
            element.setAttribute("scope", scope2.name());
            if (libraryEntry.isModuleLevel()) {
                String[] urls = libraryEntry.getRootUrls(OrderRootType.SOURCES);
                String eclipseUrl = null;
                if (urls.length > 0) {
                    eclipseUrl = urls[0];
                    int jarSeparatorIdx = urls[0].indexOf("!/");
                    if (jarSeparatorIdx > -1) {
                        eclipseUrl = eclipseUrl.substring(0, jarSeparatorIdx);
                    }
                }
                for (String url : urls) {
                    Element srcElement = new Element(SRCROOT_ATTR);
                    srcElement.setAttribute("url", url);
                    if (!EPathUtil.areUrlsPointTheSame(url, eclipseUrl)) {
                        srcElement.setAttribute(SRCROOT_BIND_ATTR, String.valueOf(false));
                    }
                    element.addContent(srcElement);
                }
                String[] javadocUrls = libraryEntry.getRootUrls(JavadocOrderRootType.getInstance());
                for (int i = 1; i < javadocUrls.length; ++i) {
                    Element javadocElement = new Element(JAVADOCROOT_ATTR);
                    javadocElement.setAttribute("url", javadocUrls[i]);
                    element.addContent(javadocElement);
                }
                for (String srcUrl : libraryEntry.getRootUrls(OrderRootType.SOURCES)) {
                    IdeaSpecificSettings.appendModuleRelatedRoot(element, srcUrl, RELATIVE_MODULE_SRC, model);
                }
                for (String classesUrl : libraryEntry.getRootUrls(OrderRootType.CLASSES)) {
                    IdeaSpecificSettings.appendModuleRelatedRoot(element, classesUrl, RELATIVE_MODULE_CLS, model);
                }
                for (String javadocUrl : libraryEntry.getRootUrls(JavadocOrderRootType.getInstance())) {
                    IdeaSpecificSettings.appendModuleRelatedRoot(element, javadocUrl, RELATIVE_MODULE_JAVADOC, model);
                }
                if (!element.getChildren().isEmpty()) {
                    root.addContent(element);
                    isModified = true;
                    continue;
                }
            } else {
                String libraryLevel = libraryEntry.getLibraryLevel();
                if (!"application".equals(libraryLevel)) {
                    libLevels.put(libraryEntry.getLibraryName(), libraryLevel);
                }
            }
            if (scope2.equals((Object)DependencyScope.COMPILE)) continue;
            root.addContent(element);
            isModified = true;
        }
        if (!libLevels.isEmpty()) {
            Element libLevelsElement = new Element("levels");
            for (String libName : libLevels.keySet()) {
                Element libElement = new Element("level");
                libElement.setAttribute("name", libName);
                libElement.setAttribute("value", (String)libLevels.get(libName));
                libLevelsElement.addContent(libElement);
            }
            root.addContent(libLevelsElement);
        }
        PathMacroManager.getInstance((ComponentManager)model.getModule()).collapsePaths(root);
        return isModified;
    }

    public static void replaceModuleRelatedRoots(Project project, Library.ModifiableModel modifiableModel, Element libElement, OrderRootType orderRootType, String relativeModuleName) {
        ArrayList<String> urls = new ArrayList<String>(Arrays.asList(modifiableModel.getUrls(orderRootType)));
        block0: for (Element r : libElement.getChildren(relativeModuleName)) {
            String root = PathMacroManager.getInstance((ComponentManager)project).expandPath(r.getAttributeValue(PROJECT_RELATED));
            Iterator iterator = urls.iterator();
            while (iterator.hasNext()) {
                String url = (String)iterator.next();
                if (!EPathUtil.areUrlsPointTheSame(root, url)) continue;
                iterator.remove();
                modifiableModel.removeRoot(url, orderRootType);
                modifiableModel.addRoot(root, orderRootType);
                continue block0;
            }
        }
    }

    public static void appendModuleRelatedRoot(Element element, String classesUrl, String rootName, ModuleRootModel model) {
        Module module;
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(classesUrl);
        if (file == null) {
            return;
        }
        Project project = model.getModule().getProject();
        if (file.getFileSystem() instanceof JarFileSystem) {
            file = JarFileSystem.getInstance().getVirtualFileForJar(file);
            assert (file != null);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null) {
            IdeaSpecificSettings.appendRelatedToModule(element, classesUrl, rootName, file, module);
        } else if (ProjectRootManager.getInstance((Project)project).getFileIndex().isExcluded(file)) {
            for (Module aModule : ModuleManager.getInstance((Project)project).getModules()) {
                if (!IdeaSpecificSettings.appendRelatedToModule(element, classesUrl, rootName, file, aModule)) continue;
                return;
            }
        }
    }

    private static boolean appendRelatedToModule(Element element, String classesUrl, String rootName, VirtualFile file, Module module) {
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) continue;
            Element clsElement = new Element(rootName);
            clsElement.setAttribute(PROJECT_RELATED, PathMacroManager.getInstance((ComponentManager)module.getProject()).collapsePath(classesUrl));
            element.addContent(clsElement);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/eclipse/conversion/IdeaSpecificSettings";
        objectArray[2] = "writeIdeaSpecificClasspath";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

