/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.EclipseJDOMUtil;
import org.jetbrains.annotations.NotNull;

public class DotProjectFileHelper {
    private static final Logger LOG = Logger.getInstance(DotProjectFileHelper.class);

    private DotProjectFileHelper() {
    }

    public static void saveDotProjectFile(@NotNull Module module, @NotNull String storageRoot) throws IOException {
        if (module == null) {
            DotProjectFileHelper.$$$reportNull$$$0(0);
        }
        if (storageRoot == null) {
            DotProjectFileHelper.$$$reportNull$$$0(1);
        }
        try {
            Document doc = ModuleType.get((Module)module) instanceof JavaModuleType ? JDOMUtil.loadDocument((URL)DotProjectFileHelper.class.getResource("template.project.xml")) : JDOMUtil.loadDocument((URL)DotProjectFileHelper.class.getResource("template.empty.project.xml"));
            doc.getRootElement().getChild("name").setText(module.getName());
            File projectFile = new File(storageRoot, ".project");
            if (!FileUtil.createIfDoesntExist((File)projectFile)) {
                return;
            }
            EclipseJDOMUtil.output(doc.getRootElement(), projectFile, module.getProject());
            ApplicationManager.getApplication().runWriteAction(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)projectFile.getPath())));
        }
        catch (JDOMException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "storageRoot";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/eclipse/conversion/DotProjectFileHelper";
        objectArray[2] = "saveDotProjectFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

