/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.slf4j;

import hidden.org.slf4j.ILoggerFactory;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.helpers.SubstituteLoggerFactory;
import hidden.org.slf4j.helpers.Util;
import hidden.org.slf4j.impl.StaticLoggerBinder;
import java.util.Arrays;
import java.util.List;

public final class LoggerFactory {
    static final String NO_STATICLOGGERBINDER_URL = "http://www.slf4j.org/codes.html#StaticLoggerBinder";
    static final String NULL_LF_URL = "http://www.slf4j.org/codes.html#null_LF";
    static final String VERSION_MISMATCH = "http://www.slf4j.org/codes.html#version_mismatch";
    static final String SUBSTITUTE_LOGGER_URL = "http://www.slf4j.org/codes.html#substituteLogger";
    static final String UNSUCCESSFUL_INIT_URL = "http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String UNSUCCESSFUL_INIT_MSG = "hidden.org.slf4j.LoggerFactory could not be successfully initialized. See also http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final int UNINITIALIZED = 0;
    static final int ONGOING_INITILIZATION = 1;
    static final int FAILED_INITILIZATION = 2;
    static final int SUCCESSFUL_INITILIZATION = 3;
    static final int GET_SINGLETON_INEXISTENT = 1;
    static final int GET_SINGLETON_EXISTS = 2;
    static int INITIALIZATION_STATE = 0;
    static int GET_SINGLETON_METHOD = 0;
    static SubstituteLoggerFactory TEMP_FACTORY = new SubstituteLoggerFactory();
    private static final String[] API_COMPATIBILITY_LIST = new String[]{"1.5.5", "1.5.6"};

    private LoggerFactory() {
    }

    static void reset() {
        INITIALIZATION_STATE = 0;
        GET_SINGLETON_METHOD = 0;
        TEMP_FACTORY = new SubstituteLoggerFactory();
    }

    private static final void performInitialization() {
        LoggerFactory.bind();
        LoggerFactory.versionSanityCheck();
    }

    private static final void bind() {
        try {
            LoggerFactory.getSingleton();
            INITIALIZATION_STATE = 3;
            LoggerFactory.emitSubstitureLoggerWarning();
        }
        catch (NoClassDefFoundError ncde) {
            INITIALIZATION_STATE = 2;
            String msg = ncde.getMessage();
            if (msg != null && msg.indexOf("hidden/org/slf4j/impl/StaticLoggerBinder") != -1) {
                Util.reportFailure("Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
                Util.reportFailure("See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
            }
            throw ncde;
        }
        catch (Exception e) {
            INITIALIZATION_STATE = 2;
            Util.reportFailure("Failed to instantiate logger [" + LoggerFactory.getSingleton().getLoggerFactoryClassStr() + "]", e);
        }
    }

    private static final void emitSubstitureLoggerWarning() {
        List loggerNameList = TEMP_FACTORY.getLoggerNameList();
        if (loggerNameList.size() == 0) {
            return;
        }
        Util.reportFailure("The following loggers will not work becasue they were created");
        Util.reportFailure("during the default configuration phase of the underlying logging system.");
        Util.reportFailure("See also http://www.slf4j.org/codes.html#substituteLogger");
        for (int i = 0; i < loggerNameList.size(); ++i) {
            String loggerName = (String)loggerNameList.get(i);
            Util.reportFailure(loggerName);
        }
    }

    private static final void versionSanityCheck() {
        try {
            String requested = StaticLoggerBinder.REQUESTED_API_VERSION;
            boolean match = false;
            for (int i = 0; i < API_COMPATIBILITY_LIST.length; ++i) {
                if (!API_COMPATIBILITY_LIST[i].equals(requested)) continue;
                match = true;
            }
            if (!match) {
                Util.reportFailure("The requested version " + requested + " by your slf4j binding is not compatible with " + Arrays.toString(API_COMPATIBILITY_LIST));
                Util.reportFailure("See http://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
        }
        catch (NoSuchFieldError nsfe) {
        }
        catch (Throwable e) {
            Util.reportFailure("Unexpected problem occured during version sanity check", e);
        }
    }

    private static final StaticLoggerBinder getSingleton() {
        if (GET_SINGLETON_METHOD == 1) {
            return StaticLoggerBinder.SINGLETON;
        }
        if (GET_SINGLETON_METHOD == 2) {
            return StaticLoggerBinder.getSingleton();
        }
        try {
            StaticLoggerBinder singleton = StaticLoggerBinder.getSingleton();
            GET_SINGLETON_METHOD = 2;
            return singleton;
        }
        catch (NoSuchMethodError nsme) {
            GET_SINGLETON_METHOD = 1;
            return StaticLoggerBinder.SINGLETON;
        }
    }

    public static Logger getLogger(String name) {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        return iLoggerFactory.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static ILoggerFactory getILoggerFactory() {
        if (INITIALIZATION_STATE == 0) {
            INITIALIZATION_STATE = 1;
            LoggerFactory.performInitialization();
        }
        switch (INITIALIZATION_STATE) {
            case 3: {
                return LoggerFactory.getSingleton().getLoggerFactory();
            }
            case 2: {
                throw new IllegalStateException(UNSUCCESSFUL_INIT_MSG);
            }
            case 1: {
                return TEMP_FACTORY;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }
}

