/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt.idea;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.AbstractKotlinGradleModelBuilder;
import org.jetbrains.kotlin.kapt.idea.KaptGradleModel;
import org.jetbrains.kotlin.kapt.idea.KaptGradleModelImpl;
import org.jetbrains.kotlin.kapt.idea.KaptSourceSetModelImpl;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/kapt/idea/KaptModelBuilderService;", "Lorg/jetbrains/kotlin/gradle/AbstractKotlinGradleModelBuilder;", "()V", "buildAll", "", "modelName", "", "project", "Lorg/gradle/api/Project;", "canBuild", "", "getErrorMessageBuilder", "Lorg/jetbrains/plugins/gradle/tooling/ErrorMessageBuilder;", "e", "Ljava/lang/Exception;", "getKaptDirectory", "funName", "sourceSetName", "kapt3-idea"})
public final class KaptModelBuilderService
extends AbstractKotlinGradleModelBuilder {
    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        ErrorMessageBuilder errorMessageBuilder = ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Gradle import errors").withDescription("Unable to build kotlin-kapt plugin configuration");
        Intrinsics.checkExpressionValueIsNotNull((Object)errorMessageBuilder, (String)"ErrorMessageBuilder.crea\u2026pt plugin configuration\")");
        return errorMessageBuilder;
    }

    public boolean canBuild(@Nullable String modelName) {
        return Intrinsics.areEqual((Object)modelName, (Object)KaptGradleModel.class.getName());
    }

    @NotNull
    public Object buildAll(@Nullable String modelName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Plugin kaptPlugin = project.getPlugins().findPlugin("kotlin-kapt");
        boolean kaptIsEnabled = kaptPlugin != null;
        List sourceSets = new ArrayList();
        if (kaptIsEnabled) {
            Set set = (Set)project.getAllTasks(false).get(project);
            if (set != null) {
                Iterable $receiver$iv = set;
                for (Object element$iv : $receiver$iv) {
                    String sourceSetName;
                    String string;
                    Task compileTask = (Task)element$iv;
                    if (!AbstractKotlinGradleModelBuilder.Companion.getKotlinCompileTaskClasses().contains(compileTask.getClass().getName())) continue;
                    Task task = compileTask;
                    Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"compileTask");
                    String string2 = string = (sourceSetName = AbstractKotlinGradleModelBuilder.Companion.getSourceSetName(task));
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    boolean isTest = StringsKt.endsWith$default((String)string3, (String)"test", (boolean)false, (int)2, null);
                    String kaptGeneratedSourcesDir = this.getKaptDirectory("getKaptGeneratedSourcesDir", project, sourceSetName);
                    String kaptGeneratedClassesDir = this.getKaptDirectory("getKaptGeneratedClassesDir", project, sourceSetName);
                    String kaptGeneratedKotlinSourcesDir = this.getKaptDirectory("getKaptGeneratedKotlinSourcesDir", project, sourceSetName);
                    Collection collection = sourceSets;
                    KaptSourceSetModelImpl kaptSourceSetModelImpl = new KaptSourceSetModelImpl(sourceSetName, isTest, kaptGeneratedSourcesDir, kaptGeneratedClassesDir, kaptGeneratedKotlinSourcesDir);
                    collection.add(kaptSourceSetModelImpl);
                }
            }
        }
        File file = project.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
        return new KaptGradleModelImpl(kaptIsEnabled, file, sourceSets);
    }

    private final String getKaptDirectory(String funName, Project project, String sourceSetName) {
        Object object;
        Method method;
        block5: {
            Plugin plugin = project.getPlugins().findPlugin("kotlin-kapt");
            if (plugin == null) {
                return "";
            }
            Plugin kotlinKaptPlugin = plugin;
            Method[] methodArray = kotlinKaptPlugin.getClass().getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"kotlinKaptPlugin::class.java.methods");
            Method[] $receiver$iv = methodArray;
            int n = $receiver$iv.length;
            for (int i = 0; i < n; ++i) {
                Method element$iv;
                Method it;
                Method method2 = it = (element$iv = $receiver$iv[i]);
                Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"it");
                if (!(Modifier.isStatic(method2.getModifiers()) && Intrinsics.areEqual((Object)it.getName(), (Object)funName) && it.getParameterCount() == 2)) continue;
                method = element$iv;
                break block5;
            }
            method = null;
        }
        if (method == null) {
            return "";
        }
        Method targetMethod = method;
        Object object2 = targetMethod.invoke(null, project, sourceSetName);
        if (!(object2 instanceof File)) {
            object2 = null;
        }
        if ((object = (File)object2) == null || (object = ((File)object).getAbsolutePath()) == null) {
            object = "";
        }
        return object;
    }
}

