/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library.propertiesEditor;

import com.google.common.base.Strings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RepositoryLibraryPropertiesModel {
    private String version;
    private boolean downloadSources;
    private boolean downloadJavaDocs;
    private boolean includeTransitiveDependencies;
    private List<String> myExcludedDependencies;

    public RepositoryLibraryPropertiesModel(String version, boolean downloadSources, boolean downloadJavaDocs) {
        this(version, downloadSources, downloadJavaDocs, true, ContainerUtil.emptyList());
    }

    public RepositoryLibraryPropertiesModel(String version, boolean downloadSources, boolean downloadJavaDocs, boolean includeTransitiveDependencies, List<String> excludedDependencies) {
        this.version = version;
        this.downloadSources = downloadSources;
        this.downloadJavaDocs = downloadJavaDocs;
        this.includeTransitiveDependencies = includeTransitiveDependencies;
        this.myExcludedDependencies = new ArrayList<String>(excludedDependencies);
    }

    public RepositoryLibraryPropertiesModel clone() {
        return new RepositoryLibraryPropertiesModel(this.version, this.downloadSources, this.downloadJavaDocs, this.includeTransitiveDependencies, new ArrayList<String>(this.myExcludedDependencies));
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.version);
    }

    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    public void setIncludeTransitiveDependencies(boolean includeTransitiveDependencies) {
        this.includeTransitiveDependencies = includeTransitiveDependencies;
    }

    public List<String> getExcludedDependencies() {
        return this.myExcludedDependencies;
    }

    public void setExcludedDependencies(Collection<String> excludedDependencies) {
        this.myExcludedDependencies = new ArrayList<String>(excludedDependencies);
    }

    public boolean isDownloadSources() {
        return this.downloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
    }

    public boolean isDownloadJavaDocs() {
        return this.downloadJavaDocs;
    }

    public void setDownloadJavaDocs(boolean downloadJavaDocs) {
        this.downloadJavaDocs = downloadJavaDocs;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryLibraryPropertiesModel model = (RepositoryLibraryPropertiesModel)o;
        if (this.downloadSources != model.downloadSources) {
            return false;
        }
        if (this.downloadJavaDocs != model.downloadJavaDocs) {
            return false;
        }
        if (this.includeTransitiveDependencies != model.includeTransitiveDependencies) {
            return false;
        }
        if (this.version != null ? !this.version.equals(model.version) : model.version != null) {
            return false;
        }
        return this.myExcludedDependencies.equals(model.myExcludedDependencies);
    }

    public int hashCode() {
        int result = this.downloadSources ? 1 : 0;
        result = 31 * result + (this.downloadJavaDocs ? 1 : 0);
        result = 31 * result + (this.includeTransitiveDependencies ? 1 : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + this.myExcludedDependencies.hashCode();
        return result;
    }
}

