/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dom;

import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.dom.DomAttributeXmlDescriptor;
import com.intellij.xml.impl.dom.DomElementXmlDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomChildrenDescriptor
implements XmlElementDescriptor {
    protected final DomManager myManager;

    protected AbstractDomChildrenDescriptor(DomManager manager) {
        this.myManager = manager;
    }

    public XmlElementDescriptor[] getElementsDescriptors(final XmlTag context) {
        final DomElement domElement = this.myManager.getDomElement(context);
        if (domElement == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<AbstractDomChildrenDescriptor> xmlElementDescriptors = new ArrayList<AbstractDomChildrenDescriptor>();
        for (DomCollectionChildDescription childrenDescription : domElement.getGenericInfo().getCollectionChildrenDescriptions()) {
            xmlElementDescriptors.add(new DomElementXmlDescriptor((DomChildrenDescription)childrenDescription, this.myManager));
        }
        for (DomCollectionChildDescription childrenDescription : domElement.getGenericInfo().getFixedChildrenDescriptions()) {
            xmlElementDescriptors.add(new DomElementXmlDescriptor((DomChildrenDescription)childrenDescription, this.myManager));
        }
        List customs = domElement.getGenericInfo().getCustomNameChildrenDescription();
        for (CustomDomChildrenDescription custom : customs) {
            final CustomDomChildrenDescription.TagNameDescriptor tagNameDescriptor = custom.getTagNameDescriptor();
            if (tagNameDescriptor == null) continue;
            final XmlTag xmlTag = domElement.getXmlTag();
            for (final EvaluatedXmlName name2 : tagNameDescriptor.getCompletionVariants(domElement)) {
                AbstractDomChildrenDescriptor descriptor2 = new AbstractDomChildrenDescriptor(this.myManager){

                    public String getDefaultName() {
                        String prefix;
                        String ns;
                        String string = ns = xmlTag != null ? name2.getNamespace((XmlElement)xmlTag, (XmlFile)xmlTag.getContainingFile()) : null;
                        if (ns != null && (prefix = xmlTag.getPrefixByNamespace(ns)) != null) {
                            return prefix + ":" + name2.getXmlName().getLocalName();
                        }
                        return name2.getXmlName().getLocalName();
                    }

                    @Nullable
                    public PsiElement getDeclaration() {
                        PomTarget target = tagNameDescriptor.findDeclaration(domElement, name2);
                        return target == null ? null : PomService.convertToPsi((Project)context.getProject(), (PomTarget)target);
                    }
                };
                xmlElementDescriptors.add(descriptor2);
            }
            xmlElementDescriptors.add((AbstractDomChildrenDescriptor)new AnyXmlElementDescriptor((XmlElementDescriptor)this, this.getNSDescriptor()));
        }
        return xmlElementDescriptors.toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(final @NotNull XmlTag childTag, @Nullable XmlTag contextTag) {
        DomElement domElement;
        if (childTag == null) {
            AbstractDomChildrenDescriptor.$$$reportNull$$$0(0);
        }
        if ((domElement = this.myManager.getDomElement(childTag)) == null) {
            AbstractDomChildrenDescription description;
            domElement = this.myManager.getDomElement(contextTag);
            if (domElement != null && (description = this.myManager.findChildrenDescription(childTag, domElement)) instanceof DomChildrenDescription) {
                return new DomElementXmlDescriptor((DomChildrenDescription)description, this.myManager);
            }
            return null;
        }
        DomElement parent = domElement.getParent();
        if (parent == null) {
            return new DomElementXmlDescriptor(domElement);
        }
        final AbstractDomChildrenDescription description = domElement.getChildDescription();
        if (description instanceof CustomDomChildrenDescription) {
            final DomElement finalDomElement = domElement;
            return new AbstractDomChildrenDescriptor(this.myManager){

                public String getDefaultName() {
                    return finalDomElement.getXmlElementName();
                }

                @Nullable
                public PsiElement getDeclaration() {
                    PomTarget target = ((CustomDomChildrenDescription)description).getTagNameDescriptor().findDeclaration(finalDomElement);
                    if (target == description) {
                        return childTag;
                    }
                    return target == null ? null : PomService.convertToPsi((Project)childTag.getProject(), (PomTarget)target);
                }
            };
        }
        if (!(description instanceof DomChildrenDescription)) {
            return null;
        }
        return new DomElementXmlDescriptor((DomChildrenDescription)description, this.myManager);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        if (context == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        DomElement domElement = this.myManager.getDomElement(context);
        if (domElement == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        List descriptions = domElement.getGenericInfo().getAttributeChildrenDescriptions();
        ArrayList<DomAttributeXmlDescriptor> descriptors = new ArrayList<DomAttributeXmlDescriptor>();
        for (DomAttributeChildDescription description : descriptions) {
            descriptors.add(new DomAttributeXmlDescriptor(description, this.myManager.getProject()));
        }
        List customs = domElement.getGenericInfo().getCustomNameChildrenDescription();
        for (CustomDomChildrenDescription custom : customs) {
            CustomDomChildrenDescription.AttributeDescriptor descriptor2 = custom.getCustomAttributeDescriptor();
            if (descriptor2 == null) continue;
            for (EvaluatedXmlName variant : descriptor2.getCompletionVariants(domElement)) {
                AttributeChildDescriptionImpl childDescription = new AttributeChildDescriptionImpl(variant.getXmlName(), (Type)((Object)String.class));
                descriptors.add(new DomAttributeXmlDescriptor(childDescription, this.myManager.getProject()));
            }
        }
        return descriptors.toArray(XmlAttributeDescriptor.EMPTY);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, @Nullable XmlTag context) {
        DomElement domElement = this.myManager.getDomElement(context);
        if (domElement == null) {
            return null;
        }
        for (DomAttributeChildDescription description : domElement.getGenericInfo().getAttributeChildrenDescriptions()) {
            if (!attributeName.equals(DomAttributeXmlDescriptor.getQualifiedAttributeName((PsiElement)context, description.getXmlName()))) continue;
            return new DomAttributeXmlDescriptor(description, this.myManager.getProject());
        }
        return null;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return new XmlNSDescriptor(){

            @Nullable
            public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
                if (tag == null) {
                    3.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException("Method getElementDescriptor not implemented in " + this.getClass());
            }

            @NotNull
            public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
                throw new UnsupportedOperationException("Method getRootElementsDescriptors not implemented in " + this.getClass());
            }

            @Nullable
            public XmlFile getDescriptorFile() {
                return null;
            }

            @Nullable
            public PsiElement getDeclaration() {
                throw new UnsupportedOperationException("Method getDeclaration not implemented in " + this.getClass());
            }

            @NonNls
            public String getName(PsiElement context) {
                throw new UnsupportedOperationException("Method getName not implemented in " + this.getClass());
            }

            @NonNls
            public String getName() {
                throw new UnsupportedOperationException("Method getName not implemented in " + this.getClass());
            }

            public void init(PsiElement element) {
                throw new UnsupportedOperationException("Method init not implemented in " + this.getClass());
            }

            @NotNull
            public Object[] getDependences() {
                throw new UnsupportedOperationException("Method getDependences not implemented in " + this.getClass());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/impl/dom/AbstractDomChildrenDescriptor$3", "getElementDescriptor"));
            }
        };
    }

    public int getContentType() {
        return -1;
    }

    public String getDefaultValue() {
        return null;
    }

    public void init(PsiElement element) {
        throw new UnsupportedOperationException("Method init not implemented in " + this.getClass());
    }

    @NotNull
    public Object[] getDependences() {
        throw new UnsupportedOperationException("Method getDependences not implemented in " + this.getClass());
    }

    @NonNls
    public String getName() {
        return this.getDefaultName();
    }

    public String getQualifiedName() {
        return this.getDefaultName();
    }

    public String getName(PsiElement context) {
        return this.getDefaultName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTag", "com/intellij/xml/impl/dom/AbstractDomChildrenDescriptor", "getElementDescriptor"));
    }
}

