/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.ImperativeCommand;

public class StripTestDataMarkup
extends ActionOnFile {
    public StripTestDataMarkup(PsiFile file) {
        super(file);
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        if (env == null) {
            StripTestDataMarkup.$$$reportNull$$$0(0);
        }
        env.logMessage(this.toString());
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            Document document = this.getDocument();
            new ExpectedHighlightingData(document, true, true, true, true, this.getFile()).init();
            StripTestDataMarkup.removeMarkup(document, "<caret>");
            StripTestDataMarkup.removeMarkup(document, "<ref>");
            StripTestDataMarkup.removeMarkup(document, "<selection>");
            StripTestDataMarkup.removeMarkup(document, "</selection>");
        });
        PsiTestUtil.checkPsiStructureWithCommit(this.getFile(), PsiTestUtil::checkStubsMatchText);
    }

    private static void removeMarkup(Document document, String marker) {
        document.setText((CharSequence)StringUtil.replace((String)document.getText(), (String)marker, (String)""));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/testFramework/propertyBased/StripTestDataMarkup", "performCommand"));
    }
}

