/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.propertyBased.CheckPsiTextConsistency;
import com.intellij.testFramework.propertyBased.DeleteRange;
import com.intellij.testFramework.propertyBased.InsertString;
import com.intellij.testFramework.propertyBased.MadTestingAction;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.DataStructure;
import org.jetbrains.jetCheck.Generator;

public class MadTestingUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.propertyBased.MadTestingUtil");

    public static void restrictChangesToDocument(Document document, Runnable r) {
        MadTestingUtil.letSaveAllDocumentsPassIfAny();
        MadTestingUtil.watchDocumentChanges(r::run, event -> {
            VirtualFile file;
            Document changed = event.getDocument();
            if (changed != document && (file = FileDocumentManager.getInstance().getFile(changed)) != null && file.isInLocalFileSystem()) {
                throw new AssertionError((Object)("Unexpected document change: " + changed));
            }
        });
    }

    private static void letSaveAllDocumentsPassIfAny() {
        UIUtil.dispatchAllInvocationEvents();
    }

    public static void prohibitDocumentChanges(Runnable r) {
        MadTestingUtil.letSaveAllDocumentsPassIfAny();
        MadTestingUtil.watchDocumentChanges(r::run, event -> {
            Document changed = event.getDocument();
            VirtualFile file = FileDocumentManager.getInstance().getFile(changed);
            if (file != null && file.isInLocalFileSystem()) {
                throw new AssertionError((Object)("Unexpected document change: " + changed));
            }
        });
    }

    private static <E extends Throwable> void watchDocumentChanges(ThrowableRunnable<E> r, final Consumer<DocumentEvent> eventHandler) throws E {
        Disposable disposable = Disposer.newDisposable();
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                eventHandler.accept(event);
            }
        }, disposable);
        try {
            r.run();
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    public static void changeAndRevert(Project project2, Runnable r) {
        Label label = LocalHistory.getInstance().putUserLabel(project2, "changeAndRevert");
        boolean failed = false;
        try {
            r.run();
        }
        catch (Throwable e) {
            failed = true;
            throw e;
        }
        finally {
            MadTestingUtil.restoreEverything(label, failed, project2);
        }
    }

    private static void restoreEverything(Label label, boolean failed, Project project2) {
        try {
            WriteAction.run(() -> {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
                new RunAll(() -> PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting(), () -> FileEditorManagerEx.getInstanceEx((Project)project2).closeAllFiles(), () -> FileDocumentManager.getInstance().saveAllDocuments(), () -> MadTestingUtil.revertVfs(label, project2), () -> documentManager.commitAllDocuments(), () -> UsefulTestCase.assertEmpty(documentManager.getUncommittedDocuments()), () -> UsefulTestCase.assertEmpty(FileDocumentManager.getInstance().getUnsavedDocuments())).run();
            });
        }
        catch (Throwable e) {
            if (failed) {
                LOG.info("Exceptions while restoring state", e);
            }
            throw e;
        }
    }

    private static void revertVfs(Label label, Project project2) throws LocalHistoryException {
        MadTestingUtil.watchDocumentChanges(() -> label.revert(project2, project2.getBaseDir()), __ -> {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            if (documentManager.getUncommittedDocuments().length > 3) {
                documentManager.commitAllDocuments();
            }
        });
    }

    public static void enableAllInspections(Project project2, Disposable disposable, String ... except) {
        InspectionProfileImpl.INIT_INSPECTIONS = true;
        InspectionProfileImpl profile2 = new InspectionProfileImpl("allEnabled");
        profile2.enableAllTools(project2);
        MadTestingUtil.disableInspection(project2, profile2, "HighlightVisitorInternal");
        for (String shortId : except) {
            MadTestingUtil.disableInspection(project2, profile2, shortId);
        }
        ProjectInspectionProfileManager manager = (ProjectInspectionProfileManager)InspectionProjectProfileManager.getInstance((Project)project2);
        manager.addProfile(profile2);
        InspectionProfileImpl prev = manager.getCurrentProfile();
        manager.setCurrentProfile(profile2);
        Disposer.register((Disposable)disposable, () -> {
            InspectionProfileImpl.INIT_INSPECTIONS = false;
            manager.setCurrentProfile(prev);
            manager.deleteProfile(profile2);
        });
    }

    private static void disableInspection(Project project2, InspectionProfileImpl profile2, String shortId) {
        ToolsImpl tools = profile2.getToolsOrNull(shortId, project2);
        if (tools != null) {
            tools.setEnabled(false);
        }
    }

    private static Generator<File> randomFiles(final String rootPath, FileFilter fileFilter) {
        FileFilter interestingIdeaFiles = child -> {
            String name2 = child.getName();
            if (name2.startsWith(".")) {
                return false;
            }
            if (child.isDirectory()) {
                return MadTestingUtil.shouldGoInsiderDir(name2);
            }
            return !FileTypeManager.getInstance().getFileTypeByFileName(name2).isBinary() && fileFilter.accept(child) && child.length() < 500000L;
        };
        return Generator.from((Function)new FileGenerator(new File(rootPath), interestingIdeaFiles)).suchThat((Predicate)new Predicate<File>(){

            @Override
            public boolean test(File file) {
                return file != null;
            }

            public String toString() {
                return "can find a file under " + rootPath + " satisfying given filters";
            }
        }).noShrink();
    }

    @NotNull
    public static Supplier<MadTestingAction> actionsOnFileContents(CodeInsightTestFixture fixture, String rootPath, FileFilter fileFilter, Function<PsiFile, ? extends Generator<? extends MadTestingAction>> actions) {
        Generator<File> randomFiles = MadTestingUtil.randomFiles(rootPath, fileFilter);
        Supplier<MadTestingAction> supplier = () -> env -> new RunAll(new ThrowableRunnable[0]).append(() -> {
            File ioFile = (File)env.generateValue(randomFiles, "Working with %s");
            VirtualFile vFile = MadTestingUtil.copyFileToProject(ioFile, fixture, rootPath);
            PsiFile psiFile = fixture.getPsiManager().findFile(vFile);
            if (psiFile instanceof PsiBinaryFile || psiFile instanceof PsiPlainTextFile) {
                System.err.println("Can't check " + vFile + " due to incorrect file type: " + psiFile + " of " + psiFile.getClass());
                return;
            }
            env.executeCommands(Generator.from(data -> (MadTestingAction)data.generate((Generator)actions.apply(fixture.getPsiManager().findFile(vFile)))));
        }).append(() -> WriteAction.run(() -> {
            for (VirtualFile file : Objects.requireNonNull(fixture.getTempDirFixture().getFile("")).getChildren()) {
                file.delete((Object)fixture);
            }
        })).append(() -> PsiDocumentManager.getInstance((Project)fixture.getProject()).commitAllDocuments()).append(() -> UIUtil.dispatchAllInvocationEvents()).run();
        if (supplier == null) {
            MadTestingUtil.$$$reportNull$$$0(0);
        }
        return supplier;
    }

    private static boolean shouldGoInsiderDir(@NotNull String name2) {
        if (name2 == null) {
            MadTestingUtil.$$$reportNull$$$0(1);
        }
        return !name2.equals("gen") && !name2.equals("reports") && !name2.equals("android") && !MadTestingUtil.containsBinariesOnly(name2) && !name2.endsWith("system") && !name2.endsWith("config");
    }

    private static boolean containsBinariesOnly(@NotNull String name2) {
        if (name2 == null) {
            MadTestingUtil.$$$reportNull$$$0(2);
        }
        return name2.equals("jdk") || name2.equals("jre") || name2.equals("lib") || name2.equals("bin") || name2.equals("out");
    }

    @NotNull
    private static VirtualFile copyFileToProject(File ioFile, CodeInsightTestFixture fixture, String rootPath) {
        VirtualFile virtualFile;
        try {
            String path = FileUtil.getRelativePath((String)FileUtil.toCanonicalPath((String)rootPath), (String)FileUtil.toSystemIndependentName((String)ioFile.getPath()), (char)'/');
            assert (path != null);
            VirtualFile existing = fixture.getTempDirFixture().getFile(path);
            if (existing != null) {
                WriteAction.run(() -> existing.delete((Object)fixture));
            }
            virtualFile = fixture.addFileToProject(path, FileUtil.loadFile((File)ioFile)).getVirtualFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            MadTestingUtil.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public static Generator<MadTestingAction> randomEditsWithReparseChecks(PsiFile file) {
        Generator generator = Generator.sampledFrom((Object[])new MadTestingAction[]{new DeleteRange(file), new CheckPsiTextConsistency(file), new InsertString(file)});
        if (generator == null) {
            MadTestingUtil.$$$reportNull$$$0(4);
        }
        return generator;
    }

    public static boolean isAfterError(PsiFile file, int offset) {
        return SyntaxTraverser.psiTraverser((PsiElement)file).filter(PsiErrorElement.class).find(e -> e.getTextRange().getStartOffset() <= offset) != null;
    }

    public static boolean containsErrorElements(FileViewProvider viewProvider) {
        return ContainerUtil.exists((Iterable)viewProvider.getAllFiles(), file -> SyntaxTraverser.psiTraverser((PsiElement)file).filter(PsiErrorElement.class).isNotEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/propertyBased/MadTestingUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "actionsOnFileContents";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/propertyBased/MadTestingUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFileToProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "randomEditsWithReparseChecks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldGoInsiderDir";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsBinariesOnly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileGenerator
    implements Function<DataStructure, File> {
        private static final com.intellij.util.Function<File, JBIterable<File>> FS_TRAVERSAL = TreeTraversal.PRE_ORDER_DFS.traversal(f -> f.isDirectory() ? Arrays.asList((Object[])Objects.requireNonNull(f.listFiles())) : Collections.emptyList());
        private final File myRoot;
        private final FileFilter myFilter;

        public FileGenerator(File root, FileFilter filter) {
            this.myRoot = root;
            this.myFilter = filter;
        }

        @Override
        public File apply(DataStructure data) {
            return this.generateRandomFile(data, this.myRoot, new HashSet<File>());
        }

        @Nullable
        private File generateRandomFile(DataStructure data, File file, Set<File> exhausted) {
            List<File> toChoose;
            File chosen;
            File generated;
            do {
                File[] children;
                if ((children = file.listFiles(f -> !exhausted.contains(f) && FileGenerator.containsAtLeastOneFileDeep(f) && this.myFilter.accept(f))) == null) {
                    return file;
                }
                if (children.length == 0) {
                    exhausted.add(file);
                    return null;
                }
                toChoose = FileGenerator.preferDirs(data, children);
                Collections.sort(toChoose, Comparator.comparing(File::getName));
            } while ((generated = this.generateRandomFile(data, chosen = (File)data.generate(Generator.sampledFrom(toChoose)), exhausted)) == null);
            return generated;
        }

        private static boolean containsAtLeastOneFileDeep(File root) {
            return ((JBIterable)FS_TRAVERSAL.fun((Object)root)).find(f -> f.isFile()) != null;
        }

        private static List<File> preferDirs(DataStructure data, File[] children) {
            ArrayList files = new ArrayList();
            ArrayList<File> dirs = new ArrayList<File>();
            for (File child : children) {
                (child.isDirectory() ? dirs : files).add(child);
            }
            if (files.isEmpty() || dirs.isEmpty()) {
                return Arrays.asList(children);
            }
            int ratio = Math.max(100, dirs.size() / files.size());
            return (Integer)data.generate(Generator.integers((int)0, (int)(ratio - 1))) != 0 ? dirs : files;
        }
    }
}

