/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.IntentionPolicy;
import com.intellij.testFramework.propertyBased.MadTestingUtil;
import com.intellij.testFramework.propertyBased.RehighlightAllEditors;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;

public class InvokeIntention
extends ActionOnFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.propertyBased.InvokeIntention");
    private final IntentionPolicy myPolicy;

    public InvokeIntention(PsiFile file, IntentionPolicy policy) {
        super(file);
        this.myPolicy = policy;
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        if (env == null) {
            InvokeIntention.$$$reportNull$$$0(0);
        }
        int offset = this.generateDocOffset(env, "Go to offset %s and run daemon");
        this.doInvokeIntention(offset, env);
    }

    @Nullable
    private static IntentionAction chooseIntention(@NotNull ImperativeCommand.Environment env, List<IntentionAction> actions) {
        if (env == null) {
            InvokeIntention.$$$reportNull$$$0(1);
        }
        if (actions.isEmpty()) {
            env.logMessage("No intentions found");
            return null;
        }
        IntentionAction result = (IntentionAction)env.generateValue(Generator.sampledFrom(actions).noShrink(), null);
        env.logMessage("Invoke intention '" + result.getText() + "'");
        return result;
    }

    private void doInvokeIntention(int offset, ImperativeCommand.Environment env) {
        Project project2 = this.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, this.getVirtualFile(), offset), true);
        assert (editor != null);
        boolean containsErrorElements = MadTestingUtil.containsErrorElements(this.getFile().getViewProvider());
        boolean hasErrors = !InvokeIntention.highlightErrors(project2, editor).isEmpty() || containsErrorElements;
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)this.getProject());
        assert (file != null);
        IntentionAction intention = InvokeIntention.chooseIntention(env, this.getAvailableIntentions(editor, file));
        if (intention == null) {
            return;
        }
        String intentionString = intention.toString();
        boolean checkComments = this.myPolicy.checkComments(intention) && PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiComment.class, (boolean)false) == null;
        List<String> comments = checkComments ? this.extractCommentsReformattedToSingleWhitespace(file) : Collections.emptyList();
        boolean mayBreakCode = this.myPolicy.mayBreakCode(intention, editor, file);
        Document changedDocument = this.getDocumentToBeChanged(intention);
        String textBefore = changedDocument == null ? null : changedDocument.getText();
        Long stampBefore = changedDocument == null ? null : Long.valueOf(changedDocument.getModificationStamp());
        Disposable disposable = Disposer.newDisposable();
        if (containsErrorElements) {
            Registry.get((String)"ide.check.structural.psi.text.consistency.in.tests").setValue(false, disposable);
            Disposer.register((Disposable)disposable, this::restoreAfterPotentialPsiTextInconsistency);
        }
        Runnable r = () -> CodeInsightTestFixtureImpl.invokeIntention(intention, file, editor, intention.getText());
        try {
            if (changedDocument != null) {
                MadTestingUtil.restrictChangesToDocument(changedDocument, r);
            } else {
                r.run();
            }
            if (changedDocument != null && PsiDocumentManager.getInstance((Project)project2).isDocumentBlockedByPsi(changedDocument)) {
                throw new AssertionError((Object)"Document is left blocked by PSI");
            }
            if (!hasErrors && stampBefore != null && stampBefore.equals(changedDocument.getModificationStamp())) {
                String message = "No change was performed in the document";
                if (intention.startInWriteAction()) {
                    message = message + ".\nIf it's by design that " + intentionString + " doesn't change source files, it should return false from 'startInWriteAction'";
                }
                throw new AssertionError((Object)message);
            }
            PsiTestUtil.checkPsiStructureWithCommit(this.getFile(), PsiTestUtil::checkStubsMatchText);
            if (!mayBreakCode && !hasErrors) {
                InvokeIntention.checkNoNewErrors(project2, editor, intentionString);
            }
            if (checkComments) {
                List<String> fileComments = this.extractCommentsReformattedToSingleWhitespace(file);
                for (String comment : comments) {
                    if (!fileComments.contains(comment)) {
                        throw new AssertionError((Object)("Lost comment '" + comment + "' during " + intentionString));
                    }
                }
            }
        }
        catch (Throwable error) {
            LOG.debug("Error occurred, text before intention invocation:\n" + textBefore);
            env.logMessage("Error happened, the file's text before invoking printed to the debug log, search for 'text before intention invocation' there");
            throw error;
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private void restoreAfterPotentialPsiTextInconsistency() {
        PushedFilePropertiesUpdater.getInstance((Project)this.getProject()).filePropertiesChanged(this.getVirtualFile(), Conditions.alwaysTrue());
    }

    protected List<String> extractCommentsReformattedToSingleWhitespace(PsiFile file) {
        return PsiTreeUtil.findChildrenOfType((PsiElement)file, PsiComment.class).stream().filter(comment -> this.myPolicy.trackComment((PsiComment)comment)).map(comment -> comment.getText().replaceAll("[\\s*]+", " ")).collect(Collectors.toList());
    }

    private static void checkNoNewErrors(Project project2, Editor editor, String intentionString) {
        List<HighlightInfo> errors = InvokeIntention.highlightErrors(project2, editor);
        if (!errors.isEmpty()) {
            throw new AssertionError((Object)("New highlighting errors introduced after invoking " + intentionString + "\nIf this is correct, add it to IntentionPolicy#mayBreakCode.\nErrors found: " + StringUtil.join(errors, i -> InvokeIntention.shortInfoText(i), (String)",")));
        }
    }

    @NotNull
    private static String shortInfoText(HighlightInfo info) {
        String string = "'" + info.getDescription() + "'(" + info.startOffset + "," + info.endOffset + ")";
        if (string == null) {
            InvokeIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static List<HighlightInfo> highlightErrors(Project project2, Editor editor) {
        List<HighlightInfo> infos = RehighlightAllEditors.highlightEditor(editor, project2);
        List list = ContainerUtil.filter(infos, i -> i.getSeverity() == HighlightSeverity.ERROR);
        if (list == null) {
            InvokeIntention.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private Document getDocumentToBeChanged(IntentionAction intention) {
        PsiElement changedElement = intention.getElementToMakeWritable(this.getFile());
        PsiFile changedFile = changedElement == null ? null : changedElement.getContainingFile();
        return changedFile == null ? null : changedFile.getViewProvider().getDocument();
    }

    private List<IntentionAction> getAvailableIntentions(Editor editor, PsiFile file) {
        List actions = ContainerUtil.filter(CodeInsightTestFixtureImpl.getAvailableIntentions(editor, file), this.myPolicy::mayInvokeIntention);
        if (actions.isEmpty()) {
            return Collections.emptyList();
        }
        int offset = editor.getCaretModel().getOffset();
        if (MadTestingUtil.isAfterError(file, offset) || MadTestingUtil.isAfterError(file, offset - 1)) {
            return Collections.emptyList();
        }
        return actions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/propertyBased/InvokeIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/propertyBased/InvokeIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "shortInfoText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performCommand";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "chooseIntention";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

