/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.ImperativeCommand;

public class InsertLineComment
extends ActionOnFile {
    private final String myToInsert;

    public InsertLineComment(PsiFile file, String toInsert) {
        super(file);
        this.myToInsert = toInsert;
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        if (env == null) {
            InsertLineComment.$$$reportNull$$$0(0);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(this.getDocument());
        int randomOffset = this.generatePsiOffset(env, null);
        PsiElement leaf = this.getFile().findElementAt(randomOffset);
        TextRange leafRange = leaf != null ? leaf.getTextRange() : null;
        int insertOffset = leafRange != null ? leafRange.getEndOffset() : 0;
        env.logMessage("Inserting '" + StringUtil.escapeStringCharacters((String)this.myToInsert) + "' at " + insertOffset);
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> this.getDocument().insertString(insertOffset, (CharSequence)this.myToInsert));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/testFramework/propertyBased/InsertLineComment", "performCommand"));
    }
}

