/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LexerTestCase;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.DeleteRange;
import com.intellij.testFramework.propertyBased.InsertString;
import com.intellij.testFramework.propertyBased.MadTestingAction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;
import org.junit.Assert;

public class CheckHighlighterConsistency
extends ActionOnFile {
    @NotNull
    public static final Function<PsiFile, Generator<? extends MadTestingAction>> randomEditsWithHighlighterChecks = file -> {
        FileEditorManager.getInstance((Project)file.getProject()).openFile(file.getVirtualFile(), true);
        return Generator.sampledFrom((Object[])new ActionOnFile[]{new CheckHighlighterConsistency((PsiFile)file), new InsertString((PsiFile)file), new DeleteRange((PsiFile)file)});
    };

    public CheckHighlighterConsistency(PsiFile file) {
        super(file);
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        if (env == null) {
            CheckHighlighterConsistency.$$$reportNull$$$0(0);
        }
        env.logMessage(this.toString());
        Editor editor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedTextEditor();
        assert (editor.getDocument() == this.getDocument());
        CheckHighlighterConsistency.performCheck(editor);
    }

    public static void performCheck(@NotNull Editor editor) {
        if (editor == null) {
            CheckHighlighterConsistency.$$$reportNull$$$0(1);
        }
        LexerEditorHighlighter highlighter = (LexerEditorHighlighter)((EditorEx)editor).getHighlighter();
        CharSequence text = editor.getDocument().getImmutableCharSequence();
        String incremental = CheckHighlighterConsistency.dumpHighlighterTokens(highlighter, text);
        highlighter.setText((CharSequence)"");
        highlighter.setText(text);
        String full = CheckHighlighterConsistency.dumpHighlighterTokens(highlighter, text);
        if (!full.equals(incremental)) {
            Assert.assertEquals((Object)("Full lexer highlighter:\n" + full), (Object)("Incremental lexer highlighter:\n" + incremental));
        }
    }

    @NotNull
    private static String dumpHighlighterTokens(LexerEditorHighlighter highlighter, CharSequence text) {
        StringBuilder tokens = new StringBuilder();
        HighlighterIterator iterator = highlighter.createIterator(0);
        while (!iterator.atEnd()) {
            tokens.append(iterator.getStart()).append(" ").append(LexerTestCase.printSingleToken(text, iterator.getTokenType(), iterator.getStart(), iterator.getEnd()));
            iterator.advance();
        }
        String string = tokens.toString();
        if (string == null) {
            CheckHighlighterConsistency.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/propertyBased/CheckHighlighterConsistency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/propertyBased/CheckHighlighterConsistency";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpHighlighterTokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performCommand";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performCheck";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

